#include "MT2Util.h"

_mtag char *MT2NumToString(mint32_t num)
{
    static char buf[20];
    sprintf(buf, "%d", num);
    return buf;
}

_mtag mint64_t MT2StringToNum(const char *s)
{
    if(strlen(s) == 0)
    {
        return 0;
    }

    mbool_t negative = mfalse;
    const char *end = s;
    const char *p = s + strlen(s) - 1;
    mint64_t n = 0;
    mint64_t tmpN = 0;
    muint8_t ten = 0;

    //
    if(end[0] == '-')
    {
        negative = mtrue;
        end++;
    }

    while(1)
    {
        tmpN = p[0] - '0';
        muint8_t i;
        for(i = 0; i < ten; i++)
        {
            tmpN *= 10;
        }
        n += tmpN;

        if(p == end)
        {
            break;
        }

        ten++;
        p--;
    }
    if(negative)
    {
        return -n;
    }
    return n;
}

_mtag static mbool_t isbe()
{
    muint16_t flag = 0x0102;
    return (((muint8_t *)(&flag))[0] == 0x01);
}

_mtag muint16_t MT2HToNS(muint16_t n)
{
    if(isbe())
    {
        return n;
    }
    muint16_t ret = ((((n)& 0xff) << 8) | (((n) >> 8) & 0xff));
    return ret;
}

_mtag muint32_t MT2HToNL(muint32_t n)
{
    if(isbe())
    {
        return n;
    }
    return (((((n)& 0xff) << 24) | (((n)& 0xff00) << 8) | (((n) >> 8) & 0xff00) | (((n) >> 24) & 0xff)));
}
