#ifndef MT2_LIST_H
#define MT2_LIST_H

#define MT2LIST_ENTRY(type) \
type *next;type *prev

#define MT2ListInit(list) \
(list)->next = (list); \
(list)->prev = (list);

#define MT2ListFirst(list) ((list)->next == (list) ? NULL : (list)->next)
#define MT2ListLast(list) ((list)->prev == (list) ? NULL : (list)->prev)

#define MT2ListAdd(list, node) \
node->next = (list);\
(list)->prev->next = node;\
node->prev = (list)->prev;\
(list)->prev = node;

#define MT2ListDel(node) \
(node)->prev->next = (node)->next;\
(node)->next->prev = (node)->prev;

#define _MT2_LIST_TMP_NODE(node, line) node##line

#define MT2_LIST_TMP_NODE(node, line) _MT2_LIST_TMP_NODE(node, line)

//MT2_LIST_TMP_NODE ڼ¼nextڵ㣬ڱ֤Delڵ㲻ᵼ´
#if 1
#define MT2ListForeach(list, node) \
void *MT2_LIST_TMP_NODE(node, __LINE__); \
for(node = (list)->next, MT2_LIST_TMP_NODE(node, __LINE__) = node->next; node != (list); node = MT2_LIST_TMP_NODE(node, __LINE__), MT2_LIST_TMP_NODE(node, __LINE__) = node->next)
#else
#define MT2ListForeach(list, node) \
for(node = (list)->next; node != (list); node = node->next)
#endif

#endif // MT2_LIST_H
