#ifndef MT2_TYPES_H
#define MT2_TYPES_H
#include "MT2Options.h"

#ifndef _mtag
#define _mtag 
#endif

//
typedef unsigned char       muint8_t;
typedef signed char         mint8_t;
typedef unsigned short      muint16_t;
typedef signed short        mint16_t;
typedef unsigned long       muint32_t;
typedef signed long         mint32_t;
typedef signed long long    mint64_t;
typedef unsigned long long  muint64_t;
typedef unsigned char       mbool_t;
typedef muint32_t           mtime_t;

#define mtrue (1)
#define mfalse (0)

#define MNULL ((void *)0)

#ifndef __mpacked
#define __mpacked            __attribute__((packed))
#endif

#ifndef MFILE
#define MFILE __FILE__
#endif

#ifndef MFUNC
#define MFUNC __func__
#endif

#ifndef __func__
#define __func__ __FUNCTION__
#endif

#ifndef MLINE
#define MLINE __LINE__
#endif

#ifdef mprintf 
#ifndef mlog
#define mlog(...) mprintf("[MT2] %s[%d]", MFUNC, MLINE);mprintf(__VA_ARGS__);mprintf("\n");
#endif
#else
#define mprintf 
#define mlog(...) 
#endif

#define ASSERT(exp) if(!(exp))mlog("ERROR: ASSERT FAIL!!!, %s [%s]", #exp, MFUNC);

#endif // !MT2_TYPES_H
