#ifndef MT2_DEF_H
#define MT2_DEF_H
#include "MT2Types.h"

#define MT2_TOKEN_LEN 32

//豸ID
#define MT2_DEVICEID_LEN 18
#define MT2_DEVICEPIN_LEN 32

//汾ų
#define MT2_VERSION_LEN 4

//ģͺų
#define MT2_MAX_MODULE_MODEL_LEN 30

//豸ͺų
#define MT2_MAX_DEVICE_MODEL_LEN 12

//ƽ̨
struct MT2CtxPri_st;
typedef struct 
{
    struct MT2CtxPri_st *pri;
}MT2Ctx_t;

//״̬
typedef enum
{
    MT2_SERVER_STATUS_IDLE,             //
    MT2_SERVER_STATUS_LS_CONNECTING,    //½
    MT2_SERVER_STATUS_LS_CONNECTED,     //½ӣȴظ
    MT2_SERVER_STATUS_CS_CONNECTING,    //ӷ
    MT2_SERVER_STATUS_CS_CONNECTED,     //ӷӣȴظ
    MT2_SERVER_STATUS_ONLINE,           //½ɹ
}MT2ServerStatus_t;

//
typedef struct
{
    char *loginServerHost;
    muint16_t loginServerPort;
    char *applyidServerHost;
    muint16_t applyidServerPort;
    muint16_t platformid;
}MT2CtxPlatformCfg_t;

#define MT2EVENT_QUERY 1                 //ѯ, MNULL
#define MT2EVENT_OPT 2                   //, MT2EventOptArg_t
#define MT2EVENT_APPLYID 3               //豸ID, MT2EventApplyidArg_t
#define MT2EVENT_UPDATE_SERVER_TIME 4    //·ʱ, MT2EventUpdaeServerTimeArg_t
#define MT2EVENT_UPGRADE 5               //̼, MT2EventUpgradeArg_t
#define MT2EVENT_UNBIND_RESULT 6         //ɹ
#define MT2EVENT_ACTS_OPT 7              //϶·
#define MT2EVENT_ACTS_START 8            //϶ʼ
#define MT2EVENT_ACTS_STOP 9             //϶ֹͣ
#define MT2EVENT_ACTS_PAUSE 10           //϶ͣ
#define MT2EVENT_SERVER_STATUS_CHANGE 11 //״̬仯
#define MT2EVENT_RESP_ADD_DISCOVER 12    //ظ豸ӷ
#define MT2EVENT_GW_START   100          //¼

//OTA
#define MT2EVENT_OTA_NOTIFY 5            //OTA֪ͨ == MT2EVENT_UPGRADE
#define MT2EVENT_OTA_DATA 13             //OTA̼, MT2EventOTADataArg_t

//OTA
typedef enum
{
    MT2_OTA_TYPE_MODULE = 0,            //ģ
    MT2_OTA_TYPE_DEVICE = 1,            //豸
}MT2OTAType_t;

typedef enum
{
    MT2_OTA_DATA_STAUTS_TRANSFER = 0,
    MT2_OTA_DATA_STAUTS_FAIL = 1,
    MT2_OTA_DATA_STAUTS_SUCCESS = 2,
}MT2OTADataStatus_t;

typedef struct
{
    char status; // MT2_OTA_DATA_STAUTS_TRANSFER = ̼
                 // MT2_OTA_DATA_STAUTS_FAIL = ̼ʧ
                 // MT2_OTA_DATA_STAUTS_SUCCESS = ̼
    muint32_t fileSize;
    const char *data;
    muint16_t datalen;
}MT2EventOTADataArg_t;

typedef struct
{
    MT2OTAType_t type;              //̼
    muint8_t *version;              //汾
    struct
    {
        muint16_t urllen;
        muint8_t *url;
        muint8_t *md5;
    }firmware[2];
}MT2EventUpgradeArg_t;

typedef struct
{
    mint8_t timezone;
    muint32_t seconds;  //1970/01/01/00:00 
}MT2EventUpdaeServerTimeArg_t;

typedef struct
{
    char deviceid[50];//[MT2_DEVICEID_LEN + 1];
    char devicepin[MT2_DEVICEPIN_LEN + 1];
}MT2EventApplyidArg_t;

//ֵ
typedef union
{
    mint32_t num;
    char *text;
}MT2PropertyValue_t;

typedef struct
{
    muint32_t pid;
    MT2PropertyValue_t value;
}MT2Property_t;

typedef struct
{
    muint8_t propertyNum;
    MT2Property_t *propertys;
}MT2EventOptArg_t;

//OTA״̬
typedef enum
{
    MT2_OTA_STATUS_IDLE = 0,            //
    MT2_OTA_STATUS_ERASING = 1,         //Flash           
    MT2_OTA_STATUS_DOWNLOADING = 2,     //
    MT2_OTA_STATUS_UPGRADING = 6,       //
    MT2_OTA_STATUS_UPGRAD_SUCCESS = 7,  //ɹ
    MT2_OTA_STATUS_UPGRAD_FAIL = 8,     //ʧ
}MT2OTAStatus_t;

//
typedef enum
{
    MT2_PROPERTY_TYPE_TEXT = 0,
    MT2_PROPERTY_TYPE_NUM = 1,
}MT2PropertyType_t;

//϶
typedef struct
{
    muint32_t pid;
    union
    {
        mint32_t num;
        const char *text;
    }value;
}MT2ActionsCmdOpt_t;

//϶
typedef struct
{
    mbool_t endPause;
    muint32_t workTime;
    muint8_t optsCount;
    MT2ActionsCmdOpt_t *opts;
}MT2ActionsCmdStep_t;

//϶
typedef struct
{
    mint32_t actsid;
    muint8_t stepsCount;
    MT2ActionsCmdStep_t *steps;
}MT2ActionsCmd_t;

//AES
typedef enum
{
    MT2_AES_KEY_TYPE_WAN,
    MT2_AES_KEY_TYPE_LAN,
    MT2_AES_KEY_TYPE_APPLYID,
}MT2AesKeyType_t;

#endif // !MT2_DEF_H
