#ifndef MT2CTX_PRI_H
#define MT2CTX_PRI_H
#include "MT2Def.h"
#include "MT2.h"
#include "Adapter/MT2Adapter.h"
#include "Adapter/MT2Socket.h"
#include "Util/MT2Util.h"
#include "MT2Conn.h"
#include "MT2CtxGatewayPri.h"
#include "Util/HTTPRequest.h"


#define MT2_TOKEN_LEN 32

struct MT2CtxPri_st;

/*******************************************************************************
 * Connection Manager
 ******************************************************************************/

#define LAN_CONN_NUM (M_OPTION_CONN_NUM - 1)

//Ȩ
typedef enum
{
    OPT_AUTHORITY_DEF = 0,                  //Ĭ
    OPT_AUTHORITY_DENY = 1,                 //ֹ
    OPT_AUTHORITY_LAN_ONLY = 2,             //
    OPT_AUTHORITY_WAN_ONLY = 3,             //
}OptAuthority_t;

typedef struct OptInfo_st
{
    char *mid;
    muint8_t propertyNum;
    MT2Property_t *property;
    mtime_t optTime;
    MT2LIST_ENTRY(struct OptInfo_st);
}OptInfo_t;

typedef struct Property_st
{
    muint32_t pid;
    MT2PropertyType_t type : 2;
    mbool_t readonly : 1;       //ֻɿ
    muint8_t authority : 5;     //Ȩ޿
    mint32_t threshold;         //ֵ
    mtime_t setTime;
    MT2PropertyValue_t value;
    MT2PropertyValue_t postValue;
    MT2LIST_ENTRY(struct Property_st);
}Property_t;




//ȴظϢ
typedef struct WaitRespMsg_st
{
    mint32_t mid;
    muint8_t msgType;
    mtime_t time;
    MT2LIST_ENTRY(struct WaitRespMsg_st);
}WaitRespMsg_t;

//ȴظĲѯ
typedef struct WaitRespQuery_st
{
    char *mid;
    char *from;
    mtime_t time;
    MT2Conn_t *conn;
    MT2LIST_ENTRY(struct WaitRespQuery_st);
}WaitRespQuery_t;

typedef struct ApplyidCtx_st
{
    char model[60];//[MT2_MAX_DEVICE_MODEL_LEN + 1];
    char pin[33];
    mtime_t startTime;
    MT2Socket_t *socket;
    char buf[128];
    muint16_t bufCnt;
}ApplyidCtx_t;

typedef struct MT2CtxPri_st
{
    //ʼ
    mbool_t startConnect;

    //
    mint8_t timezone;

    //ƽ̨Ϣ
    mbool_t loginServerUseIP;
    char *loginServerHost;
    muint16_t loginServerPort;
    mbool_t applyidServerUseIP;
    char *applyidServerHost;
    muint16_t applyidServerPort;
    muint16_t platformid;

    //Ƿͨģ
    mbool_t isNormalModule;

    //ӷ״̬
    mbool_t startAddDiscover;
    mtime_t startAddDiscoverTime;

    //״̬
    MT2ServerStatus_t serverStatus;
    mtime_t lastServerStatusTime;
    //
    MT2Conn_t serverConn;
    //
    MT2Conn_t lanConns[LAN_CONN_NUM];

    //豸ID
    char deviceid[MT2_DEVICEID_LEN + 1];
    //PIN
    char devicepin[32 + 1];

    //Ҫ
    mbool_t needUnbind;
    mtime_t lastUnbindTime;
    muint8_t unbindCount;

    //ģͺš汾
    char moduleModel[MT2_MAX_MODULE_MODEL_LEN + 1];
    muint8_t moduleVer[MT2_VERSION_LEN];

    //豸ͺš汾
    char deviceModel[MT2_MAX_DEVICE_MODEL_LEN + 1];
    muint8_t deviceVer[MT2_VERSION_LEN];

    //¼
    MT2EventHandler_t eventHandler;

    //Status
    Property_t propertyList;    //б
    mbool_t propertyBlockForPost;
    mtime_t propertyLastSyncValueTime;
    mtime_t propertyBlockForPostTime;

    //OTA״̬
    struct
    {
        MT2OTAType_t type;
        MT2OTAStatus_t status;
        muint8_t progress;
        mtime_t lastOTAPostTime;
        muint8_t version[4];

        //download
        muint8_t retriesCnt;
        mbool_t startDownload;
        char *url;
        HTTPRequest_t *request;
        muint32_t fileSize;
        muint32_t totalRecvLen;
    }ota;

    //Ϣ
    struct
    {
        //4 * 64 bit, 뷶Χ0-255
        muint64_t map[4];
    }fid;

    //Actions
    struct
    {
        mbool_t needPost;
        mtime_t needPostTime;
        mint32_t id;
        muint8_t realStep;
        muint8_t status;
        muint8_t step;
        mint32_t leftTime;
    }acts;

    //applyid
    ApplyidCtx_t *applyidCtx;

    //json about
    mint32_t mid;
    OptInfo_t optinfoList;
    WaitRespQuery_t waitRespQueryList;
    WaitRespMsg_t waitRespMsgList;
    mbool_t gotPropertyConstraint;    //ѻȡԼ
    mtime_t lastFetchPropertyConstraintTime;

    //connectionManager
    mtime_t lastTickTime;
    char connToken[MT2_TOKEN_LEN + 1];

    MT2Socket_t *udpSocket;                 //վ㲥
    MT2Socket_t *tcpListenSocket;           //Ӽ
    mbool_t lastNetifStatus;

#if MT2_OPTION_GATEWAY
    Gateway_t gw;
#endif
}MT2CtxPri_t;

void MT2CtxPrivateInit(MT2Ctx_t *ctx);
void MT2CtxPrivatePoll(MT2Ctx_t *ctx);
mbool_t MT2LanConnectionIsValid(MT2Conn_t *conn);

Property_t *MT2CtxFindOrRegistProperty(MT2Ctx_t *ctx, muint32_t pid, MT2PropertyType_t type);

Property_t *MT2CtxFindProperty(MT2Ctx_t *ctx, muint32_t pid);

//Fid About
json_item_t *MT2CtxFidBuildJsonItem(MT2Ctx_t *ctx);
void MT2CtxFidSetBit(MT2Ctx_t *ctx, muint8_t bitNo, mbool_t value);
mbool_t MT2CtxFidGetBit(MT2Ctx_t *ctx, muint8_t bitNo);

void MT2CtxUnbindSuccess(MT2Ctx_t *ctx);

#define MT2CtxSendEvent(ctx, evt, arg) (ctx)->pri->eventHandler((ctx), evt, arg)

#endif // !MT2CTX_PRI_H


#include "MT2CtxConnectionManager.h"
#include "MT2CtxJsonHandler.h"
#include "MT2CtxBinaryHandler.h"





