#include "MT2CtxPri.h"
#include "MT2CtxOTAPri.h"

/*******************************************************************************
 * Global Variables
 ******************************************************************************/

/*******************************************************************************
 * Function Defination
 ******************************************************************************/
_mtag void MT2CtxPrivateInit(MT2Ctx_t *ctx)
{
    MT2ListInit(&ctx->pri->propertyList);
    MT2CtxOTAPriInit(ctx);
}

_mtag void MT2CtxPrivatePoll(MT2Ctx_t *ctx)
{
    MT2CtxOTAPriPoll(ctx);
}

_mtag mbool_t MT2LanConnectionIsValid(MT2Conn_t *conn)
{
    if(!conn->alloc)
    {
        return mfalse;
    }

    return (conn->status == MT2CONN_STATUS_ONLINE);
}

_mtag Property_t *MT2CtxFindProperty(MT2Ctx_t *ctx, muint32_t pid)
{
    Property_t *property;
    MT2ListForeach(&ctx->pri->propertyList, property)
    {
        if(property->pid == pid)
        {
            return property;
        }
    }
    return MNULL;
}

_mtag void *MT2CtxRegistProperty(MT2Ctx_t *ctx, muint32_t pid, MT2PropertyType_t type)
{
    Property_t *property = malloc(sizeof(Property_t));
    property->type = type;
    property->pid = pid;
    property->threshold = 0;
    property->readonly = mfalse;
    property->authority = OPT_AUTHORITY_DEF;

    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        property->value.num = 0;
        property->postValue.num = 0;
    }
    else
    {
        property->value.text = malloc(1);
        property->value.text[0] = '\0';
        property->postValue.text = property->value.text;
    }

    MT2ListAdd(&ctx->pri->propertyList, property);
    return property;
}

_mtag void MT2CtxUnbindSuccess(MT2Ctx_t *ctx)
{
    ctx->pri->needUnbind = mfalse;
    ctx->pri->eventHandler(ctx, MT2EVENT_UNBIND_RESULT, MNULL);
}


/*******************************************************************************
 * Fid About
 ******************************************************************************/
_mtag json_item_t *MT2CtxFidBuildJsonItem(MT2Ctx_t *ctx)
{
    muint16_t i;

    json_item_t *fidItem = json_item_create(JSON_ARRAY, T_FIDS);
    for(i = 0; i < 256; i++)
    {
        if(MT2CtxFidGetBit(ctx, (uint8_t)i))
        {
            json_array_item_add_subitem(fidItem, J_CREATE_N(MNULL, MT2NumToString(i)));
        }
    }

    return fidItem;
}

_mtag mbool_t MT2CtxFidGetBit(MT2Ctx_t *ctx, muint8_t bitNo)
{
    muint8_t offset = 0;
    while(bitNo >= 64)
    {
        bitNo -= 64;
        offset++;
    }
    return ((ctx->pri->fid.map[offset] >> bitNo) & 1);
}

_mtag void MT2CtxFidSetBit(MT2Ctx_t *ctx, muint8_t bitNo, mbool_t value)
{
    muint8_t offset = 0;
    while(bitNo >= 64)
    {
        bitNo -= 64;
        offset++;
    }

    ctx->pri->fid.map[offset] &= (~(((muint64_t)0x01) << bitNo));

    if(value)
    {
        ctx->pri->fid.map[offset] |= ((((muint64_t)0x01) << bitNo));
    }
}

