#include "MT2CtxOTA.h"
#include "MT2CtxOTAPri.h"
#include "MT2CtxPri.h"


/*******************************************************************************
 * Function Declaration
 ******************************************************************************/
static void startHttp(MT2Ctx_t *ctx);

/*******************************************************************************
 * Function Defination
 ******************************************************************************/
_mtag void MT2CtxOTAPriInit(MT2Ctx_t *ctx)
{

}

_mtag void MT2CtxOTAPriPoll(MT2Ctx_t *ctx)
{

}

_mtag void MT2CtxUpdateOTAStatus(MT2Ctx_t *ctx, MT2OTAType_t type, MT2OTAStatus_t status, muint8_t progress, const muint8_t *newVersion)
{
    MT2OTAType_t oldType = ctx->pri->ota.type;
    MT2OTAStatus_t oldStatus = ctx->pri->ota.status;
    muint8_t oldProgress = ctx->pri->ota.progress;

    ctx->pri->ota.type = type;
    ctx->pri->ota.status = status;

    //״̬ƽ̨ЭûҪת, ΪһһӦ
    if(ctx->pri->ota.status == MT2_OTA_STATUS_ERASING)
    {
        ctx->pri->ota.status = MT2_OTA_STATUS_DOWNLOADING;
        progress = (muint8_t)(((muint32_t)progress * 20) / 100);
    }
    else if(ctx->pri->ota.status == MT2_OTA_STATUS_DOWNLOADING)
    {
        progress = (muint8_t)(((muint32_t)progress * 80) / 100 + 20);
    }

    ctx->pri->ota.progress = progress;

    mtime_t timePass = MT2Time() - ctx->pri->ota.lastOTAPostTime;

    mlog("update ota status, type=%d status=%d progress=%d timepass=%d(%d)", 
        ctx->pri->ota.type, 
        ctx->pri->ota.status, 
        ctx->pri->ota.progress, 
        (mint32_t)timePass,
        MT2Time());

    if(oldType != type
        || oldStatus != ctx->pri->ota.status
        || ctx->pri->ota.progress == 100
        || timePass > 1000
        || (ctx->pri->ota.progress - oldProgress > 5 && timePass > 500))
    {
        if(MT2CtxIsOnlineOrHasLanConnection(ctx))
        {
            ctx->pri->ota.lastOTAPostTime = MT2Time();

            json_item_t *item = MT2CtxJHJsonBuild(ctx, T_OTAPOST, MNULL, MNULL);
            json_object_item_add_subitem(item, J_CREATE_N("type", MT2NumToString(ctx->pri->ota.type)));
            json_object_item_add_subitem(item, J_CREATE_N("status", MT2NumToString(ctx->pri->ota.status)));
            json_object_item_add_subitem(item, J_CREATE_N("percent", MT2NumToString(ctx->pri->ota.progress)));

            char ver[16];
            if(newVersion && ctx->pri->ota.status == MT2_OTA_STATUS_UPGRAD_SUCCESS)
            {
                ver[0] = '\0';
                strcat(ver, MT2NumToString(newVersion[0]));
                strcat(ver, ".");
                strcat(ver, MT2NumToString(newVersion[1]));
                strcat(ver, ".");
                strcat(ver, MT2NumToString(newVersion[2]));
                strcat(ver, ".");
                strcat(ver, MT2NumToString(newVersion[3]));
                json_object_item_add_subitem(item, J_CREATE_S("version", ver));
            }

            MT2CtxJHSendJson(ctx, item, TO_ALL_CONN, mtrue);
        }
    }

    //
    if(ctx->pri->ota.status == MT2_OTA_STATUS_UPGRAD_SUCCESS
        || ctx->pri->ota.status == MT2_OTA_STATUS_UPGRAD_FAIL)
    {
        ctx->pri->ota.status = MT2_OTA_STATUS_IDLE;
        ctx->pri->ota.progress = 0;
    }
}

_mtag void httpRequestDataRecvCallback(HTTPRequest_t *request, const muint8_t *data, muint16_t len, HTTPRequestError_t error)
{
    MT2Ctx_t *ctx = request->userData;

    if(error == HTTP_REQ_ERROR_SUCCESS)
    {
        //δɼ
        if(ctx->pri->ota.totalRecvLen < ctx->pri->ota.fileSize)
        {
            //delay startHttp
            startHttp(ctx);
            return;
        }

        mlog("ota download end");

        MT2EventOTADataArg_t arg;
        arg.status = MT2_OTA_DATA_STAUTS_SUCCESS;
        MT2CtxSendEvent(ctx, MT2EVENT_OTA_DATA, &arg);
    }
    else if(error == HTTP_REQ_ERROR_FAIL)
    {
        //ʧ10
        if(ctx->pri->ota.retriesCnt < 10)
        {
            ctx->pri->ota.retriesCnt++;
            startHttp(ctx);
        }
        else
        {
            mlog("ota download fail");

            MT2EventOTADataArg_t arg;
            arg.status = MT2_OTA_DATA_STAUTS_FAIL;
            MT2CtxSendEvent(ctx, MT2EVENT_OTA_DATA, &arg);
        }
    }
    else
    {
        if(ctx->pri->ota.fileSize == 0)
        {
            ctx->pri->ota.fileSize = request->respContentLength;
        }

        ctx->pri->ota.totalRecvLen += len;

        int progress = ctx->pri->ota.fileSize == 0 ? 0 : (ctx->pri->ota.totalRecvLen * 100 / ctx->pri->ota.fileSize);
        MT2CtxUpdateOTAStatus(ctx, ctx->pri->ota.type, MT2_OTA_STATUS_DOWNLOADING, progress, ctx->pri->ota.version);

        //
        MT2EventOTADataArg_t arg;
        arg.status = MT2_OTA_DATA_STAUTS_TRANSFER;
        arg.data = (const char *)data;
        arg.datalen = len;
        arg.fileSize = ctx->pri->ota.fileSize;
        MT2CtxSendEvent(ctx, MT2EVENT_OTA_DATA, &arg);
    }
}

_mtag static void startHttp(MT2Ctx_t *ctx)
{
    if(ctx->pri->ota.request)
    {
        HTTPRequestDestroy(ctx->pri->ota.request);
    }
    ctx->pri->ota.request = HTTPRequestCreate(ctx->pri->ota.url, HTTP_REQ_METHOD_GET);
    ctx->pri->ota.request->userData = ctx;
    ctx->pri->ota.request->dataRecvCb = httpRequestDataRecvCallback;

    uint32_t targetpos = ctx->pri->ota.totalRecvLen + KB(8) - 1;
    if(targetpos >= ctx->pri->ota.fileSize)
    {
        targetpos = ctx->pri->ota.fileSize - 1;
    }

    //ѻȡļȣʹöϵ
    if(ctx->pri->ota.fileSize != 0)
    {
        char text[20];

#ifdef EMW5088
        sprintf(text, "bytes=%d-%d", ctx->pri->ota.totalRecvLen, targetpos);
#else
        sprintf(text, "bytes=%d-", ctx->pri->ota.totalRecvLen);
#endif
        HTTPRequestAddHeader(ctx->pri->ota.request, "Range", text);
        ctx->pri->ota.request->timeout = 5000;
    }

    HTTPRequestStart(ctx->pri->ota.request);
}

_mtag void MT2CtxStartOTADownload(MT2Ctx_t *ctx, MT2EventUpgradeArg_t *upgradeArg, muint8_t index)
{
    ASSERT(ctx != NULL);
    ASSERT(upgradeArg != NULL);
    ASSERT(index < 2);

    if(ctx->pri->ota.startDownload)
    {
        mlog("err, has start.");
        return;
    }

    char *url = malloc(upgradeArg->firmware[index].urllen + 1);
    memcpy(url, upgradeArg->firmware[index].url, upgradeArg->firmware[index].urllen);
    url[upgradeArg->firmware[index].urllen] = '\0';

    mlog("start ota, type=%d index=%d url=%s", upgradeArg->type, index, url);

    if(ctx->pri->ota.url)
    {
        free(ctx->pri->ota.url);
    }
    ctx->pri->ota.url = url;
    ctx->pri->ota.startDownload = mtrue;
    ctx->pri->ota.retriesCnt = 0;
    ctx->pri->ota.totalRecvLen = 0;
    ctx->pri->ota.fileSize = 0;
    memcpy(ctx->pri->ota.version, upgradeArg->version, MT2_VERSION_LEN);

    startHttp(ctx);
}

_mtag void MT2CtxStopOTADownlaod(MT2Ctx_t *ctx)
{
    ctx->pri->ota.startDownload = mfalse;

    if(ctx->pri->ota.url)
    {
        free(ctx->pri->ota.url);
        ctx->pri->ota.url = MNULL;
    }

    if(ctx->pri->ota.request)
    {
        HTTPRequestDestroy(ctx->pri->ota.request);
        ctx->pri->ota.request = MNULL;
    }
}

