#include "MT2CtxJsonHandler.h"
#include "MT2CtxPri.h"
#include "MT2CtxGWJsonHandler.h"

#define THRESHOLD_DELAY_TIME 5000           //δֵʱʱ
#define QUERY_RESP_TIMEOUT 1000                 //ѯʱʱ



/*******************************************************************************
 * Function Declaration
 ******************************************************************************/
static json_item_t *buildPostPropertyJson(Property_t *property);
static void delWaitRespMsg(WaitRespMsg_t *msg);
static void ctxHandleAndFreeWaitRespQuery(MT2Ctx_t *ctx, WaitRespQuery_t *wquery);

/*******************************************************************************
 * Global Variable
 ******************************************************************************/


 /*******************************************************************************
  * Function Defination
  ******************************************************************************/
_mtag void MT2CtxJsonHandlerInit(MT2Ctx_t *ctx)
{
    MT2ListInit(&ctx->pri->optinfoList);
    MT2ListInit(&ctx->pri->waitRespMsgList);
    MT2ListInit(&ctx->pri->waitRespQueryList);

#if MT2_OPTION_GATEWAY
    MT2CtxGWJsonHandlerInit(ctx);
#endif
}

_mtag static void ctxHandleAndFreeOptInfo(MT2Ctx_t *ctx, OptInfo_t *optinfo)
{
    json_item_t *item = MT2CtxJHJsonBuild(ctx, T_POST, optinfo->mid, MNULL);
    json_item_t *asItem = J_CREATE(JSON_OBJECT, T_AS);
    json_object_item_add_subitem(item, asItem);

    muint8_t i;
    Property_t *property;
    for(i = 0; i < optinfo->propertyNum; i++)
    {
        property = MT2CtxFindProperty(ctx, optinfo->property[i].pid);
        json_object_item_add_subitem(asItem, buildPostPropertyJson(property));
    }

    MT2ListDel(optinfo);
    free(optinfo->mid);
    if(optinfo->property)
    {
        free(optinfo->property);
    }
    free(optinfo);

    MT2CtxJHSendJson(ctx, item, TO_ALL_CONN, mtrue);
}

_mtag static OptInfo_t *ctxAddOptinfo(MT2Ctx_t *ctx, const char *mid, muint8_t pnum, MT2Property_t *mt2Property)
{
    OptInfo_t *optinfo = malloc(sizeof(OptInfo_t));
    optinfo->optTime = MT2Time();
    optinfo->mid = malloc(strlen(mid) + 1);
    strcpy(optinfo->mid, mid);
    optinfo->propertyNum = pnum;
    optinfo->property = mt2Property;
    MT2ListAdd(&ctx->pri->optinfoList, optinfo);
    return optinfo;
}

_mtag static const char *ctxGetMid(MT2Ctx_t *ctx)
{
    return MT2NumToString(ctx->pri->mid++);
}

_mtag static const char *ctxConnFlag(MT2Ctx_t *ctx, MT2Conn_t *conn, char *text)
{
    text[0] = '\0';
    if(conn == &ctx->pri->serverConn)
    {
        strcat(text, "server");
    }
    else if(conn == TO_ALL_CONN)
    {
        strcat(text, "all[");

        if(MT2CtxIsOnline((MT2Ctx_t *)ctx))
        {
            strcat(text, "server");
        }

        char nt[10];

        muint8_t i;
        for(i = 0; i < LAN_CONN_NUM; i++)
        {
            if(MT2LanConnectionIsValid(&ctx->pri->lanConns[i]))
            {
                sprintf(nt, "lan%d", ctx->pri->lanConns[i].index);
                strcat(text, " ");
                strcat(text, nt);
            }
        }
        strcat(text, "]");
    }
    else
    {
        sprintf(text, "lan%d", conn->index);
    }
    return text;
}

_mtag json_item_t *MT2CtxJHJsonBuild(MT2Ctx_t *ctx, const char *cmd, const char *mid, const char *to)
{
    json_item_t *json = json_item_create(JSON_OBJECT, MNULL);
    json_object_item_add_subitem(json, J_CREATE_S(T_CMD, cmd));
    json_object_item_add_subitem(json, J_CREATE_S(T_MID, mid ? mid : ctxGetMid(ctx)));

    if(to)
    {
        json_object_item_add_subitem(json, J_CREATE_S(T_TO, to));
    }
    return json;
}

_mtag static json_item_t *buildPostPropertyJson(Property_t *property)
{
    json_item_t *json;
    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        char key[10];
        strncpy(key, MT2NumToString(property->pid), sizeof(key));
        json = J_CREATE_N(key, MT2NumToString(property->value.num));
        property->postValue.num = property->value.num;
    }
    else
    {
        char key[10];
        strncpy(key, MT2NumToString(property->pid), sizeof(key));
        json = J_CREATE_S(key, property->value.text ? property->value.text : "");

        if(property->postValue.text != property->value.text)
        {
            property->postValue.text = property->value.text;
        }
    }

    return json;
}

_mtag static json_item_t *buildOTAStatusItem(MT2Ctx_t *ctx)
{
    json_item_t *otaItem = json_item_create(JSON_ARRAY, T_OTA);
    json_array_item_add_subitem(otaItem, J_CREATE_N(MNULL, MT2NumToString(ctx->pri->ota.type)));
    json_array_item_add_subitem(otaItem, J_CREATE_N(MNULL, MT2NumToString(ctx->pri->ota.status)));
    json_array_item_add_subitem(otaItem, J_CREATE_N(MNULL, MT2NumToString(ctx->pri->ota.progress)));

    return otaItem;
}

_mtag void MT2PostAll(MT2Ctx_t *ctx, MT2Conn_t *conn, mbool_t isresp, const char *mid, const char *from)
{
    json_item_t *item = isresp ? MT2CtxJHJsonBuild(ctx, T_RESP, mid, from) : MT2CtxJHJsonBuild(ctx, T_POST, MNULL, MNULL);

    if(isresp)
    {
        json_object_item_add_subitem(item, J_CREATE_N(T_CODE, "0"));
    }

    //״̬
    json_item_t *asItem = json_item_create(JSON_OBJECT, T_AS);
    json_object_item_add_subitem(item, asItem);
    Property_t *property;
    MT2ListForeach(&ctx->pri->propertyList, property)
    {
        json_object_item_add_subitem(asItem, buildPostPropertyJson(property));
    }

    //״̬
    json_object_item_add_subitem(item, MT2CtxFidBuildJsonItem(ctx));

    //OTA
    json_object_item_add_subitem(item, buildOTAStatusItem(ctx));

    //϶״̬
    json_item_t *actsItem = json_item_create(JSON_OBJECT, "acts");
    json_object_item_add_subitem(item, actsItem);
    json_item_add_subitem(actsItem, J_CREATE_S(T_ID, MT2NumToString(ctx->pri->acts.id)));
    json_item_add_subitem(actsItem, J_CREATE_S(T_STATUS, MT2NumToString(ctx->pri->acts.status)));
    json_item_add_subitem(actsItem, J_CREATE_S(T_STEP, MT2NumToString(ctx->pri->acts.step)));
    json_item_add_subitem(actsItem, J_CREATE_S(T_LEFT, MT2NumToString(ctx->pri->acts.leftTime)));
    json_item_add_subitem(actsItem, J_CREATE_S(T_REALSTEP, MT2NumToString(ctx->pri->acts.realStep)));

    if(conn->alloc)
    {
        MT2CtxJHSendJson(ctx, item, conn, mtrue);
    }
    else
    {
        json_item_destroy(item);
    }
}

_mtag static void ctxHandleAndFreeWaitRespQuery(MT2Ctx_t *ctx, WaitRespQuery_t *wquery)
{
#if MT2_OPTION_GATEWAY
    MT2GWPostAll(ctx, wquery->conn, mtrue, wquery->mid, wquery->from);
#else
    MT2PostAll(ctx, wquery->conn, mtrue, wquery->mid, wquery->from);
#endif
    MT2ListDel(wquery);
    free(wquery->mid);
    free(wquery->from);
    free(wquery);
}

_mtag static void ctxAddWaitQuery(MT2Ctx_t *ctx, MT2Conn_t *fromConn, const char *mid, const char *from)
{
    WaitRespQuery_t *wquery = malloc(sizeof(WaitRespQuery_t));
    wquery->from = malloc(strlen(from) + 1);
    strcpy(wquery->from, from);
    wquery->mid = malloc(strlen(mid) + 1);
    strcpy(wquery->mid, mid);
    wquery->time = MT2Time();
    wquery->conn = fromConn;
    MT2ListAdd(&ctx->pri->waitRespQueryList, wquery);
}

_mtag static void ctxHandleQuery(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json)
{
    const char *from = json_item_get_string_value(json_item_get_subitem_by_name(json, T_FROM));
    const char *mid = json_item_get_string_value(json_item_get_subitem_by_name(json, T_MID));
    ctxAddWaitQuery(ctx, fromConn, mid, from);
    ctx->pri->eventHandler(ctx, MT2EVENT_QUERY, MNULL);
}

_mtag static void ctxHandleOpt(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json)
{
    const char *mid = json_item_get_string_value(json_item_get_subitem_by_name(json, T_MID));


    muint8_t pnum;
    json_item_t *asItem = json_item_get_subitem_by_name(json, T_AS);
    json_item_t *firstProperty = (json_item_t *)asItem->value;
    muint32_t pid;
    Property_t *property;

    //жϲ
    pnum = 0;
    while(firstProperty)
    {
        pnum++;
        pid = (muint32_t)MT2StringToNum(firstProperty->name);
        property = MT2CtxFindOrRegistProperty(ctx, pid, MT2_PROPERTY_TYPE_NUM);
        firstProperty = firstProperty->next;
    }

    MT2EventOptArg_t arg;
    arg.propertys = MNULL;

    //mallocڴoptinfoʱͷ
    arg.propertys = malloc(pnum * sizeof(MT2Property_t));
    pnum = 0;
    mbool_t valueAllSame = mtrue;
    firstProperty = (json_item_t *)asItem->value;
    while(firstProperty)
    {
        pid = (muint32_t)MT2StringToNum(firstProperty->name);
        property = MT2CtxFindProperty(ctx, pid);
        if(property)
        {
            if(property->type == MT2_PROPERTY_TYPE_NUM)
            {
#if 0
                //ɿ
                if(property->readonly)
                {
                    mlog("property:%d is readonly", pid);
                    firstProperty = firstProperty->next;
                    continue;
                }
#endif

                //Ȩ֤
                if(property->authority != OPT_AUTHORITY_DEF)
                {
                    char *authFailReason = MNULL;

                    if(property->authority == OPT_AUTHORITY_DENY)
                    {
                        authFailReason = "deny";
                    }
                    else if(property->authority == OPT_AUTHORITY_LAN_ONLY
                        && fromConn == &ctx->pri->serverConn)
                    {
                        authFailReason = "lan only";
                    }
                    else if(property->authority == OPT_AUTHORITY_WAN_ONLY
                        && fromConn != &ctx->pri->serverConn)
                    {
                        authFailReason = "wan only";
                    }

                    if(authFailReason)
                    {
                        mlog("opt auth fail, property:%d %s authority=%d", pid, authFailReason, property->authority);
                        firstProperty = firstProperty->next;
                        continue;
                    }
                }

                arg.propertys[pnum].value.num = (muint32_t)MT2StringToNum(json_item_get_string_value(firstProperty));
                if(property->value.num != arg.propertys[pnum].value.num)
                {
                    valueAllSame = mfalse;
                }
            }
            else
            {
                arg.propertys[pnum].value.text = (char *)json_item_get_string_value(firstProperty);
                if(strcmp(property->value.text, arg.propertys[pnum].value.text) != 0)
                {
                    valueAllSame = mfalse;
                }
            }
            arg.propertys[pnum].pid = (muint32_t)MT2StringToNum(firstProperty->name);
            pnum++;
        }
        firstProperty = firstProperty->next;
    }

    arg.propertyNum = pnum;
    OptInfo_t *optinfo = ctxAddOptinfo(ctx, mid, pnum, arg.propertys);
    ctx->pri->eventHandler((MT2Ctx_t *)ctx, MT2EVENT_OPT, &arg);

    //ֵδı䣬ֱӷزɹ
    if(valueAllSame)
    {
        mlog("opt, value not change");
        ctxHandleAndFreeOptInfo(ctx, optinfo);
    }
}

_mtag static void ctxHandleResp(MT2Ctx_t *ctx, MT2Conn_t *conn, json_item_t *json)
{
    json_item_t *subitem = json_item_get_subitem_by_name(json, T_MID);
    if(!subitem)
    {
        return;
    }

    mint32_t mid = (muint32_t)MT2StringToNum(json_item_get_string_value(subitem));

    muint8_t msgType = WAIT_RESP_MSG_NONE;
    WaitRespMsg_t *msg;
    MT2ListForeach(&ctx->pri->waitRespMsgList, msg)
    {
        if(msg->mid == mid)
        {
            msgType = msg->msgType;
            delWaitRespMsg(msg);
            break;
        }
    }

    if(msgType == WAIT_RESP_MSG_GET_AS)
    {
        mlog("recv getAs resp");

        ctx->pri->gotPropertyConstraint = mtrue;

        subitem = json_item_get_subitem_by_name(json, T_AC);
        if(!subitem)
        {
            return;
        }

        muint32_t pid;
        mbool_t readonly;
        mint32_t threshold;
        muint8_t authority;
        Property_t *property;

        json_item_t *acSubitem;
        muint8_t acCount = (muint8_t)json_item_get_subitem_count(subitem);
        muint8_t i;
        for(i = 0; i < acCount; i++)
        {
            acSubitem = json_item_get_subitem_by_index(subitem, i);

            if(json_item_get_subitem_count(acSubitem) < 4)
            {
                mlog("acSubitem's sumitem < 4");
                continue;
            }

            pid = (muint32_t)MT2StringToNum(json_item_get_string_value(json_item_get_subitem_by_index(acSubitem, 0)));
            readonly = (muint32_t)MT2StringToNum(json_item_get_string_value(json_item_get_subitem_by_index(acSubitem, 1))) != 0;
            threshold = (muint32_t)MT2StringToNum(json_item_get_string_value(json_item_get_subitem_by_index(acSubitem, 2)));
            authority = (muint8_t)MT2StringToNum(json_item_get_string_value(json_item_get_subitem_by_index(acSubitem, 3)));

            mlog("getAs resp item, pid:%d readonly:%d threshold:%d authority:%d", pid, readonly, threshold, authority);

            property = MT2CtxFindOrRegistProperty(ctx, pid, MT2_PROPERTY_TYPE_NUM);
            property->readonly = readonly;
            property->threshold = threshold;
            property->authority = authority;
        }
    }
    else
    {
#if MT2_OPTION_GATEWAY
        MT2CtxGWJHHandleResp(ctx, msgType, json);
#endif
    }
}

_mtag void MT2CtxQueryEnd(MT2Ctx_t *ctx)
{
    WaitRespQuery_t *wquery;
    MT2ListForeach(&ctx->pri->waitRespQueryList, wquery)
    {
        ctxHandleAndFreeWaitRespQuery(ctx, wquery);
    }
}

_mtag static void freeActionsCmd(MT2ActionsCmd_t *actionsCmd)
{
    muint8_t i;
    for(i = 0; i < actionsCmd->stepsCount; i++)
    {
        free(actionsCmd->steps[i].opts);
    }
    free(actionsCmd->steps);
    free(actionsCmd);
}

_mtag static void ctxHandleActsOpt(MT2Ctx_t *ctx, MT2Conn_t *conn, json_item_t *json)
{
    MT2ActionsCmd_t *actionsCmd = malloc(sizeof(MT2ActionsCmd_t));

    json_item_t *stepsItem = json_item_get_subitem_by_name(json, "steps");
    json_item_t *curStep;
    json_item_t *optsItem;
    json_item_t *curOpt;

    actionsCmd->actsid = (muint32_t)MT2StringToNum(J_SUB_VALUE_BY_NAME_S(json, "id"));
    actionsCmd->stepsCount = (muint8_t)json_item_get_subitem_count(stepsItem);
    actionsCmd->steps = malloc(sizeof(MT2ActionsCmdStep_t) * actionsCmd->stepsCount);

    muint8_t i, j;
    for(i = 0; i < actionsCmd->stepsCount; i++)
    {
        curStep = json_item_get_subitem_by_index(stepsItem, i);
        actionsCmd->steps[i].endPause = (MT2StringToNum(J_SUB_VALUE_BY_NAME_S(curStep, "pause")) == 1);
        actionsCmd->steps[i].workTime = (muint32_t)MT2StringToNum(J_SUB_VALUE_BY_NAME_S(curStep, "time"));

        optsItem = json_item_get_subitem_by_name(curStep, "opts");
        actionsCmd->steps[i].optsCount = (muint8_t)json_item_get_subitem_count(optsItem);
        actionsCmd->steps[i].opts = malloc(sizeof(MT2ActionsCmdOpt_t) * actionsCmd->steps[i].optsCount);

        for(j = 0; j < actionsCmd->steps[i].optsCount; j++)
        {
            curOpt = json_item_get_subitem_by_index(optsItem, j);
            actionsCmd->steps[i].opts[j].pid = (muint32_t)MT2StringToNum(curOpt->name);

            if(MT2CtxGetPropertyType((MT2Ctx_t *)ctx, actionsCmd->steps[i].opts[j].pid) == MT2_PROPERTY_TYPE_NUM)
            {
                actionsCmd->steps[i].opts[j].value.num = (mint32_t)MT2StringToNum(json_item_get_string_value(curOpt));
            }
            else
            {
                actionsCmd->steps[i].opts[j].value.text = json_item_get_string_value(curOpt);
            }
        }
    }

    ctx->pri->eventHandler((MT2Ctx_t *)ctx, MT2EVENT_ACTS_OPT, actionsCmd);
    freeActionsCmd(actionsCmd);
}

_mtag static void handleActsStep(MT2Ctx_t *ctx, MT2Conn_t *conn, json_item_t *json)
{
    ctx->pri->acts.realStep = (muint8_t)MT2StringToNum(J_SUB_VALUE_BY_NAME_S(json, T_REALSTEP));
    ctx->pri->acts.needPost = mtrue;
}

_mtag void MT2CtxJHHandleJsonText(MT2Ctx_t *ctx, MT2Conn_t *conn, const char *jsonText)
{
    char flagText[50];
    mlog("handle json, from=%s json=%s", ctxConnFlag(ctx, conn, flagText), jsonText);

    json_item_t *item = json_item_parse_from_text(jsonText);
    if(!item)
    {
        mlog("parse fail");
        return;
    }

    json_item_t *cmdItem = json_item_get_subitem_by_name(item, T_CMD);
    if(!cmdItem)
    {
        mlog("cmd not found");
        return;
    }

    const char *cmd = json_item_get_string_value(cmdItem);
    

    //豸Ϣתش
    json_item_t *siditem = json_item_get_subitem_by_name(item, T_SID);
    if(siditem)
    {
#if MT2_OPTION_GATEWAY
        MT2CtxGWJHHandleJson(ctx, conn, item);
#endif
    }
    //ѯ
    else if(strcmp(cmd, T_QUERY) == 0)
    {
        ctxHandleQuery(ctx, conn, item);
    }
    //
    else if(strcmp(cmd, T_OPT) == 0)
    {
        ctxHandleOpt(ctx, conn, item);
    }
    //ظ
    else if(strcmp(cmd, T_RESP) == 0)
    {
        ctxHandleResp(ctx, conn, item);
    }
    //϶·
    else if(strcmp(cmd, T_ACTSOPT) == 0)
    {
        ctxHandleActsOpt(ctx, conn, item);
    }
    else if(strcmp(cmd, T_ACTSSTEP) == 0)
    {
        handleActsStep(ctx, conn, item);
    }
    //϶ͣ
    else if(strcmp(cmd, T_ACTSPAUSE) == 0)
    {
        ctx->pri->eventHandler((MT2Ctx_t *)ctx, MT2EVENT_ACTS_PAUSE, MNULL);
    }
    //϶ʼ
    else if(strcmp(cmd, T_ACTSSTART) == 0)
    {
        ctx->pri->eventHandler((MT2Ctx_t *)ctx, MT2EVENT_ACTS_START, MNULL);
    }
    //϶ֹͣ
    else if(strcmp(cmd, T_ACTSSTOP) == 0)
    {
        ctx->pri->eventHandler((MT2Ctx_t *)ctx, MT2EVENT_ACTS_STOP, MNULL);
    }
    //δЭתش
    else
    {
#if MT2_OPTION_GATEWAY
        MT2CtxGWJHHandleJson(ctx, conn, item);
#endif
    }

    json_item_destroy(item);
}

_mtag void MT2CtxJHSendJson(MT2Ctx_t *ctx, json_item_t *item, MT2Conn_t *toConn, mbool_t freeJson)
{
    muint16_t textlen = (muint16_t)json_item_eval_parse_text_len(item);
    char *text = malloc(textlen + 1);
    json_item_parse_to_text(item, text);

    if(freeJson)
    {
        json_item_destroy(item);
    }

    char flagText[50];
    mlog("send json to %s, json:", ctxConnFlag(ctx, toConn, flagText));
    muint16_t i;
    for(i = 0; i < textlen; i++)
    {
        mprintf("%c", text[i]);
    }
    mprintf("\n");

    //͵ָ
    if(toConn != TO_ALL_CONN)
    {
        MT2ConnSendJsonData(toConn, text);
    }
    //͵
    else
    {
        if(MT2CtxIsOnline((MT2Ctx_t *)ctx))
        {
            MT2ConnSendJsonData(&ctx->pri->serverConn, text);
        }

        for(i = 0; i < LAN_CONN_NUM; i++)
        {
            if(MT2LanConnectionIsValid(&ctx->pri->lanConns[i]))
            {
                MT2ConnSendJsonData(&ctx->pri->lanConns[i], text);
            }
        }
    }

    free(text);
}

_mtag static mbool_t propertyValueChanged(Property_t *property)
{
    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        if(property->value.num != property->postValue.num)
        {
            return mtrue;
        }
    }
    else
    {
        if(property->value.text != property->postValue.text)
        {
            return mtrue;
        }
    }
    return mfalse;
}

_mtag static void ctxChekPcropertys(MT2Ctx_t *ctx)
{
    //¼
    Property_t *property;
    OptInfo_t *optinfoPrev;
    OptInfo_t *optinfo;
    muint8_t i;
    mbool_t needResp;
    MT2ListForeach(&ctx->pri->optinfoList, optinfo)
    {
        needResp = mfalse;

        //ʱ
        if(MT2TimeHasPast(optinfo->optTime, 2000))
        {
            needResp = mtrue;
            mlog("opt timeout, mid:%s", optinfo->mid);
        }
        else
        {
            //
            needResp = mtrue;
            for(i = 0; i < optinfo->propertyNum; i++)
            {
                property = MT2CtxFindProperty(ctx, optinfo->property[i].pid);
                if(!propertyValueChanged(property))
                {
                    needResp = mfalse;
                    break;
                }
            }
        }

        if(needResp)
        {
            optinfoPrev = optinfo->prev;
            ctxHandleAndFreeOptInfo(ctx, optinfo);
            optinfo = optinfoPrev;
        }
    }

    //ֵͬӺpostԱ㽫仯״̬ͬʱ͵ϣblock״̬ϱʱ䲻500ms
    if(ctx->pri->propertyBlockForPost)
    {
        if(MT2TimeHasPast(ctx->pri->propertyLastSyncValueTime, 100)
            || MT2TimeHasPast(ctx->pri->propertyBlockForPostTime, 500))
        {
            ctx->pri->propertyBlockForPost = mfalse;
        }
    }
    else
    {
        //postǰȴؽ
        MT2ListForeach(&ctx->pri->optinfoList, optinfo)
        {
            for(i = 0; i < optinfo->propertyNum; i++)
            {
                property = MT2CtxFindProperty(ctx, optinfo->property[i].pid);
                //Ҫpostʾѷ
                if(propertyValueChanged(property))
                {
                    optinfoPrev = optinfo->prev;
                    ctxHandleAndFreeOptInfo(ctx, optinfo);
                    optinfo = optinfoPrev;
                    break;
                }
            }
        }

        //postֵ֡
        json_item_t *asitem = MNULL;
        json_item_t *pitem;
        MT2ListForeach(&ctx->pri->propertyList, property)
        {
            if(propertyValueChanged(property))
            {
                if(property->type == MT2_PROPERTY_TYPE_NUM)
                {
                    mint64_t diff = property->value.num - property->postValue.num;
                    diff = diff < 0 ? -diff : diff;

                    //Сֵ
                    if(diff < property->threshold
                        && !MT2TimeHasPast(property->setTime, THRESHOLD_DELAY_TIME))
                    {
                        continue;
                    }
                }

                pitem = buildPostPropertyJson(property);
                if(asitem == MNULL)
                {
                    asitem = json_item_create(JSON_OBJECT, T_AS);
                }

                json_object_item_add_subitem(asitem, pitem);
            }
        }

        if(asitem)
        {
            json_item_t *item = json_item_create(JSON_OBJECT, MNULL);
            json_object_item_add_subitem(item, J_CREATE_S(T_CMD, T_POST));
            json_object_item_add_subitem(item, asitem);
            MT2CtxJHSendJson(ctx, item, TO_ALL_CONN, mtrue);
        }
    }
}

_mtag static void fakeCmd(MT2Ctx_t *ctx)
{
    const char *cmds[] =
    {
#if 0
        "{\"cmd\":\"query\",\"mid\":123,\"from\":\"abcdefg\"}",
        "{\"cmd\":\"query\",\"mid\":123,\"from\":\"abcdefg\"}",
        "{\"cmd\":\"query\",\"mid\":123,\"from\":\"abcdefg\"}",
        "{\"cmd\":\"query\",\"mid\":123,\"from\":\"abcdefg\"}",
        "{\"cmd\":\"query\",\"mid\":123,\"from\":\"abcdefg\"}",
        "{\"cmd\":\"query\",\"mid\":123,\"from\":\"abcdefg\"}",
        "{\"cmd\":\"query\",\"mid\":1sdaf1,dsa]}",
        "{\"cmd\":\"query\"}",
        "{\"cmd\":\"opt\",\"mid\":opt,\"from\":\"abcdefg\",\"as\":{\"1\":21}}",
        "{\"cmd\":\"opt\",\"mid\":opt,\"from\":\"abcdefg\",\"as\":{\"2\":2}}",
        "{\"cmd\":\"opt\",\"mid\":opt,\"from\":\"abcdefg\",\"as\":{\"1\":1,\"2\":2}}",
        "{\"cmd\":\"opt\",\"mid\":opt,\"from\":\"abcdefg\",\"as\":{\"3\":3,\"4\":4}}",
        "{\"cmd\":\"opt\",\"from\":\"abcdefg\",\"as\":{\"3\":3,\"4\":4}}",
        "{\"aaa\":[]}",
        "{\"as\":{\"1\":\"-2\",\"10\":\"-2\",\"2\":\"-2\",\"3\":\"-2\",\"4\":\"-2\",\"5\":\"-2\",\"6\":\"-2\",\"7\":\"-2\",\"8\":\"-2\",\"9\":\"-2\"},\"cmd\":\"opt\",\"from\":\"08f96b25aa2d4939ba246a37c9c59966\",\"mid\":\"61665\"}",
        "{\"cmd\":\"addNotify\",\"mid\":\"123\",\"from\":\"abcdefg\",\"sid\":[\"1111111111111111\",\"222222222222222\"]}",
        "{\"cmd\":\"delDev\",\"mid\":\"123\",\"from\":\"abcdefg\",\"devs\":[\"1111111111111111\",\"2222222222222222\"]}"
        "{\"cmd\":\"query\",\"mid\":123,\"sid\":\"00124b0005a3aaf7\"}",
        "{\"cmd\":\"opt\",\"mid\":123,\"from\":\"abcdefg\",\"as\":{\"1\":1},\"sid\":\"00124b0005a3aaf7\"}",
#endif
#if 1
        "{\"cmd\":\"actsStep\",\"mid\":123,\"realStep\":\"2\"}",
#endif
    };
    static mtime_t lastFakeTime;
    static int i;
    if(MT2TimeHasPast(lastFakeTime, 1000))
    {
        lastFakeTime = MT2Time();

        if(i < sizeof(cmds) / sizeof(char *))
        {
            MT2CtxJHHandleJsonText(ctx, &ctx->pri->serverConn, cmds[i]);
            i++;
        }
        else
        {
            i = 0;
        }
    }
    }

_mtag void MT2CtxSendWaitRespJson(MT2Ctx_t *ctx, muint8_t type, mint32_t mid, json_item_t *json)
{
    WaitRespMsg_t *msg = malloc(sizeof(WaitRespMsg_t));
    msg->mid = mid;
    msg->msgType = type;
    msg->time = MT2Time();
    MT2ListAdd(&ctx->pri->waitRespMsgList, msg);

    MT2CtxJHSendJson(ctx, json, &ctx->pri->serverConn, mtrue);
}

_mtag static void delWaitRespMsg(WaitRespMsg_t *msg)
{
    MT2ListDel(msg);
    free(msg);
}

_mtag void MT2CtxJsonHandlerPoll(MT2Ctx_t *ctx)
{
#if MT2_OPTION_GATEWAY
    MT2CtxGWJsonHandlerPoll(ctx);
#endif

    //ȴظϢ
    WaitRespMsg_t *waitRespMsg;
    MT2ListForeach(&ctx->pri->waitRespMsgList, waitRespMsg)
    {
        //ʱ
        if(MT2TimeHasPast(waitRespMsg->time, 5000))
        {
            delWaitRespMsg(waitRespMsg);
            break;
        }
    }

    //ȴظĲѯ
    WaitRespQuery_t *wquery;
    MT2ListForeach(&ctx->pri->waitRespQueryList, wquery)
    {
        //ʱ
        if(MT2TimeHasPast(wquery->time, QUERY_RESP_TIMEOUT))
        {
            ctxHandleAndFreeWaitRespQuery(ctx, wquery);
            break;
        }
    }

    //
    if(MT2CtxIsOnlineOrHasLanConnection(ctx))
    {
        ctxChekPcropertys(ctx);

        if(MT2CtxIsOnline(ctx))
        {
            //ȡԼ
            if(!ctx->pri->gotPropertyConstraint)
            {
                if(ctx->pri->lastFetchPropertyConstraintTime == 0 || MT2TimeHasPast(ctx->pri->lastFetchPropertyConstraintTime, 5000))
                {
                    ctx->pri->lastFetchPropertyConstraintTime = MT2Time();
                    json_item_t *jsonItem = MT2CtxJHJsonBuild(ctx, T_GETAS, MT2NumToString(ctx->pri->mid), MNULL);
                    MT2CtxSendWaitRespJson(ctx, WAIT_RESP_MSG_GET_AS, ctx->pri->mid++, jsonItem);
                }
            }
        }

#if 0
        static bool first;
        if(!first)
        {
            first = mtrue;
            //MT2CtxUnbindUsers(ctx);
        }
        fakeCmd(ctx);
#endif
    }
}




