#ifndef MT2CTX_GATEWAY_PRI_H
#define MT2CTX_GATEWAY_PRI_H
#include "MT2Def.h"
#include "Util/MT2Util.h"
#if MT2_OPTION_GATEWAY
/*******************************************************************************
* define and typedef
******************************************************************************/

typedef struct
{
    mbool_t hasNewDevice;
    MT2GWSubDevice_t deviceList;
    //豸OTA״̬
    struct
    {
        char *deviceId;
        MT2OTAType_t type;
        MT2OTAStatus_t status;
        muint8_t progress;
        mtime_t lastOTAPostTime;
    }ota;

}Gateway_t;
/*******************************************************************************
* Function Declaration
******************************************************************************/
void MT2CtxGatewayPrivateInit(MT2Ctx_t *ctx);
void MT2CtxGatewayPrivatePoll(MT2Ctx_t *ctx);
json_item_t *buildGWDevsJson(MT2GWSubDevice_t *device);
json_item_t *buildPostDevPropertyJson(DevProperty_t *property);

DevProperty_t *MT2CtxGWFindOrRegistDevProperty(MT2GWSubDevice_t *device, muint32_t pid, MT2PropertyType_t type);
void *MT2CtxGWRegistDevProperty(MT2GWSubDevice_t *device, muint32_t pid, MT2PropertyType_t type);
DevProperty_t *MT2CtxGWFindDevProperty(MT2GWSubDevice_t *device, muint32_t pid);

void MT2CtxGWDelDevProperty(DevProperty_t *property);
void MT2CtxGWClearDevPropertyList(MT2GWSubDevice_t *device);
DevOptInfo_t *ctxAddDevOptinfo(MT2GWSubDevice_t *device, const char *mid, muint8_t pnum, MT2GWProperty_t *PropertyList);
void MT2CtxGWDelDevOptInfo(DevOptInfo_t *optinfo);
void MT2CtxGWClearDevOptInfoList(MT2GWSubDevice_t *device);

//device fid
json_item_t *MT2CtxGWDevFidBuildJsonItem(MT2GWSubDevice_t *device);
mbool_t MT2CtxGWDevFidGetBit(MT2GWSubDevice_t *device, muint8_t bitNo);
void MT2CtxGWDevFidSetBit(MT2GWSubDevice_t *device, muint8_t bitNo, mbool_t value);
#endif
#endif // !MT2CTX_GATEWAY_PRI_H
