#include "MT2CtxGateway.h"
#include "MT2CtxPri.h"
#include "MT2CtxGatewayPri.h"
#include "MT2CtxGWJsonHandler.h"
#if MT2_OPTION_GATEWAY
/*******************************************************************************
* Function Declaration
******************************************************************************/

/*******************************************************************************
* Global Variable
******************************************************************************/

/*******************************************************************************
* Function Defination
******************************************************************************/
_mtag void MT2CtxGatewayPrivateInit(MT2Ctx_t *ctx)
{
    MT2ListInit(&ctx->pri->gw.deviceList);

    json_item_regist_value_name(T_SID);
    json_item_regist_value_name(T_ONLINE);
    json_item_regist_value_name(T_VERSION);
    json_item_regist_value_name(T_AS);
}

_mtag void MT2CtxGatewayPrivatePoll(MT2Ctx_t *ctx)
{

}

_mtag json_item_t *buildGWDevsJson(MT2GWSubDevice_t *device)
{
    muint32_t i = 0;
    json_item_t *json = json_item_create(JSON_OBJECT, MNULL);
    json_item_add_subitem(json, J_CREATE_S(T_SID, device->deviceId));
    json_item_add_subitem(json, J_CREATE_N(T_ONLINE, device->online ? "1" : "0"));
    return json;
}

_mtag json_item_t *buildPostDevPropertyJson(DevProperty_t *property)
{
    json_item_t *json;
    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        char key[10];
        strncpy(key, MT2NumToString(property->pid), sizeof(key));
        json = J_CREATE_N(key, MT2NumToString(property->value.num));
        property->postValue.num = property->value.num;
    }
    else
    {
        char key[10];
        strncpy(key, MT2NumToString(property->pid), sizeof(key));
        json = J_CREATE_S(key, property->value.text ? property->value.text : "");

        if(property->postValue.text != property->value.text)
        {
            property->postValue.text = property->value.text;
        }
    }

    return json;
}

//豸
_mtag DevProperty_t *MT2CtxGWFindDevProperty(MT2GWSubDevice_t *device, muint32_t pid)
{
    DevProperty_t *property;
    MT2ListForeach(&device->propertyList, property)
    {
        if(property->pid == pid)
        {
            return property;
        }
    }
    return MNULL;
}

_mtag void *MT2CtxGWRegistDevProperty(MT2GWSubDevice_t *device, muint32_t pid, MT2PropertyType_t type)
{
    DevProperty_t *property = malloc(sizeof(DevProperty_t));
    property->type = type;
    property->pid = pid;
    property->threshold = 0;
    property->readonly = mfalse;
    property->authority = OPT_AUTHORITY_DEF;

    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        property->value.num = 0;
        property->postValue.num = 0;
    }
    else
    {
        property->value.text = malloc(1);
        property->value.text[0] = '\0';
        property->postValue.text = property->value.text;
    }

    MT2ListAdd(&device->propertyList, property);
    return property;
}

_mtag DevProperty_t *MT2CtxGWFindOrRegistDevProperty(MT2GWSubDevice_t *device, muint32_t pid, MT2PropertyType_t type)
{
    DevProperty_t *property = MT2CtxGWFindDevProperty(device, pid);
    if(property == MNULL)
    {
        property = MT2CtxGWRegistDevProperty(device, pid, type);
    }
    return property;
}

_mtag void MT2CtxGWDelDevProperty(DevProperty_t *property)
{
    VTListDel(property);
    if(property->type == MT2_PROPERTY_TYPE_TEXT)
    {
        if(property->value.text)
        {
            free(property->value.text);
        }
    }
    free(property);
}

_mtag void MT2CtxGWClearDevPropertyList(MT2GWSubDevice_t *device)
{
    mlog("MT2CtxGWClearDevPropertyList");
    DevProperty_t *property;
    DevProperty_t *last = NULL;

    MT2ListForeach(&device->propertyList, property)
    {
        if(last)
        {
            MT2CtxGWDelDevProperty(last);
        }
        last = property;
    }
    if(last)
    {
        MT2CtxGWDelDevProperty(last);
    }
}
//豸б
_mtag DevOptInfo_t *ctxAddDevOptinfo(MT2GWSubDevice_t *device, const char *mid, muint8_t pnum, MT2GWProperty_t *propertyList)
{
    DevOptInfo_t *optinfo = malloc(sizeof(DevOptInfo_t));
    optinfo->optTime = MT2Time();
    optinfo->mid = malloc(strlen(mid) + 1);
    strcpy(optinfo->mid, mid);
    optinfo->propertyNum = pnum;
    optinfo->property = propertyList;
    MT2ListAdd(&device->devOptInfoList, optinfo);
    return optinfo;
}

_mtag void MT2CtxGWDelDevOptInfo(DevOptInfo_t *optinfo)
{
    muint8_t i;
    MT2ListDel(optinfo);
    free(optinfo->mid);    
    if(optinfo->property)
    {
        free(optinfo->property);
    }
    free(optinfo);
}

_mtag void MT2CtxGWClearDevOptInfoList(MT2GWSubDevice_t *device)
{
    DevOptInfo_t *optinfo;
    DevOptInfo_t *last = NULL;

    VTListForeach(&device->devOptInfoList, optinfo)
    {
        if(last)
        {
            MT2CtxGWDelDevOptInfo(last);
        }
        last = optinfo;
    }
    if(last)
    {
        MT2CtxGWDelDevOptInfo(last);
    }
    mlog("MT2CtxGWClearDevOptInfoList over");
}


/*******************************************************************************
* Device Fid About
******************************************************************************/
_mtag json_item_t *MT2CtxGWDevFidBuildJsonItem(MT2GWSubDevice_t *device)
{
    muint16_t i;

    json_item_t *fidItem = json_item_create(JSON_ARRAY, T_FIDS);
    for(i = 0; i < 256; i++)
    {
        if(MT2CtxGWDevFidGetBit(device, (uint8_t)i))
        {
            json_array_item_add_subitem(fidItem, J_CREATE_N(MNULL, MT2NumToString(i)));
        }
    }

    return fidItem;
}

_mtag mbool_t MT2CtxGWDevFidGetBit(MT2GWSubDevice_t *device, muint8_t bitNo)
{
    muint8_t offset = 0;
    while(bitNo >= 64)
    {
        bitNo -= 64;
        offset++;
    }
    return ((device->fid.map[offset] >> bitNo) & 1);
}

_mtag void MT2CtxGWDevFidSetBit(MT2GWSubDevice_t *device, muint8_t bitNo, mbool_t value)
{
    muint8_t offset = 0;
    while(bitNo >= 64)
    {
        bitNo -= 64;
        offset++;
    }

    device->fid.map[offset] &= (~(((muint64_t)0x01) << bitNo));

    if(value)
    {
        device->fid.map[offset] |= ((((muint64_t)0x01) << bitNo));
    }
}
#endif