#ifndef MT2CTX_GATEWAY_H
#define MT2CTX_GATEWAY_H
#include "MT2Def.h"
#include "MT2Conn.h"
#include "Util/MT2Util.h"
#if MT2_OPTION_GATEWAY
/*******************************************************************************
* define and typedef
******************************************************************************/

//¼
#define GW_EVENT(x)                (MT2EVENT_GW_START + x)
#define MT2EVENT_GW_ADDNOTIFY      GW_EVENT(1)   //豸֪ͨ
#define MT2EVENT_GW_DELDEV         GW_EVENT(2)   //ɾ豸
#define MT2EVENT_GW_SYNC_DEVS      GW_EVENT(3)   //ͬ豸б
#define MT2EVENT_GW_REPORT_ONLINE  GW_EVENT(4)   //֪ͨʼ״̬
#define MT2EVENT_GW_DEVICE_QUERY   GW_EVENT(5)   //ѯ豸
#define MT2EVENT_GW_DEVICE_OPT     GW_EVENT(6)   //豸
#define MT2EVENT_GW_DEVICE_UPGRADE GW_EVENT(7)   //豸

#define DEVICE_ID_MAX_LEN 20

typedef struct MT2EventGWAddNotifyArg_st
{
    char *mid;
    char *from;
    struct
    {
        muint32_t num;
        char **value;
    }sid;
    struct
    {
        muint32_t num;
        char **value;
    }model;

}MT2EventGWAddNotifyArg_t;

typedef struct MT2DevInfo_st
{
    char *deviceId;
    char *model;
}MT2DevInfo_t;

typedef struct MT2EventGWDelDevArg_st
{
    muint32_t num;
    MT2DevInfo_t *dev;
}MT2EventGWDevList_t;

//ֵ
typedef union
{
    mint32_t num;
    char *text;
}MT2GWPropertyValue_t;

typedef struct
{
    muint32_t pid;
    MT2PropertyType_t type;
    MT2GWPropertyValue_t value;
}MT2GWProperty_t;

typedef struct MT2EventGWOptDeviceArg_st
{
    char *deviceId;
    muint32_t propertyNum;
    MT2GWProperty_t *propertys;
}MT2EventGWOptDeviceArg_t;

//̼
typedef enum
{
    MT2_GW_UPGRADE_TARGET_GATEWAY = 0,
    MT2_GW_UPGRADE_TARGET_SUBDEVICE = 1,
}MT2GWUpgradeTarget_t;

typedef struct
{
    MT2OTAType_t type;       //̼
    char addr[16 + 1];
    char *version; //汾
    struct
    {
        char *url;
        char *md5;
        char *versionId;
    }firmware[2];
}MT2EventGWDeviceUpgradeArg_t;

typedef struct DevOptInfo_st
{
    char *mid;
    muint8_t propertyNum;
    MT2GWProperty_t *property;
    mtime_t optTime;
    MT2LIST_ENTRY(struct DevOptInfo_st);
}DevOptInfo_t;

typedef struct DevProperty_st
{
    muint32_t pid;
    MT2PropertyType_t type : 2;
    mbool_t readonly : 1;       //ֻɿ
    muint8_t authority : 5;     //Ȩ޿
    mint32_t threshold;         //ֵ
    mtime_t setTime;
    muint8_t numLen;            //Գ
    MT2GWPropertyValue_t value;
    MT2GWPropertyValue_t postValue;
    MT2LIST_ENTRY(struct DevProperty_st);
}DevProperty_t;

//豸ȴظĲѯ
typedef struct WaitRespDevQuery_st
{
    char *mid;
    char *from;
    mtime_t time;
    MT2Conn_t *conn;
    MT2LIST_ENTRY(struct WaitRespDevQuery_st);
}WaitRespDevQuery_t;

//豸״̬
typedef enum
{
    MT2_GW_DEVICE_STATE_NONE         = 0, //ʼ״̬
    MT2_GW_DEVICE_STATE_CONNECTED    = 1, //ͨѶ
    MT2_GW_DEVICE_STATE_QUERYING     = 2, //ѯ
    MT2_GW_DEVICE_STATE_QUERY_FINISH = 3, //ѯ
}MT2GWDeviceState_t;

typedef struct MT2GWSubDevice_st
{
    char *deviceId;
    char *module;
    muint16_t hbInterval;
    mbool_t online;
    mtime_t lastHbTime;
    muint8_t modVersion[4];
    muint8_t devVersion[4];


    MT2GWDeviceState_t state;
    mbool_t needReportAddDev : 1;
    mbool_t needReportOnlineState : 1;

    //
    DevProperty_t propertyList;
    mbool_t propertyBlockForPost;
    mtime_t propertyLastSyncValueTime;
    mtime_t propertyBlockForPostTime;

    DevOptInfo_t devOptInfoList;
    muint32_t lastOptTimeStamp;

    //ȴظĲѯ
    WaitRespDevQuery_t waitRespDevQueryList;

    //Ϣ
    struct
    {
        //4 * 64 bit, 뷶Χ0-255
        muint64_t map[4];
    }fid;
    VTLIST_ENTRY(struct MT2GWSubDevice_st);
}MT2GWSubDevice_t;

#define MAX_GPLOT_NODE_SIZE 128 
typedef struct ChildNode_st
{
    muint32_t childIndex;
    MT2LIST_ENTRY(struct ChildNode_st);
}ChildNode_t;

typedef struct
{
    mbool_t isUsed;
    muint32_t index;
    char *data;          //ֵ 
    ChildNode_t childList; //ͷָ  
}GplotNode_t;

typedef struct
{
    GplotNode_t nodes[MAX_GPLOT_NODE_SIZE];
    muint32_t num;    //
    muint32_t root;  //λ   
}MT2GWGplot_t;
/*******************************************************************************
* Function Declaration
******************************************************************************/
void MT2CtxGWEventArgDestory(MT2Ctx_t *ctx, uint8_t event, void *arg);
void MT2CtxGWRespAddNotify(MT2Ctx_t *ctx, MT2EventGWAddNotifyArg_t *arg);
void MT2CtxGWReportAddDev(MT2Ctx_t *ctx);
void MT2CtxGWReportSynDevs(MT2Ctx_t *ctx);
void MT2CtxGWReportOnlineState(MT2Ctx_t *ctx, MT2GWSubDevice_t *device);
void MT2CtxGWReportOnlineStateNotify(MT2Ctx_t *ctx);
void MT2CtxGWSetOnlineState(MT2Ctx_t *ctx, MT2GWSubDevice_t *device, mbool_t isOnline);
mbool_t MT2CtxGWGetOnlineState(MT2Ctx_t *ctx, MT2GWSubDevice_t *device);
void MT2CtxGWDeviceUpdateOTAStatus(MT2Ctx_t *ctx, MT2OTAType_t type, MT2OTAStatus_t status, muint8_t progress, const muint8_t *newVersion, const char *sid);

void MT2CtxGWReportGplot(MT2Ctx_t *ctx, MT2GWGplot_t *gplot);
MT2GWSubDevice_t *MT2CtxGWGetSubDeviceList(MT2Ctx_t *ctx);
MT2GWSubDevice_t *MT2CtxGWFindSubDevice(MT2Ctx_t *ctx, const char *deviceId);
void MT2CtxGWAddSubDevice(MT2Ctx_t *ctx, const char *deviceId, const char *module, muint16_t hb, mbool_t newDevice);
void MT2CtxGWDelSubDevice(MT2Ctx_t *ctx, const char *deviceId);
void MT2CtxGWSetNewSubDeviceReport(MT2Ctx_t *ctx, const char *deviceId);

void MT2CtxGWSyncDevPropertyValue(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid, MT2PropertyType_t type, MT2GWPropertyValue_t value , muint32_t timeStamp);
MT2GWPropertyValue_t MT2CtxGWGetDevPropertyValue(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid);
mbool_t MT2CtxGWDevPropertyHasRegist(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid);
MT2PropertyType_t MT2CtxGWGetDevPropertyType(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid);

void MT2CtxDevQueryEnd(MT2Ctx_t *ctx, const char *deviceId);
void MT2CtxGWReportDevFault(MT2Ctx_t *ctx, const char *deviceId, const muint8_t *fids, muint8_t count);

void MT2CtxGWSetDeviceHbTime(MT2Ctx_t *ctx, const char *deviceId);
muint8_t MT2CtxGWGetNumPropertyLength(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid);
void MT2CtxGWSetNumPropertyLength(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid, muint8_t numLen);

void MT2GWPostAll(MT2Ctx_t *ctx, MT2Conn_t *conn, mbool_t isresp, const char *mid, const char *from);
void MT2CtxGWSetSubDeviceState(MT2Ctx_t *ctx, const char *deviceId, MT2GWDeviceState_t state);
MT2GWDeviceState_t MT2CtxGWGetSubDeviceState(MT2Ctx_t *ctx, const char *deviceId);
void MT2CtxGWSetSubDeviceVersion(MT2Ctx_t *ctx, const char *deviceId, muint8_t *version);
muint8_t *MT2CtxGWGetSubDeviceVersion(MT2Ctx_t *ctx, const char *deviceId);
void MT2CtxGWSetSubDeviceModule(MT2Ctx_t *ctx, const char *deviceId, const char *module);
char *MT2CtxGWGetSubDeviceModule(MT2Ctx_t *ctx, const char *deviceId);
#endif
#endif // !MT2CTX_GATEWAY_H
