#include "MT2CtxGateway.h"
#include "MT2CtxPri.h"
#if MT2_OPTION_GATEWAY
/*******************************************************************************
* Function Declaration
******************************************************************************/

/*******************************************************************************
* Global Variable
******************************************************************************/

/*******************************************************************************
* Function Defination
******************************************************************************/

//豸б
_mtag MT2GWSubDevice_t *MT2CtxGWGetSubDeviceList(MT2Ctx_t *ctx)
{
    return &ctx->pri->gw.deviceList;
}

_mtag static void subDeviceInit(MT2GWSubDevice_t *device, const char *deviceId, const char *module, muint16_t hb)
{
    device->deviceId = malloc(strlen(deviceId) + 1);
    memset(device->deviceId, 0, strlen(deviceId) + 1);
    strcpy(device->deviceId, deviceId);
    
    if(module)
    {
        device->module = malloc(strlen(module) + 1);
        memset(device->module, 0, strlen(module) + 1);
        strcpy(device->module, module);
    }

    device->hbInterval = hb;
    MT2ListInit(&device->propertyList);
    MT2ListInit(&device->devOptInfoList);
    MT2ListInit(&device->waitRespDevQueryList);
}

_mtag static void subDeviceClear(MT2GWSubDevice_t *device)
{
    if(device->deviceId)
    {
        free(device->deviceId);
    }

    if(device->module)
    {
        free(device->module);
    }

    MT2CtxGWClearDevPropertyList(device);
    MT2CtxGWClearDevOptInfoList(device);
}

_mtag MT2GWSubDevice_t *MT2CtxGWFindSubDevice(MT2Ctx_t *ctx, const char *deviceId)
{
    if(deviceId)
    {
        MT2GWSubDevice_t *device;
        VTListForeach(&ctx->pri->gw.deviceList, device)
        {
            if(strcmp(device->deviceId, deviceId) == 0)
            {
                return device;
            }
        }
    }
    return MNULL;
}

_mtag void MT2CtxGWAddSubDevice(MT2Ctx_t *ctx, const char *deviceId, const char *module, muint16_t hb, mbool_t newDevice)
{
    mlog("MT2CtxGWAddSubDevice deviceId = %s",deviceId);
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device == MNULL)
    {
        device = malloc(sizeof(MT2GWSubDevice_t));
        memset(device, 0, sizeof(MT2GWSubDevice_t));
        VTListAdd(&ctx->pri->gw.deviceList, device);
    }
    else
    {
        subDeviceClear(device);
    }
    subDeviceInit(device, deviceId, module, hb);

    //豸ϱ
     device->needReportAddDev = newDevice ? mtrue : mfalse;
     if(newDevice)
     {
         ctx->pri->gw.hasNewDevice = mtrue;
     }
}

_mtag void MT2CtxGWDelSubDevice(MT2Ctx_t *ctx, const char *deviceId)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        subDeviceClear(device);
        VTListDel(device);
        free(device);
    }
}
//豸Ϊ豸
_mtag void MT2CtxGWSetNewSubDeviceReport(MT2Ctx_t *ctx, const char *deviceId)
{
    MT2GWSubDevice_t *device = MNULL;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        device->needReportAddDev = true;
        ctx->pri->gw.hasNewDevice = mtrue;
    }
}
//ֵͬ
_mtag void MT2CtxGWSyncDevPropertyValue(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid, MT2PropertyType_t type, MT2GWPropertyValue_t value, muint32_t timeStamp)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device == MNULL)
    {
        return;
    }

    //δעֱע
    DevProperty_t *property = MT2CtxGWFindOrRegistDevProperty(device, pid, type);
    bool changed = false;
    device->lastOptTimeStamp = timeStamp;
    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        if(property->value.num != value.num)
        {
            changed = true;
            property->value.num = value.num;

            mlog("sync property, id=%d value=%d", pid, value.num);
        }
    }
    else
    {
        if(property->value.text == MNULL || strcmp(property->value.text, value.text) != 0)
        {
            changed = true;

            char *needFree = property->value.text;

            property->value.text = malloc(strlen(value.text) + 1);
            strcpy(property->value.text, value.text);

            //Ӻfreemalloc䵽ͬڴΪж״̬仯ͨȽڴַжϵ
            if(needFree)
            {
                free(needFree);
            }

            mlog("sync property, id=%d value=%s", pid, property->value.text);
        }
    }

    if(changed)
    {
        property->setTime = MT2Time();

        device->propertyLastSyncValueTime = MT2Time();
        if(!device->propertyBlockForPost)
        {
            device->propertyBlockForPost = mtrue;
            device->propertyBlockForPostTime = MT2Time();
        }
    }
}

_mtag MT2GWPropertyValue_t MT2CtxGWGetDevPropertyValue(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        DevProperty_t *property = MT2CtxGWFindDevProperty(device, pid);
        if(property)
        {
            return property->value;
        }
    }
    MT2GWPropertyValue_t value;
    value.num = 0;
    return value;
}

_mtag mbool_t MT2CtxGWDevPropertyHasRegist(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device == MNULL)
    {
        return mfalse;
    }

    DevProperty_t *property = MT2CtxGWFindDevProperty(device, pid);
    return property != MNULL;
}

_mtag MT2PropertyType_t MT2CtxGWGetDevPropertyType(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device == MNULL)
    {
        return MT2_PROPERTY_TYPE_NUM;
    }

    DevProperty_t *property = MT2CtxGWFindDevProperty(device, pid);
    if(property)
    {
        return property->type;
    }
    return MT2_PROPERTY_TYPE_NUM;
}

_mtag void MT2CtxGWReportDevFault(MT2Ctx_t *ctx, const char *deviceId, const muint8_t *fids, muint8_t count)
{
    mlog("deviceId: %s report fault:", deviceId);
    muint16_t i;
    for(i = 0; i < count; i++)
    {
        mprintf("%d ", fids[i]);
    }
    mprintf("\n");

    MT2GWSubDevice_t *device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device == MNULL)
    {
        return;
    }
    //¹״̬
    muint64_t tmpMap[4];
    memcpy(&tmpMap, device->fid.map, sizeof(device->fid.map));
    memset(device->fid.map, 0, sizeof(device->fid.map));
    for(i = 0; i < count; i++)
    {
        MT2CtxGWDevFidSetBit(device, fids[i], mtrue);
    }

    //״̬һ£ϱ
    if(memcmp(device->fid.map, tmpMap, sizeof(device->fid.map)) != 0)
    {
        if(MT2CtxIsOnlineOrHasLanConnection(ctx))
        {
            json_item_t *item = MT2CtxJHJsonBuild(ctx, T_FAULT, MNULL, MNULL);
            json_object_item_add_subitem(item, J_CREATE_S(T_SID, device->deviceId));
            json_object_item_add_subitem(item, MT2CtxGWDevFidBuildJsonItem(device));
            MT2CtxJHSendJson(ctx, item, TO_ALL_CONN, mtrue);
        }
    }
}

_mtag void MT2CtxGWSetDeviceHbTime(MT2Ctx_t *ctx, const char *deviceId)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        device->lastHbTime = MT2Time();
    }
}

_mtag mtime_t MT2CtxGWGetDeviceHbTime(MT2Ctx_t *ctx, const char *deviceId)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        return device->lastHbTime;
    }

    return 0;
}

_mtag muint8_t MT2CtxGWGetNumPropertyLength(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        DevProperty_t *property = MT2CtxGWFindDevProperty(device, pid);
        if(property)
        {
            return property->numLen;
        }
    }

    return sizeof(uint32_t);
}

_mtag void MT2CtxGWSetNumPropertyLength(MT2Ctx_t *ctx, const char *deviceId, muint32_t pid, muint8_t numLen)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        DevProperty_t *property = MT2CtxGWFindDevProperty(device, pid);
        if(property && property->type == MT2_PROPERTY_TYPE_NUM)
        {
            property->numLen = numLen;
        }
    }
}

_mtag void MT2CtxGWSetSubDeviceState(MT2Ctx_t *ctx, const char *deviceId, MT2GWDeviceState_t state)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        device->state = state;
    }
}

_mtag MT2GWDeviceState_t MT2CtxGWGetSubDeviceState(MT2Ctx_t *ctx, const char *deviceId)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        return device->state;
    }
    return MT2_GW_DEVICE_STATE_NONE;
}

_mtag void MT2CtxGWSetSubDeviceVersion(MT2Ctx_t *ctx, const char *deviceId, muint8_t *version)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        memcpy(device->devVersion, version, 4);
    }
}

_mtag muint8_t *MT2CtxGWGetSubDeviceVersion(MT2Ctx_t *ctx, const char *deviceId)
{
    muint8_t emptyVersion[4] = {0};
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        return device->devVersion;
    }
    return emptyVersion;
}

_mtag void MT2CtxGWSetSubDeviceModule(MT2Ctx_t *ctx, const char *deviceId, const char *module)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        if(device->module)
        {
            free(device->module);
        }

        device->module = malloc(strlen(module) + 1);
        memset(device->module, 0, strlen(module) + 1);
        strcpy(device->module, module);
    }
}

_mtag char *MT2CtxGWGetSubDeviceModule(MT2Ctx_t *ctx, const char *deviceId)
{
    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        return device->module;
    }
    return "";
}
#endif
