#include "MT2CtxGWJsonHandler.h"
#include "MT2CtxJsonHandler.h"
#include "MT2CtxGatewayPri.h"
#if MT2_OPTION_GATEWAY

#define DEV_THRESHOLD_DELAY_TIME 5000           //δֵʱʱ
#define DEV_QUERY_RESP_TIMEOUT   1000             //豸ѯʱʱ
#define GW_QUERY_RESP_TIMEOUT    1000              //زѯʱʱ
/*******************************************************************************
* Function Declaration
******************************************************************************/
static void ctxHandleAddNotify(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json);
static void ctxHandleDelDev(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json);
static void ctxHandleSynDevs(MT2Ctx_t *ctx, MT2Conn_t *fromConn,json_item_t *json);
static void ctxHandleGWQuery(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json);
static json_item_t *buildPostGWPropertyJson(Property_t *property);
static json_item_t *buildGWOTAStatusItem(MT2Ctx_t *ctx, MT2GWUpgradeTarget_t target);
static void ctxAddWaitDevQuery(MT2GWSubDevice_t *device, MT2Conn_t *fromConn, const char *mid, const char *from);
static void ctxHandleGWDeviceQuery(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json);
static void ctxHandleGWDeviceOpt(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json);
static void ctxHandleGWDeviceUpgrade(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json);
static json_item_t *buildGplotJson(MT2GWGplot_t *gplot, GplotNode_t *node);
static void ctxGWChekDevPcropertys(MT2Ctx_t *ctx, MT2GWSubDevice_t *device);
static void ctxHandleAndFreeWaitRespDevQuery(MT2Ctx_t *ctx, MT2GWSubDevice_t *device, WaitRespDevQuery_t *wquery);
/*******************************************************************************
* Global Variable
******************************************************************************/

/*******************************************************************************
* Function Defination
******************************************************************************/

_mtag void MT2CtxGWJsonHandlerInit(MT2Ctx_t *ctx)
{
    MT2CtxGatewayPrivateInit(ctx);
}

_mtag void MT2CtxGWJsonHandlerPoll(MT2Ctx_t *ctx)
{
    MT2CtxGatewayPrivatePoll(ctx);

    if(MT2CtxIsOnlineOrHasLanConnection(ctx))
    {
        MT2GWSubDevice_t *device;
        MT2ListForeach(&ctx->pri->gw.deviceList, device)
        {
            ctxGWChekDevPcropertys(ctx, device);

            //ȴظĲѯ
            WaitRespDevQuery_t *wquery;
            MT2ListForeach(&device->waitRespDevQueryList, wquery)
            {
                //ʱ
                if(MT2TimeHasPast(wquery->time, DEV_QUERY_RESP_TIMEOUT))
                {
                    ctxHandleAndFreeWaitRespDevQuery(ctx, device, wquery);
                    break;
                }
            }
        }
    }
}

_mtag void MT2CtxGWJHHandleJson(MT2Ctx_t *ctx, MT2Conn_t *conn, json_item_t *json)
{
    json_item_t *cmdItem = json_item_get_subitem_by_name(json, T_CMD);
    const char *cmd = json_item_get_string_value(cmdItem);
    json_item_t *siditem = json_item_get_subitem_by_name(json, T_SID);

    if(strcmp(cmd, T_ADDNOTIFY) == 0)
    {
        ctxHandleAddNotify(ctx, conn, json);
    }
    else if(strcmp(cmd, T_DELDEV) == 0)
    {
        ctxHandleDelDev(ctx, conn, json);
    }
    else if(strcmp(cmd, T_SYNDEVS) == 0)
    {
        ctxHandleSynDevs(ctx, conn, json);
    }
    else if(strcmp(cmd, T_QUERY) == 0)
    {
        ctxHandleGWDeviceQuery(ctx, conn, json);
    }
    else if(strcmp(cmd, T_OPT) == 0)
    {
        ctxHandleGWDeviceOpt(ctx, conn, json);
    }
    else if(strcmp(cmd, T_SUBUPGRADE) == 0)
    {
        ctxHandleGWDeviceUpgrade(ctx, conn, json);
    }

}

_mtag void MT2CtxGWJHHandleResp(MT2Ctx_t *ctx, uint8_t respType, json_item_t *json)
{
    
}

_mtag void MT2CtxGWEventArgDestory(MT2Ctx_t *ctx, uint8_t event, void *arg)
{
    LOGDBG("MT2CtxGWEventArgDestory");
    muint32_t i,j;
    if(event == MT2EVENT_GW_ADDNOTIFY)
    {
        MT2EventGWAddNotifyArg_t *addNotifyArg = (MT2EventGWAddNotifyArg_t *)arg;

        if(addNotifyArg->mid)
        {
            free(addNotifyArg->mid);
        }
        if(addNotifyArg->from)
        {
            free(addNotifyArg->from);
        }
        if(addNotifyArg->sid.num)
        {
            
            for(i = 0; i < addNotifyArg->sid.num; i++)
            {
                if(addNotifyArg->sid.value[i])
                {
                    free(addNotifyArg->sid.value[i]);
                }
            }
            free(addNotifyArg->sid.value);
        }

        if(addNotifyArg->model.num)
        {

            for(i = 0; i < addNotifyArg->model.num; i++)
            {
                if(addNotifyArg->model.value[i])
                {
                    free(addNotifyArg->model.value[i]);
                }
            }
            free(addNotifyArg->model.value);
        }
    }
    else if(event == MT2EVENT_GW_DELDEV || event == MT2EVENT_GW_SYNC_DEVS)
    {
        MT2EventGWDevList_t *delDevArg = (MT2EventGWDevList_t *)arg;
        if(delDevArg->num)
        {
            for(i = 0; i < delDevArg->num; i++)
            {
                if(delDevArg->dev[i].deviceId)
                {
                    free(delDevArg->dev[i].deviceId);
                }
                if(delDevArg->dev[i].model)
                {
                    free(delDevArg->dev[i].model);
                }
            }
            free(delDevArg->dev);
        }
    }
    else if(event == MT2EVENT_GW_DEVICE_QUERY)
    {
        if(arg)
        {
            free(arg);
        }
    }
    else if(event == MT2EVENT_GW_DEVICE_OPT)
    {
        MT2EventGWOptDeviceArg_t *devOpt = (MT2EventGWOptDeviceArg_t *)arg;
        if(devOpt->deviceId)
        {
            free(devOpt->deviceId);
        }
    }
    else if(event == MT2EVENT_GW_DEVICE_UPGRADE)
    {
        MT2EventGWDeviceUpgradeArg_t *devUpgrade = (MT2EventGWDeviceUpgradeArg_t *)arg;

        if(devUpgrade->version)
        {
            free(devUpgrade->version);
        }
        
        if(devUpgrade->firmware[0].md5)
        {
            free(devUpgrade->firmware[0].md5);
        }

        if(devUpgrade->firmware[0].url)
        {
            free(devUpgrade->firmware[0].url);
        }

        if(devUpgrade->firmware[0].versionId)
        {
            free(devUpgrade->firmware[0].versionId);
        }

        if(devUpgrade->firmware[1].md5)
        {
            free(devUpgrade->firmware[1].md5);
        }

        if(devUpgrade->firmware[1].url)
        {
            free(devUpgrade->firmware[1].url);
        }

        if(devUpgrade->firmware[1].versionId)
        {
            free(devUpgrade->firmware[1].versionId);
        }
    }
}

//豸֪ͨ
_mtag static void ctxHandleAddNotify(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json)
{
    mint32_t i;
    const char *itemText;
    MT2EventGWAddNotifyArg_t arg;
    const char *mid = json_item_get_string_value(json_item_get_subitem_by_name(json, T_MID));
    json_item_t *fromItem = json_item_get_subitem_by_name(json, T_FROM);
    json_item_t *sidItem = json_item_get_subitem_by_name(json, T_SID);
    json_item_t *modelItem = json_item_get_subitem_by_name(json, T_MODEL);

    memset(&arg, 0, sizeof(MT2EventGWAddNotifyArg_t));
    arg.mid = malloc(strlen(mid) + 1);
    memset(arg.mid, 0, sizeof(arg.mid));
    strcat(arg.mid, mid);

    if(fromItem)
    {
        const char *from = json_item_get_string_value(fromItem);
        arg.from = malloc(strlen(from) + 1);
        memset(arg.from, 0, sizeof(arg.from));
        strcat(arg.from, from);
    }

    if(sidItem)
    {
        arg.sid.num = json_item_get_subitem_count(sidItem);
        arg.sid.value = malloc(arg.sid.num * sizeof(arg.sid.value));
        for(i = 0; i < arg.sid.num; i++)
        {
            itemText = json_item_get_string_value(json_item_get_subitem_by_index(sidItem, i));
            arg.sid.value[i] = malloc(strlen(itemText) + 1);
            memset(arg.sid.value[i], 0, sizeof(strlen(itemText) + 1));
            strcat(arg.sid.value[i], itemText);
        }
    }

    if(modelItem)
    {
        arg.model.num = json_item_get_subitem_count(modelItem);
        arg.model.value = malloc(arg.model.num * sizeof(arg.model.value));
        for(i = 0; i < arg.model.num; i++)
        {
            itemText = json_item_get_string_value(json_item_get_subitem_by_index(modelItem, i));
            arg.model.value[i] = malloc(strlen(itemText) + 1);
            memset(arg.model.value[i], 0, sizeof(strlen(itemText) + 1));
            strcat(arg.model.value[i], itemText);
        }
    }
    ctx->pri->eventHandler(ctx, MT2EVENT_GW_ADDNOTIFY, &arg);
}

_mtag void MT2CtxGWRespAddNotify(MT2Ctx_t *ctx, MT2EventGWAddNotifyArg_t *arg)
{
    json_item_t *json = MT2CtxJHJsonBuild(ctx, T_RESP, arg->mid, arg->from);
    MT2CtxJHSendJson(ctx, json, &ctx->pri->serverConn, mtrue);
}

//豸
_mtag void MT2CtxGWReportAddDev(MT2Ctx_t *ctx)
{
    mint32_t i;
    if(ctx->pri->gw.hasNewDevice)
    {
        json_item_t *json = MT2CtxJHJsonBuild(ctx, T_ADDDEV, MNULL, MNULL);
        json_item_t *devsJson = json_item_create(JSON_ARRAY, T_DEVS);

        MT2GWSubDevice_t *device;
        MT2ListForeach(&ctx->pri->gw.deviceList, device)
        {
            if(device->needReportAddDev)
            {
                device->needReportAddDev = mfalse;
                json_item_t *devVar = json_item_create(JSON_OBJECT, NULL);
                json_item_add_subitem(devVar, J_CREATE_S(T_SID, device->deviceId));
                json_item_add_subitem(devVar, J_CREATE_S(T_MODEL, device->module));
                json_item_add_subitem(devsJson, devVar);
            }
        }
        json_item_add_subitem(json, devsJson);

        MT2CtxJHSendJson(ctx, json, TO_ALL_CONN, mtrue);
        ctx->pri->gw.hasNewDevice = mfalse;
    }
}

//豸ɾ
_mtag static void ctxHandleDelDev(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json)
{
    mint32_t i;
    const char *itemText;
    MT2EventGWDevList_t arg = {0};
    json_item_t *devs = json_item_get_subitem_by_name(json, T_DEVS);

    if(devs)
    {
        arg.num = json_item_get_subitem_count(devs);
        arg.dev = malloc(arg.num * sizeof(MT2DevInfo_t));
        memset(arg.dev, 0, arg.num * sizeof(MT2DevInfo_t));

        mlog("ctxHandleDelDev num = %d ",arg.num);
        for(i = 0; i < arg.num; i++)
        {
            itemText = json_item_get_string_value(json_item_get_subitem_by_index(devs, i));
            arg.dev[i].deviceId = malloc(strlen(itemText) + 1);
            memset(arg.dev[i].deviceId, 0, strlen(itemText) + 1);
            strcat(arg.dev[i].deviceId, itemText);
            arg.dev[i].model = MNULL;
            mlog("ctxHandleDelDev %s ", arg.dev[i].deviceId);
        }
        ctx->pri->eventHandler(ctx, MT2EVENT_GW_DELDEV, &arg);
    }
}

//ͬ豸б
_mtag void MT2CtxGWReportSynDevs(MT2Ctx_t *ctx)
{
    json_item_t *json = MT2CtxJHJsonBuild(ctx, T_SYNDEVS, MNULL, MNULL);
    MT2CtxJHSendJson(ctx, json, &ctx->pri->serverConn, mtrue);
}

_mtag static void ctxHandleSynDevs(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json)
{
    mint8_t i;
    const char *itemText;
    MT2EventGWDevList_t arg = {0};
    json_item_t *devs = json_item_get_subitem_by_name(json, T_DEVS);

    if(devs)
    {
        arg.num = json_item_get_subitem_count(devs);
        json_item_t *checkNum = json_item_get_subitem_by_index(devs,0);
        if(checkNum)
        {
            char *value = (char *)checkNum->value;
            if(strlen(value) == 0)
            {
                arg.num = 0;
            }
        }

        if(arg.num)
        {
            arg.dev = malloc(arg.num * sizeof(MT2DevInfo_t));
            memset(arg.dev, 0, arg.num * sizeof(MT2DevInfo_t));
            for(i = 0; i < arg.num; i++)
            {
                json_item_t *dev = json_item_get_subitem_by_index(devs, i);
                itemText = J_SUB_VALUE_BY_NAME_S(dev, T_SID);
                arg.dev[i].deviceId = malloc(strlen(itemText) + 1);
                memset(arg.dev[i].deviceId, 0, strlen(itemText) + 1);
                strcpy(arg.dev[i].deviceId, itemText);

                itemText = J_SUB_VALUE_BY_NAME_S(dev, T_MODEL);
                arg.dev[i].model = malloc(strlen(itemText) + 1);
                memset(arg.dev[i].model, 0, strlen(itemText) + 1);
                strcpy(arg.dev[i].model, itemText);

            }
        }
        ctx->pri->eventHandler(ctx, MT2EVENT_GW_SYNC_DEVS, &arg);
    }
}

//豸֪ͨ
_mtag void MT2CtxGWSetOnlineState(MT2Ctx_t *ctx, MT2GWSubDevice_t *device, mbool_t isOnline)
{
    device->online = isOnline;
}

_mtag mbool_t MT2CtxGWGetOnlineState(MT2Ctx_t *ctx, MT2GWSubDevice_t *device)
{
    return device->online;
}

_mtag void MT2CtxGWReportOnlineState(MT2Ctx_t *ctx, MT2GWSubDevice_t *device)
{
    json_item_t *jsonItem = MT2CtxJHJsonBuild(ctx, (device->online ? T_ONLINE : T_OFFLINE), MNULL, MNULL);
    json_item_add_subitem(jsonItem, J_CREATE_S(T_SID, device->deviceId));

    if(device->online)
    {
        json_item_t *jsonVersion = json_item_create(JSON_ARRAY, T_VERSION);
        uint8_t emptyAddr[4] = {0};
        char verStr[20] = {0};

        sprintf(verStr, "%d.%d.%d.%d",
            device->devVersion[0],
            device->devVersion[1],
            device->devVersion[2],
            device->devVersion[3]);
        json_item_add_subitem(jsonVersion, J_CREATE_S(MNULL, verStr));

        if(memcmp(device->modVersion, emptyAddr, sizeof(emptyAddr)) != 0)
        {
            memset(verStr, 0, sizeof(verStr));
            sprintf(verStr, "%d.%d.%d.%d",
                device->modVersion[0],
                device->modVersion[1],
                device->modVersion[2],
                device->modVersion[3]);
            json_item_add_subitem(jsonVersion, J_CREATE_S(MNULL, verStr));
        }

        json_item_add_subitem(jsonItem, jsonVersion);
    }

    MT2CtxJHSendJson(ctx, jsonItem, TO_ALL_CONN, mtrue);
}

_mtag void MT2CtxGWReportOnlineStateNotify(MT2Ctx_t *ctx)
{
    ctx->pri->eventHandler(ctx, MT2EVENT_GW_REPORT_ONLINE, MNULL);
}

//ѯ
_mtag void MT2GWPostAll(MT2Ctx_t *ctx, MT2Conn_t *conn, mbool_t isresp, const char *mid, const char *from)
{
    json_item_t *item = MNULL;
    if(isresp)
    {
        if(from && strlen(from))
        {
            item = MT2CtxJHJsonBuild(ctx, T_RESP, mid, from);
        }
        else
        {
            item = MT2CtxJHJsonBuild(ctx, T_RESP, mid, MNULL);
        }
    }
    else
    {
        item = MT2CtxJHJsonBuild(ctx, T_POST, MNULL, MNULL);
    }

    //״̬
    json_item_t *asItem = json_item_create(JSON_OBJECT, T_AS);
    json_object_item_add_subitem(item, asItem);
    Property_t *property;
    MT2ListForeach(&ctx->pri->propertyList, property)
    {
        json_object_item_add_subitem(asItem, buildPostGWPropertyJson(property));
    }

    //״̬
    json_object_item_add_subitem(item, MT2CtxFidBuildJsonItem(ctx));

    //OTA
    if(ctx->pri->ota.status != MT2_OTA_STATUS_IDLE && ctx->pri->ota.type == MT2_OTA_TYPE_MODULE)
    {
        json_object_item_add_subitem(item, buildGWOTAStatusItem(ctx, MT2_GW_UPGRADE_TARGET_GATEWAY));
    }
    //豸б
    json_item_t *devJson = json_item_create(JSON_ARRAY, T_DEVS);
    json_object_item_add_subitem(item, devJson);
    MT2GWSubDevice_t *device;
    MT2ListForeach(&ctx->pri->gw.deviceList, device)
    {
        json_array_item_add_subitem(devJson, buildGWDevsJson(device));
    }

    if(conn->alloc)
    {
        MT2CtxJHSendJson(ctx, item, conn, mtrue);
    }
    else
    {
        json_item_destroy(item);
    }
}

_mtag static json_item_t *buildPostGWPropertyJson(Property_t *property)
{
    json_item_t *json;
    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        char key[10];
        strncpy(key, MT2NumToString(property->pid), sizeof(key));
        json = J_CREATE_N(key, MT2NumToString(property->value.num));
        property->postValue.num = property->value.num;
    }
    else
    {
        char key[10];
        strncpy(key, MT2NumToString(property->pid), sizeof(key));
        json = J_CREATE_S(key, property->value.text ? property->value.text : "");

        if(property->postValue.text != property->value.text)
        {
            property->postValue.text = property->value.text;
        }
    }
    return json;
}

_mtag static json_item_t *buildGWOTAStatusItem(MT2Ctx_t *ctx, MT2GWUpgradeTarget_t target)
{
    json_item_t *otaItem = json_item_create(JSON_ARRAY, T_OTA);
    if(target == MT2_GW_UPGRADE_TARGET_GATEWAY)
    {
        json_array_item_add_subitem(otaItem, J_CREATE_N(MNULL, MT2NumToString(ctx->pri->ota.status)));
        json_array_item_add_subitem(otaItem, J_CREATE_N(MNULL, MT2NumToString(ctx->pri->ota.progress)));

    }
    else
    {
        json_array_item_add_subitem(otaItem, J_CREATE_N(MNULL, MT2NumToString(ctx->pri->gw.ota.status)));
        json_array_item_add_subitem(otaItem, J_CREATE_N(MNULL, MT2NumToString(ctx->pri->gw.ota.progress)));
    }
    return otaItem;
}

//ѯ豸
_mtag void MT2DevPostAll(MT2Ctx_t *ctx, MT2GWSubDevice_t *device,MT2Conn_t *conn, mbool_t isresp, const char *mid, const char *from)
{
    json_item_t *item = isresp ? MT2CtxJHJsonBuild(ctx, T_RESP, mid, from) : MT2CtxJHJsonBuild(ctx, T_POST, MNULL, MNULL);

    json_object_item_add_subitem(item, J_CREATE_S(T_SID, device->deviceId));
    //״̬
    json_item_t *asItem = json_item_create(JSON_OBJECT, T_AS);
    json_object_item_add_subitem(item, asItem);
    DevProperty_t *property;
    MT2ListForeach(&device->propertyList, property)
    {
        json_object_item_add_subitem(asItem, buildPostDevPropertyJson(property));
    }

    //״̬
    json_object_item_add_subitem(item, MT2CtxGWDevFidBuildJsonItem(device));
    //OTA
    if(ctx->pri->gw.ota.type != MT2_OTA_STATUS_IDLE && strcmp(device->deviceId, ctx->pri->gw.ota.deviceId) == 0)
    {
        json_object_item_add_subitem(item, buildGWOTAStatusItem(ctx, MT2_GW_UPGRADE_TARGET_SUBDEVICE));
    }

    if(conn->alloc)
    {
        MT2CtxJHSendJson(ctx, item, conn, mtrue);
    }
    else
    {
        json_item_destroy(item);
    }
}

_mtag static void ctxHandleAndFreeWaitRespDevQuery(MT2Ctx_t *ctx, MT2GWSubDevice_t *device, WaitRespDevQuery_t *wquery)
{
    MT2DevPostAll(ctx, device, wquery->conn, mtrue, wquery->mid, wquery->from);
    MT2ListDel(wquery);
    free(wquery->mid);
    if(wquery->from)
    {
        free(wquery->from);
    }
    free(wquery);
}

_mtag static void ctxAddWaitDevQuery(MT2GWSubDevice_t *device, MT2Conn_t *fromConn, const char *mid, const char *from)
{
    WaitRespDevQuery_t *wquery = malloc(sizeof(WaitRespDevQuery_t));
    memset(wquery, 0, sizeof(WaitRespDevQuery_t));
    if(from)
    {
        wquery->from = malloc(strlen(from) + 1);
        strcpy(wquery->from, from);
    }
    wquery->mid = malloc(strlen(mid) + 1);
    strcpy(wquery->mid, mid);
    wquery->time = MT2Time();
    wquery->conn = fromConn;
    MT2ListAdd(&device->waitRespDevQueryList, wquery);
}

_mtag static void ctxHandleGWDeviceQuery(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json)
{
    const char *mid = json_item_get_string_value(json_item_get_subitem_by_name(json, T_MID));
    json_item_t *fromItem = json_item_get_subitem_by_name(json, T_FROM);
    const char *sid = json_item_get_string_value(json_item_get_subitem_by_name(json, T_SID));
    const char *from = MNULL;
    if(fromItem)
    {
        from = json_item_get_string_value(fromItem);
    }

    MT2GWSubDevice_t *device = MT2CtxGWFindSubDevice(ctx, sid);
    ctxAddWaitDevQuery(device, fromConn, mid, from);

    char *deviceIdArg = malloc(strlen(sid) + 1);
    memset(deviceIdArg, 0, strlen(sid) + 1);
    strcpy(deviceIdArg, sid);
    ctx->pri->eventHandler(ctx, MT2EVENT_GW_DEVICE_QUERY, deviceIdArg);
}

_mtag void MT2CtxDevQueryEnd(MT2Ctx_t *ctx ,const char *deviceId)
{
    MT2GWSubDevice_t *device = MT2CtxGWFindSubDevice(ctx, deviceId);
    if(device)
    {
        WaitRespDevQuery_t *wquery;
        MT2ListForeach(&device->waitRespDevQueryList, wquery)
        {
            ctxHandleAndFreeWaitRespDevQuery(ctx, device, wquery);
        }
    }
}

//豸
_mtag static void ctxHandleAndFreeDevOptInfo(MT2Ctx_t *ctx, MT2GWSubDevice_t *device, DevOptInfo_t *optinfo)
{
    json_item_t *item = MT2CtxJHJsonBuild(ctx, T_POST, optinfo->mid, MNULL);
    json_item_t *asItem = J_CREATE(JSON_OBJECT, T_AS);
    json_object_item_add_subitem(item, J_CREATE_S(T_SID, device->deviceId));
    
    muint8_t i;
    DevProperty_t *property;
    for(i = 0; i < optinfo->propertyNum; i++)
    {
        property = MT2CtxGWFindDevProperty(device, optinfo->property[i].pid);
        json_object_item_add_subitem(asItem, buildPostDevPropertyJson(property));
    }
    json_object_item_add_subitem(item, J_CREATE_S(T_TS, MT2NumToString(device->lastOptTimeStamp)));
    json_object_item_add_subitem(item, asItem);

    MT2CtxGWDelDevOptInfo(optinfo);
    MT2CtxJHSendJson(ctx, item, TO_ALL_CONN, mtrue);
}

_mtag static void ctxHandleGWDeviceOpt(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json)
{
    muint32_t i = 0;
    const char *itemText;
    MT2EventGWOptDeviceArg_t arg = {0};
    json_item_t *asJson = json_item_get_subitem_by_name(json, T_AS);
    const char *mid = json_item_get_string_value(json_item_get_subitem_by_name(json, T_MID));
    const char *sid = json_item_get_string_value(json_item_get_subitem_by_name(json, T_SID));

    MT2GWSubDevice_t *device;
    device = MT2CtxGWFindSubDevice(ctx, sid);
    if(device == MNULL)
    {
        return;
    }
    arg.deviceId = malloc(strlen(sid) + 1);
    memset(arg.deviceId, 0, strlen(sid) + 1);
    strcpy(arg.deviceId, sid);
    mbool_t valueAllSame = mtrue;
    if(asJson)
    {
        arg.propertyNum = json_item_get_subitem_count(asJson);

        arg.propertys = malloc(arg.propertyNum * sizeof(MT2GWProperty_t));
        memset(arg.propertys, 0, arg.propertyNum * sizeof(MT2GWProperty_t));
        for(i = 0; i < arg.propertyNum; i++)
        {
            json_item_t *asItem = json_item_get_subitem_by_index(asJson, i);
            itemText = json_item_get_string_value(asItem);

            arg.propertys[i].pid = MT2StringToNum(asItem->name);

            //δעֱעΪnum
            DevProperty_t *property = MT2CtxGWFindOrRegistDevProperty(device, arg.propertys[i].pid, MT2_PROPERTY_TYPE_NUM);
            arg.propertys[i].type = property->type;

            if(property->type == MT2_PROPERTY_TYPE_NUM)
            {
                arg.propertys[i].value.num = (muint32_t)MT2StringToNum(itemText);
                if(property->value.num != arg.propertys[i].value.num)
                {
                    valueAllSame = mfalse;
                }
            }
            else
            {
                arg.propertys[i].value.text = itemText;
                if(strcmp(property->value.text, arg.propertys[i].value.text) != 0)
                {
                    valueAllSame = mfalse;
                }
            }
        }
    }

    DevOptInfo_t *optinfo = ctxAddDevOptinfo(device, mid, arg.propertyNum, arg.propertys);
    ctx->pri->eventHandler((MT2Ctx_t *)ctx, MT2EVENT_GW_DEVICE_OPT, &arg);

    //ֵδı䣬ֱӷزɹ
    if(valueAllSame)
    {
        mlog("opt, value not change");
        ctxHandleAndFreeDevOptInfo(ctx, device, optinfo);
    }
}
_mtag static mbool_t devPropertyValueChanged(DevProperty_t *property)
{
    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        if(property->value.num != property->postValue.num)
        {
            return mtrue;
        }
    }
    else
    {
        if(property->value.text != property->postValue.text)
        {
            return mtrue;
        }
    }
    return mfalse;
}

_mtag static void ctxGWChekDevPcropertys(MT2Ctx_t *ctx, MT2GWSubDevice_t *device)
{
    //¼
    DevProperty_t *property;
    DevOptInfo_t *optinfoPrev;
    DevOptInfo_t *optinfo;
    muint8_t i;
    mbool_t needResp;
    MT2ListForeach(&device->devOptInfoList, optinfo)
    {
        needResp = mfalse;

        //ʱ
        if(MT2TimeHasPast(optinfo->optTime, 2000))
        {
            needResp = mtrue;
            mlog("opt timeout, mid:%s", optinfo->mid);
        }
        else
        {
            //
            needResp = mtrue;
            for(i = 0; i < optinfo->propertyNum; i++)
            {
                property = MT2CtxGWFindDevProperty(device, optinfo->property[i].pid);
                if(!devPropertyValueChanged(property))
                {
                    needResp = mfalse;
                    break;
                }
            }
        }

        if(needResp)
        {
            optinfoPrev = optinfo->prev;
            ctxHandleAndFreeDevOptInfo(ctx, device, optinfo);
            optinfo = optinfoPrev;
        }
    }

    //ֵͬӺpostԱ㽫仯״̬ͬʱ͵ϣblock״̬ϱʱ䲻500ms
    if(device->propertyBlockForPost)
    {
        if(MT2TimeHasPast(device->propertyLastSyncValueTime, 100)
            || MT2TimeHasPast(device->propertyBlockForPostTime, 500))
        {
            device->propertyBlockForPost = mfalse;
        }
    }
    else
    {
        //postǰȴؽ
        MT2ListForeach(&device->devOptInfoList, optinfo)
        {
            for(i = 0; i < optinfo->propertyNum; i++)
            {
                property = MT2CtxGWFindDevProperty(device, optinfo->property[i].pid);
                
                //Ҫpostʾѷ
                if(devPropertyValueChanged(property))
                {
                    optinfoPrev = optinfo->prev;
                    ctxHandleAndFreeDevOptInfo(ctx, device, optinfo);
                    optinfo = optinfoPrev;
                    break;
                }
            }
        }

        //postֵ֡
        json_item_t *asitem = MNULL;
        json_item_t *pitem;
        MT2ListForeach(&device->propertyList, property)
        {
            if(devPropertyValueChanged(property))
            {
                if(property->type == MT2_PROPERTY_TYPE_NUM)
                {
                    mint64_t diff = property->value.num - property->postValue.num;
                    diff = diff < 0 ? -diff : diff;

                    //Сֵ
                    if(diff < property->threshold
                        && !MT2TimeHasPast(property->setTime, DEV_THRESHOLD_DELAY_TIME))
                    {
                        continue;
                    }
                }

                pitem = buildPostDevPropertyJson(property);
                if(asitem == MNULL)
                {
                    asitem = json_item_create(JSON_OBJECT, T_AS);
                }

                json_object_item_add_subitem(asitem, pitem);
            }
        }

        if(asitem)
        {
            json_item_t *item = json_item_create(JSON_OBJECT, MNULL);
            json_object_item_add_subitem(item, J_CREATE_S(T_CMD, T_POST));
            json_object_item_add_subitem(item, J_CREATE_S(T_SID, device->deviceId));
            json_object_item_add_subitem(item, J_CREATE_S(T_TS, MT2NumToString(device->lastOptTimeStamp)));
            json_object_item_add_subitem(item, asitem);
            MT2CtxJHSendJson(ctx, item, TO_ALL_CONN, mtrue);
        }
    }
}

//豸
_mtag static void ctxHandleGWDeviceUpgrade(MT2Ctx_t *ctx, MT2Conn_t *fromConn, json_item_t *json)
{
    MT2EventGWDeviceUpgradeArg_t arg = {0};
    const char *sid = json_item_get_string_value(json_item_get_subitem_by_name(json, T_SID));
    const char *type = json_item_get_string_value(json_item_get_subitem_by_name(json, T_TYPE));
    const char *version = json_item_get_string_value(json_item_get_subitem_by_name(json, T_VERSION));
    json_item_t *firmware1 = json_item_get_subitem_by_name(json, "firmware1");
    json_item_t *firmware2 = json_item_get_subitem_by_name(json, "firmware2");
    strcpy(arg.addr, sid);

    arg.version = malloc(strlen(version) + 1);
    memset(arg.version, 0, strlen(version) + 1);
    strcpy(arg.version, version);

    if(MT2StringToNum(type) == 0)
    {
        arg.type = MT2_OTA_TYPE_MODULE;
    }
    else
    {
        arg.type = MT2_OTA_TYPE_DEVICE;
    }

    if(firmware1)
    {
        const char *url = json_item_get_string_value(json_item_get_subitem_by_index(firmware1, 0));
        arg.firmware[0].url = malloc(strlen(url) + 1);
        memset(arg.firmware[0].url, 0, strlen(url) + 1);
        strcpy(arg.firmware[0].url, url);

        const char *md5 = json_item_get_string_value(json_item_get_subitem_by_index(firmware1, 1));
        arg.firmware[0].md5 = malloc(strlen(md5) + 1);
        memset(arg.firmware[0].md5, 0, strlen(md5) + 1);
        strcpy(arg.firmware[0].md5, md5);

        const char *versionId = json_item_get_string_value(json_item_get_subitem_by_index(firmware1, 2));
        arg.firmware[0].versionId = malloc(strlen(versionId) + 1);
        memset(arg.firmware[0].versionId, 0, strlen(versionId) + 1);
        strcpy(arg.firmware[0].versionId, versionId);
    }

    if(firmware2)
    {
        const char *url = json_item_get_string_value(json_item_get_subitem_by_index(firmware2, 0));
        arg.firmware[1].url = malloc(strlen(url) + 1);
        memset(arg.firmware[1].url, 0, strlen(url) + 1);
        strcpy(arg.firmware[1].url, url);

        const char *md5 = json_item_get_string_value(json_item_get_subitem_by_index(firmware2, 1));
        arg.firmware[1].md5 = malloc(strlen(md5) + 1);
        memset(arg.firmware[1].md5, 0, strlen(md5) + 1);
        strcpy(arg.firmware[1].md5, md5);

        const char *versionId = json_item_get_string_value(json_item_get_subitem_by_index(firmware2, 2));
        arg.firmware[1].versionId = malloc(strlen(versionId) + 1);
        memset(arg.firmware[1].versionId, 0, strlen(versionId) + 1);
        strcpy(arg.firmware[1].versionId, versionId);
    }

    ctx->pri->eventHandler(ctx, MT2EVENT_GW_DEVICE_UPGRADE, &arg);  
}

_mtag void MT2CtxGWDeviceUpdateOTAStatus(MT2Ctx_t *ctx, MT2OTAType_t type, MT2OTAStatus_t status, muint8_t progress, const muint8_t *newVersion, const char *sid)
{
    MT2OTAType_t oldType = ctx->pri->gw.ota.type;
    MT2OTAStatus_t oldStatus = ctx->pri->gw.ota.status;
    muint8_t oldProgress = ctx->pri->gw.ota.progress;
    mtime_t oldOTAPostTime = ctx->pri->gw.ota.lastOTAPostTime;

    ctx->pri->gw.ota.type = type;
    ctx->pri->gw.ota.status = status;
    ctx->pri->gw.ota.progress = progress;

    if(ctx->pri->gw.ota.deviceId)
    {
        if(strcmp(ctx->pri->gw.ota.deviceId, sid) != 0)
        {
            free(ctx->pri->gw.ota.deviceId);
            ctx->pri->gw.ota.deviceId = malloc(strlen(sid) + 1);
            memset(ctx->pri->gw.ota.deviceId, 0, strlen(sid) + 1);
            strcpy(ctx->pri->gw.ota.deviceId, sid);
        }
    }
    else
    {
        ctx->pri->gw.ota.deviceId = malloc(strlen(sid) + 1);
        memset(ctx->pri->gw.ota.deviceId, 0, strlen(sid) + 1);
        strcpy(ctx->pri->gw.ota.deviceId, sid);
    }

    mtime_t timePass = MT2Time() - ctx->pri->gw.ota.lastOTAPostTime;

    mlog("device %s type:%d status:%d progress:%d tp:%d", sid, type, status, progress, (mint32_t)timePass);

    if(oldType != type
        || oldStatus != status
        || progress == 100
        || timePass > 1000
        || (progress - oldProgress > 5 && timePass > 500))
    {
        if(MT2CtxIsOnline(ctx))
        {
            ctx->pri->gw.ota.lastOTAPostTime = MT2Time();
            json_item_t *item = MT2CtxJHJsonBuild(ctx, T_OTAPOST, MNULL, MNULL);
            json_object_item_add_subitem(item, J_CREATE_S(T_SID, sid));
            json_object_item_add_subitem(item, J_CREATE_N("type", MT2NumToString(ctx->pri->gw.ota.type)));
            json_object_item_add_subitem(item, J_CREATE_N("status", MT2NumToString(ctx->pri->gw.ota.status)));
            json_object_item_add_subitem(item, J_CREATE_N("percent", MT2NumToString(ctx->pri->gw.ota.progress)));

            char ver[16];
            if(newVersion && status == MT2_OTA_STATUS_UPGRAD_SUCCESS)
            {
                sprintf(ver, "%d.%d.%d.%d",
                    newVersion[0], newVersion[1], newVersion[2], newVersion[3]);
                json_object_item_add_subitem(item, J_CREATE_S("version", ver));
            }

            MT2CtxJHSendJson(ctx, item, &ctx->pri->serverConn, mtrue);
        }
    }

    //
    if(status == MT2_OTA_STATUS_UPGRAD_SUCCESS
        || status == MT2_OTA_STATUS_UPGRAD_FAIL)
    {
        if(ctx->pri->gw.ota.deviceId)
        {
            free(ctx->pri->gw.ota.deviceId);
        }
        ctx->pri->gw.ota.status = MT2_OTA_STATUS_IDLE;
        ctx->pri->gw.ota.progress = 0;
    }
}

//ϱ豸(ʽ)
_mtag void MT2CtxGWReportGplot(MT2Ctx_t *ctx, MT2GWGplot_t *gplot)
{
    json_item_t *json = MT2CtxJHJsonBuild(ctx, "SyncGplot", NULL, NULL);
    json_item_t *arrayJson = json_item_create(JSON_ARRAY, "gplot");
    json_object_item_add_subitem(json, arrayJson);

    json_array_item_add_subitem(arrayJson, buildGplotJson(gplot, &gplot->nodes[gplot->root]));
    MT2CtxJHSendJson(ctx, json, TO_ALL_CONN, mtrue);
}

_mtag static json_item_t *buildGplotJson(MT2GWGplot_t *gplot, GplotNode_t *node)
{
    json_item_t *json = MNULL;

    json = json_item_create(JSON_OBJECT, MNULL);
    json_object_item_add_subitem(json, J_CREATE_S("sid", node->data));
    //TODO
    json_object_item_add_subitem(json, J_CREATE_N("rssi", "-128"));
    //

    if(MT2ListFirst(&node->childList))
    {
        json_item_t *subJson = json_item_create(JSON_ARRAY, "sub");
        json_object_item_add_subitem(json, subJson);

        ChildNode_t *child = MNULL;
        MT2ListForeach(&node->childList, child)
        {
            json_item_t *jsonVar = buildGplotJson(gplot, &gplot->nodes[child->childIndex]);
            json_array_item_add_subitem(subJson, jsonVar);
        }
    }
    return json;
}

#endif