#include "MT2CtxConnectionManager.h"
#include "MT2CtxPri.h"
#include "Adapter/MT2Socket.h"

#define LOGIN_TIMEOUT 8000      //½ʱʱ

/*******************************************************************************
* Function Declaration
******************************************************************************/
static void ctxCheckServerConnStatus(MT2Ctx_t *pri);
static void ctxInitConnection(MT2Ctx_t *ctx, MT2Conn_t *conn, MT2Socket_t *socket);

//socket callback
static void udpSocketRecvCallback(MT2Socket_t *sock, const muint8_t *data,
    mint32_t len);
static void tcpSocketRecvCallback(MT2Socket_t *sock, const muint8_t *data,
    mint32_t len);
static void socketListenCallback(MT2Socket_t *sock, MT2Socket_t *newSock);
static void socketConnectCallback(MT2Socket_t *sock, mbool_t success);
static void socketDisconnectCallback(MT2Socket_t *sock);

/*******************************************************************************
* Global Variable
******************************************************************************/
static MT2Socket_t *g_tcpListenSocket;
static MT2Socket_t *g_udpListenSocket;

/*******************************************************************************
 * Function Defination
 ******************************************************************************/

_mtag void MT2CtxConnectionManagerStart(MT2Ctx_t *ctx)
{
    //ʼ
    ctxInitConnection(ctx, &ctx->pri->serverConn, MT2SocketCreate(MT2SOCKET_TYPE_TCP));

    //TCP
    if(g_tcpListenSocket == MNULL)
    {
        g_tcpListenSocket = MT2SocketCreate(MT2SOCKET_TYPE_TCP);
        g_tcpListenSocket->listenCallback = socketListenCallback;
        MT2SocketStartListen(g_tcpListenSocket, 7681);
        g_tcpListenSocket->userdata = ctx;
    }

    //UDP
    if(g_udpListenSocket == MNULL)
    {
        g_udpListenSocket = MT2SocketCreate(MT2SOCKET_TYPE_UDP);
        g_udpListenSocket->userdata = ctx;
        g_udpListenSocket->recvCallback = udpSocketRecvCallback;
        MT2SocketStartListen(g_udpListenSocket, 7680);
    }

    ctx->pri->tcpListenSocket = g_tcpListenSocket;
    ctx->pri->udpSocket = g_udpListenSocket;
}

_mtag void MT2CtxConnectionManagerInit(MT2Ctx_t *ctx)
{
    json_item_regist_value_name(T_CMD);

    //ʼ
    muint8_t i;
    for(i = 0; i < LAN_CONN_NUM; i++)
    {
        ctx->pri->lanConns[i].index = i;
    }
}

_mtag void MT2CtxConnectionManagerPoll(MT2Ctx_t *ctx)
{
    //ӿ
    if(ctx->pri->lastNetifStatus != MT2NetifIsOK())
    {
        ctx->pri->lastNetifStatus = MT2NetifIsOK();

        //Ͽ
        if(!ctx->pri->lastNetifStatus)
        {
            mlog("netif down");
            ctx->pri->serverStatus = MT2_SERVER_STATUS_IDLE;
            muint8_t i;
            for(i = 0; i < LAN_CONN_NUM; i++)
            {
                if(ctx->pri->lanConns[i].alloc)
                {
                    MT2ConnClear(&ctx->pri->lanConns[i]);
                }
            }
        }
    }

    ctxCheckServerConnStatus(ctx);
}

_mtag MT2Conn_t *ctxAllocLanConnection(MT2Ctx_t *ctx)
{
    muint8_t i;
    for(i = 0; i < LAN_CONN_NUM; i++)
    {
        if(!ctx->pri->lanConns[i].alloc)
        {
            return &ctx->pri->lanConns[i];
        }
    }
    return MNULL;
}

_mtag static void initSocket(MT2Socket_t *socket, MT2Conn_t *conn)
{
    socket->userdata = conn;
    socket->connectCallback = socketConnectCallback;
    socket->recvCallback = tcpSocketRecvCallback;
    socket->disconnectCallback = socketDisconnectCallback;
    socket->listenCallback = socketListenCallback;
}

_mtag static void ctxInitConnection(MT2Ctx_t *ctx, MT2Conn_t *conn, MT2Socket_t *socket)
{
    MT2ConnInit(conn);
    conn->socket = socket;
    conn->ctx = ctx;
    conn->alloc = mtrue;

    initSocket(socket, conn);
}

_mtag static void ctxUpdateServerStatus(MT2Ctx_t *ctx, MT2ServerStatus_t status)
{
    if(ctx->pri->serverStatus != status)
    {
        ctx->pri->serverStatus = status;
        ctx->pri->eventHandler(ctx, MT2EVENT_SERVER_STATUS_CHANGE, &status);
    }
    ctx->pri->lastServerStatusTime = MT2Time();
}

static MT2Ctx_t *g_dnsTmpCtx;
_mtag static void dnsResolve(const char *host, const char *ip, mbool_t success)
{
    mlog("dns %s.[%s->%s]", success ? "success" : "fail", host, ip);
    if(success)
    {
        MT2SocketDestroy(g_dnsTmpCtx->pri->serverConn.socket);
        ctxInitConnection(g_dnsTmpCtx, &g_dnsTmpCtx->pri->serverConn, MT2SocketCreate(MT2SOCKET_TYPE_TCP));
        MT2SocketConnect(g_dnsTmpCtx->pri->serverConn.socket, ip, g_dnsTmpCtx->pri->loginServerPort);
    }

    //g_dnsTmpCtx = MNULL;
}

_mtag static void ctxCheckServerConnStatus(MT2Ctx_t *ctx)
{
    switch(ctx->pri->serverStatus)
    {
        //״̬ӷ
    case MT2_SERVER_STATUS_IDLE:
        if(MT2NetifIsOK()
            && (ctx->pri->lastServerStatusTime == 0     //һ
                || MT2TimeHasPast(ctx->pri->lastServerStatusTime, 5000)))   //ϴμ5
        {
            //if(!g_dnsTmpCtx)
            {
                g_dnsTmpCtx = ctx;

                mlog("connect login server");

                ctxUpdateServerStatus(ctx, MT2_SERVER_STATUS_LS_CONNECTING);

                if(ctx->pri->loginServerUseIP)
                {

                    dnsResolve(ctx->pri->loginServerHost, ctx->pri->loginServerHost, mtrue);
                }
                else
                {
                    MT2SocketDnsResolve(ctx->pri->loginServerHost, dnsResolve);
                }
            }
        }
        break;

        //״̬
    case MT2_SERVER_STATUS_ONLINE:
        break;

        //¼
    default:
        //½ʱ
        if(MT2TimeHasPast(ctx->pri->lastServerStatusTime, LOGIN_TIMEOUT))
        {
            mlog("login timeout");
            ctx->pri->serverStatus = MT2_SERVER_STATUS_IDLE;
        }
        break;
    }
}

/*******************************************************************************
* Socket Callback
******************************************************************************/
_mtag static void tcpSocketRecvCallback(MT2Socket_t *sock, const muint8_t *data, mint32_t len)
{
    MT2Conn_t *conn = sock->userdata;
    MT2ConnHandleTCP(conn, data, (muint16_t)len);

#if 0
    mint32_t i = 0;
    mlog("recv");
    for(i = 0; i < len; i++)
    {
        mprintf("%02x ", data[i]);
    }
    mprintf("\n");
#endif
}

_mtag static void udpSocketRecvCallback(MT2Socket_t *sock, const muint8_t *data, mint32_t len)
{
    MT2Ctx_t *ctx = sock->userdata;
    if(ctx->pri->startConnect)
    {
        char *newdata = malloc(len);
        memcpy(newdata, data, len);
        MT2ConnHandleUDP(&ctx->pri->serverConn, (muint8_t *)newdata, (muint16_t)len);
        free(newdata);
    }
}

_mtag static void socketListenCallback(MT2Socket_t *sock, MT2Socket_t *newSock)
{
    MT2Ctx_t *ctx = sock->userdata;

    MT2Conn_t *conn = ctxAllocLanConnection(ctx);
    if(conn == MNULL)
    {
        mlog("lan conn is full");
        MT2SocketDestroy(newSock);
        return;
    }

    mlog("new lan conn:%d", conn->index);

    ctxInitConnection(ctx, conn, newSock);
    MT2ConnLanConnected(conn);
}

_mtag static void socketConnectCallback(MT2Socket_t *sock, mbool_t success)
{
    MT2Conn_t *conn = sock->userdata;
    MT2Ctx_t *ctx = conn->ctx;

    if(ctx->pri->serverStatus == MT2_SERVER_STATUS_LS_CONNECTING)
    {
        if(success)
        {
            mlog("login server connect success");
            ctxUpdateServerStatus(ctx, MT2_SERVER_STATUS_LS_CONNECTED);
            MT2ConnLogin(conn);
        }
        else
        {
            mlog("login server connect fail");
        }
    }
    else if(ctx->pri->serverStatus == MT2_SERVER_STATUS_CS_CONNECTING)
    {
        if(success)
        {
            mlog("conn server connect success");
            ctxUpdateServerStatus(ctx, MT2_SERVER_STATUS_CS_CONNECTED);
            MT2ConnConnect(conn, ctx->pri->connToken);
        }
        else
        {
            mlog("conn server connect fail");
        }
    }
}

_mtag static void socketDisconnectCallback(MT2Socket_t *sock)
{
    MT2Conn_t *conn = sock->userdata;
    MT2Ctx_t *ctx = conn->ctx;
    if(conn == &ctx->pri->serverConn)
    {
        mlog("server disconnect");
        ctx->pri->serverStatus = MT2_SERVER_STATUS_IDLE;
    }
    else
    {
        MT2ConnClear(conn);
        mlog("(%d)lan disconnect", conn->index);
    }
}

_mtag void MT2CtxConnHbTimeout(MT2Ctx_t *ctx, MT2Conn_t *conn)
{
    MT2ConnDisconnect(conn);
    if(conn == &ctx->pri->serverConn)
    {
        mlog("server hb timeout");

        //µ½
        ctx->pri->serverStatus = MT2_SERVER_STATUS_IDLE;
    }
    else
    {
        mlog("(%d)lan hb timeout", conn->index);
        MT2ConnClear(conn);
    }
}

static void updateSourceIP(MT2Ctx_t *ctx);
_mtag void MT2CtxConnOnline(MT2Ctx_t *ctx, MT2Conn_t *conn)
{
    conn->last_hb_recv_time = MT2Time();

    //
    if(conn == &ctx->pri->serverConn)
    {
        ctxUpdateServerStatus(ctx, MT2_SERVER_STATUS_ONLINE);

        //ƽ̨ԴIP
        if(ctx->pri->platformid == 1)
        {
            updateSourceIP(ctx);
        }

#if MT2_OPTION_GATEWAY
#else
        //ϱ״̬
        MT2PostAll(ctx, &ctx->pri->serverConn, mfalse, MNULL, MNULL);
#endif
    }
    //
    else
    {
        mlog("(%d)lan online", conn->index);
    }

#if MT2_OPTION_GATEWAY
    //ϱ豸״̬
    MT2CtxGWReportOnlineStateNotify(ctx);
#endif
}

_mtag void MT2CtxConnRecvHb(MT2Ctx_t *ctx, MT2Conn_t *conn)
{
    if(conn == &ctx->pri->serverConn)
    {
        mlog("server recv hb");
    }
    else
    {
        mlog("(%d)lan recv hb", conn->index);
    }
}

_mtag void MT2CtxUpdateServerTime(MT2Ctx_t *ctx, muint32_t timestamp)
{
    MT2EventUpdaeServerTimeArg_t arg;
    arg.timezone = ctx->pri->timezone;
    arg.seconds = timestamp;
    ctx->pri->eventHandler(ctx, MT2EVENT_UPDATE_SERVER_TIME, &arg);
}

_mtag void MT2CtxLoginSuccess(MT2Ctx_t *ctx, const char *ip, muint16_t port, const muint8_t *token)
{
    mlog("connect conn server(%s:%d)", ip, port);
    ctxUpdateServerStatus(ctx, MT2_SERVER_STATUS_CS_CONNECTING);

    memcpy(ctx->pri->connToken, token, MT2_TOKEN_LEN);

    if(ctx->pri->serverConn.socket->connected)
    {
        MT2SocketDisconnect(ctx->pri->serverConn.socket);
    }
    MT2SocketConnect(ctx->pri->serverConn.socket, ip, port);
}

/*******************************************************************************
 * Update Source IP Only GOME
 ******************************************************************************/
_mtag static void updateSIPDisconnectCb(MT2Socket_t *socket)
{
    MT2SocketDestroy(socket);
}

_mtag static void updateSIPRecvCb(MT2Socket_t *socket, const muint8_t *data, mint32_t len)
{
    char text[300] = {0};
    len = len > sizeof(text) ? sizeof(text) - 1 : len;
    memcpy(text, data, len);
    mlog(text);

    if(data[len] == '\0')
    {
        MT2SocketDestroy(socket);
    }

    mlog("update source ip end");
}

_mtag static void updateSIPConnectCb(MT2Socket_t *socket, mbool_t success)
{
    if(success)
    {
        MT2Ctx_t *ctx = socket->userdata;

        char content[100] = {0};
        strcat(content, "{\"id\":\"");
        strcat(content, ctx->pri->deviceid);
        strcat(content, "\",\"token\":\"");
        strcat(content, ctx->pri->connToken);
        strcat(content, "\"}");

        char text[300] = {0};
        strcat(text, "POST /v2.0/clientIp HTTP/1.1\r\n");
        strcat(text, "Host: ");
        strcat(text, ctx->pri->loginServerHost);
        strcat(text, ":10000\r\n");
        strcat(text, "Connection: Keep-Alive\r\n");
        strcat(text, "Content-Type: application/x-www-form-urlencoded\r\n");
        strcat(text, "Content-Length: ");
        strcat(text, MT2NumToString(strlen(content)));
        strcat(text, "\r\n");
        strcat(text, "\r\n");
        strcat(text, content);

        mlog("update source ip, send\n:%s", text);

        MT2SocketSend(socket, text, strlen(text));
    }
    else
    {
        MT2SocketDestroy(socket);
    }
}

static MT2Ctx_t *g_updateSIPCtx;
_mtag static void updateSIPDnsResolve(const char *host, const char *ip, mbool_t success)
{
    mlog("update source ip, dns %s.[%s->%s]", success ? "success" : "fail", host, ip);
    if(success)
    {
        MT2Socket_t *socket = MT2SocketCreate(MT2SOCKET_TYPE_TCP);
        socket->userdata = g_updateSIPCtx;
        socket->connectCallback = updateSIPConnectCb;
        socket->recvCallback = updateSIPRecvCb;
        socket->disconnectCallback = updateSIPDisconnectCb;
        MT2SocketConnect(socket, ip, 10000);
    }
}

_mtag static void updateSourceIP(MT2Ctx_t *ctx)
{
    mlog("update source ip");

    g_updateSIPCtx = ctx;
    if(ctx->pri->loginServerUseIP)
    {
        updateSIPDnsResolve(ctx->pri->loginServerHost, ctx->pri->loginServerHost, true);
    }
    else
    {
        MT2SocketDnsResolve(ctx->pri->loginServerHost, updateSIPDnsResolve);
    }
}
