#ifndef MT2CTX_H
#define MT2CTX_H
#include "MT2Def.h"

//
MT2Ctx_t *MT2CtxCreate(void);

//
void MT2CtxDestroy(MT2Ctx_t *ctx);

//߼
void MT2CtxHandle(MT2Ctx_t *ctx);

//ƽ̨
void MT2CtxSetPlatformCfg(MT2Ctx_t *ctx, MT2CtxPlatformCfg_t *cfg);

//¼ص
typedef void(*MT2EventHandler_t)(MT2Ctx_t *ctx, muint8_t evt, void *arg);

//¼ص
void MT2CtxSetEventHandler(MT2Ctx_t *ctx, MT2EventHandler_t eventHandler);

//豸ͺ
void MT2CtxSetDeviceModel(MT2Ctx_t *ctx, const char *model);

//ȡ豸ͺ
const char *MT2CtxGetDeviceModel(MT2Ctx_t *ctx);

//豸汾
void MT2CtxSetDeviceVer(MT2Ctx_t *ctx, const muint8_t *ver);

//ȡ豸汾
const muint8_t *MT2CtxGetDeviceVer(MT2Ctx_t *ctx);

//ģͺ
void MT2CtxSetModuleModel(MT2Ctx_t *ctx, const char *model);

//ȡģͺ
const char *MT2CtxGetModuleModel(MT2Ctx_t *ctx);

//ģ汾
void MT2CtxSetModuleVer(MT2Ctx_t *ctx, const muint8_t *ver);

//ȡģ汾
const muint8_t *MT2CtxGetModuleVer(MT2Ctx_t *ctx);

//豸IDPIN
void MT2CtxSetDeviceid(MT2Ctx_t *ctx, const char *deviceid, const char *pin);

//ʼ
void MT2CtxStartConnect(MT2Ctx_t *ctx);

mbool_t MT2CtxHasStartConnect(MT2Ctx_t *ctx);

//ֹͣ
void MT2CtxStopConnect(MT2Ctx_t *ctx);

mbool_t MT2CtxIsOnlineOrHasLanConnection(MT2Ctx_t *ctx);

//û
void MT2CtxUnbindUsers(MT2Ctx_t *ctx);

//
mbool_t MT2CtxIsOnline(MT2Ctx_t *ctx);

//ʼӷ״̬
void MT2CtxStartAddDiscover(MT2Ctx_t *ctx);

//ֹͣӷ
void MT2CtxStopAddDiscover(MT2Ctx_t *ctx);

//豸ID
void MT2CtxApplyDeviceid(MT2Ctx_t *ctx, const char *model, const char *modelpin);

//Ƿͨģ
mbool_t MT2CtxIsNormalModule(MT2Ctx_t *ctx);

/*******************************************************************************
 * 
 ******************************************************************************/
//עֵ
void *MT2CtxRegistProperty(MT2Ctx_t *ctx, muint32_t pid, MT2PropertyType_t type);

//ֵͬ
void MT2CtxSyncPropertyValue(MT2Ctx_t *ctx, muint32_t pid, MT2PropertyValue_t value);

//ȡֵ
MT2PropertyValue_t MT2CtxGetPropertyValue(MT2Ctx_t *ctx, muint32_t pid);

//жǷע
mbool_t MT2CtxPropertyHasRegist(MT2Ctx_t *ctx, muint32_t pid);

//ȡ
MT2PropertyType_t MT2CtxGetPropertyType(MT2Ctx_t *ctx, muint32_t pid);

//ѯ
void MT2CtxQueryEnd(MT2Ctx_t *ctx);

//ϱ״̬
void MT2CtxReportFault(MT2Ctx_t *ctx, const muint8_t *fids, muint8_t count);

/*******************************************************************************
 * 鶯
 ******************************************************************************/

//鶯ID
void MT2CtxSetActionsID(MT2Ctx_t *ctx, mint32_t id);

//鶯״̬
void MT2CtxSetActionsStatus(MT2Ctx_t *ctx, muint8_t status);

//鶯ò
void MT2CtxSetActionsStep(MT2Ctx_t *ctx, muint8_t step);

//鶯ʣʱ
void MT2CtxSetActionsLeftTime(MT2Ctx_t *ctx, mint32_t leftTime);

#endif // !MT2CTX_H
