#include "MT2.h"
#include "MT2CtxPri.h"

#define ACTS_NEED_POST(ctx) ctx->pri->acts.needPost = mtrue;ctx->pri->acts.needPostTime = MT2Time()


/*******************************************************************************
 * Function Declaration
 ******************************************************************************/
static void ctxStopApplyid(MT2Ctx_t *ctx);


static MT2Ctx_t *g_applyidDnsTmpCtx;

/*******************************************************************************
 * Actions
 ******************************************************************************/

_mtag static void sendActsPost(MT2Ctx_t *ctx)
{
    json_item_t *json = MT2CtxJHJsonBuild(ctx, T_ACTSPOST, MNULL, MNULL);
    json_item_add_subitem(json, J_CREATE_S(T_ID, MT2NumToString(ctx->pri->acts.id)));
    json_item_add_subitem(json, J_CREATE_S(T_STATUS, MT2NumToString(ctx->pri->acts.status)));
    json_item_add_subitem(json, J_CREATE_S(T_STEP, MT2NumToString(ctx->pri->acts.step)));
    json_item_add_subitem(json, J_CREATE_S(T_LEFT, MT2NumToString(ctx->pri->acts.leftTime)));
    json_item_add_subitem(json, J_CREATE_S(T_REALSTEP, MT2NumToString(ctx->pri->acts.realStep)));
    MT2CtxJHSendJson(ctx, json, TO_ALL_CONN, mtrue);
}

_mtag void MT2CtxSetActionsID(MT2Ctx_t *ctx, mint32_t id)
{
    if(ctx->pri->acts.id != id)
    {
        ctx->pri->acts.id = id;
        ACTS_NEED_POST(ctx);
    }
}

_mtag void MT2CtxSetActionsStatus(MT2Ctx_t *ctx, muint8_t status)
{
    if(ctx->pri->acts.status != status)
    {
        ctx->pri->acts.status = status;
        ACTS_NEED_POST(ctx);
    }

    if(status == 0)
    {
        ctx->pri->acts.step = 0;
        ctx->pri->acts.realStep = 0;
    }
}

_mtag void MT2CtxSetActionsStep(MT2Ctx_t *ctx, muint8_t step)
{
    if(ctx->pri->acts.step != step)
    {
        ctx->pri->acts.step = step;
        ACTS_NEED_POST(ctx);
    }
}

_mtag void MT2CtxSetActionsLeftTime(MT2Ctx_t *ctx, mint32_t leftTime)
{
    if(ctx->pri->acts.leftTime != leftTime)
    {
        ctx->pri->acts.leftTime = leftTime;
        ACTS_NEED_POST(ctx);
    }
}

/*******************************************************************************
* Apply Deviceid
******************************************************************************/
_mtag static mbool_t applyidRecvData(MT2Ctx_t *ctx, const muint8_t *data, muint16_t len)
{
    MT2PacketBuf_t packbuf;
    packbuf.buf = (muint8_t *)ctx->pri->applyidCtx->buf;
    packbuf.bufcnt = &ctx->pri->applyidCtx->bufCnt;
    packbuf.bufsize = sizeof(ctx->pri->applyidCtx->buf);
    muint16_t i;

    mbool_t recv = mfalse;
    for(i = 0; i < len; i++)
    {
        if(MT2PavketBufRecv(&packbuf, data[i], MNULL))
        {
            recv = mtrue;
            break;
        }
    }

#if 0
    mlog("applyid recv data:");
    for(i = 0; i < len; i++)
    {
        mprintf("%02x ", data[i]);
    }
    mprintf("\n");
#endif

    if(recv)
    {
        mt2_header_t *header = (mt2_header_t *)ctx->pri->applyidCtx->buf;
        mt2_data_header_t *datahdr = DHDR(header);
        muint8_t *opt = OPT(header);
        muint8_t *content = DATA_CONTENT(header);
        mt2_data_part_t *datapart = (mt2_data_part_t *)DATA(header);

        muint8_t check = 0;
        muint16_t dlen;
        memcpy(&dlen, (void *)&datahdr->datalen, 2);
        check += ((muint8_t *)((&dlen)))[0];
        check += ((muint8_t *)((&dlen)))[1];

        if(dlen)
        {
            dlen = MT2AdapterCrypto(mfalse, MT2_AES_KEY_TYPE_APPLYID, ctx->pri->applyidCtx->pin, ctx->pri->applyidCtx->pin + 16, (muint8_t *)datapart, (muint8_t *)datapart, dlen);
        }

        for(i = 0; i < datahdr->optlen; i++)
        {
            check += opt[i];
        }

        for(i = 0; i < dlen; i++)
        {
            check += ((muint8_t *)datapart)[i];
        }

        if(check != datahdr->datacheck)
        {
            mlog("applyid recv, chk fail");
            return mfalse;
        }

        if(header->type == MT2_PACKET_TYPE_LOGIN_RESP)
        {
            muint16_t rnd1;
            muint16_t rnd2;

            memcpy(&rnd1, opt, 2);
            memcpy(&rnd2, content, 2);

            if(rnd1 == rnd2)
            {
                return mtrue;
            }
            else
            {
                mlog("applyid err, code=%d", MT2NToHS(rnd1));
            }
        }
    }

    return mfalse;
}

_mtag static void ctxStopApplyid(MT2Ctx_t *ctx)
{
    g_applyidDnsTmpCtx = MNULL;
    if(ctx->pri->applyidCtx)
    {
        MT2SocketDestroy(ctx->pri->applyidCtx->socket);
        free(ctx->pri->applyidCtx);
        ctx->pri->applyidCtx = MNULL;
    }
}

_mtag static void applyidSocketRecvCallback(MT2Socket_t *sock, const muint8_t *data, mint32_t len)
{
    MT2Ctx_t *ctx = (MT2Ctx_t *)sock->userdata;

    if(applyidRecvData(ctx, data, (muint16_t)len))
    {
        MT2EventApplyidArg_t arg;

        mt2_header_t *header = (mt2_header_t *)ctx->pri->applyidCtx->buf;
        muint8_t *content = DATA_CONTENT(header);

        len = 2;
        muint8_t deviceidlen = content[len++];
        memset(arg.deviceid, 0, sizeof(arg.deviceid));
        memcpy(arg.deviceid, content + len, deviceidlen);
        len += deviceidlen;
        memset(arg.devicepin, 0, sizeof(arg.devicepin));
        memcpy(arg.devicepin, content + len, 32);
        ctx->pri->eventHandler(ctx, MT2EVENT_APPLYID, &arg);
        ctxStopApplyid(ctx);

        mlog("applyid success, id=%s pin=%s", arg.deviceid, arg.devicepin);
    }
}

_mtag static muint16_t packApplyidData(muint8_t *buf, const char *model, const char *modelpin, const char *device_uuid)
{
    muint16_t len = 0;
    muint8_t data[100];

    char trueModel[50];
    strcpy(trueModel, model);
    if(strstr(model, "wechat:"))
    {
        const char *start = model + 7;
        len = (muint8_t)(strstr(start, ",") - start);

        memcpy(trueModel, start, len);
        trueModel[len] = '\0';
    }

    len = 0;
    muint8_t modellen = (muint8_t)strlen(trueModel);              //modellen
    data[len++] = modellen;
    memcpy(data + len, trueModel, modellen);            //model
    len += modellen;

    muint8_t deviceuuidlen = (muint8_t)strlen(device_uuid);   //deviceuuidlen

    data[len++] = deviceuuidlen;
    memcpy(data + len, device_uuid, deviceuuidlen); //deviceuuid
    len += deviceuuidlen;

    muint16_t sn = 0;

    return MT2PackPacket(buf, MT2_AES_KEY_TYPE_APPLYID, MT2_PACKET_TYPE_DEVICE_LICENSE, (muint8_t)strlen(model), (muint8_t *)model, len, data, &sn, modelpin, modelpin + 16);
}

_mtag static void applyidSocketConnectCallback(MT2Socket_t *sock, mbool_t success)
{
    MT2Ctx_t *ctx = sock->userdata;

    mlog("applyid connect %s", success ? "success" : "fail");

    if(success)
    {
        char uuid[33];
        muint8_t buf[256];

        muint16_t len = packApplyidData(buf, ctx->pri->applyidCtx->model, ctx->pri->applyidCtx->pin, MT2GetDeviceUUID(uuid));
        MT2SocketSend(sock, buf, len);
    }
    else
    {
        ctxStopApplyid(ctx);
    }
}

_mtag static void applyDeviceidDnsResolve(const char *host, const char *ip, mbool_t success)
{
    if(g_applyidDnsTmpCtx)
    {
        mlog("dns %s.[%s->%s]", success ? "success" : "fail", host, ip);
        if(success)
        {
            MT2SocketConnect(g_applyidDnsTmpCtx->pri->applyidCtx->socket, ip, g_applyidDnsTmpCtx->pri->applyidServerPort);
        }
        else
        {
            ctxStopApplyid(g_applyidDnsTmpCtx);
        }

        g_applyidDnsTmpCtx = MNULL;
    }
}

_mtag void MT2CtxApplyDeviceid(MT2Ctx_t *ctx, const char *model, const char *modelpin)
{
    if(!ctx->pri->applyidCtx)
    {
        ctx->pri->applyidCtx = malloc(sizeof(ApplyidCtx_t));
        memset(ctx->pri->applyidCtx, 0, sizeof(ApplyidCtx_t));
        strcpy(ctx->pri->applyidCtx->pin, modelpin);
        strcpy(ctx->pri->applyidCtx->model, model);

        ctx->pri->applyidCtx->startTime = MT2Time();
        ctx->pri->applyidCtx->socket = MT2SocketCreate(MT2SOCKET_TYPE_TCP);
        ctx->pri->applyidCtx->socket->connectCallback = applyidSocketConnectCallback;
        ctx->pri->applyidCtx->socket->recvCallback = applyidSocketRecvCallback;
        ctx->pri->applyidCtx->socket->userdata = ctx;

        //if(!g_applyidDnsTmpCtx)
        {
            g_applyidDnsTmpCtx = ctx;
            if(ctx->pri->applyidServerUseIP)
            {
                applyDeviceidDnsResolve(ctx->pri->applyidServerHost, ctx->pri->applyidServerHost, mtrue);
            }
            else
            {
                MT2SocketDnsResolve(ctx->pri->applyidServerHost, applyDeviceidDnsResolve);
            }
        }
    }
}

/*******************************************************************************
 * Ctx About
 ******************************************************************************/
_mtag void MT2CtxHandle(MT2Ctx_t *ctx)
{
    HTTPRequestPoll();

    MT2CtxPrivatePoll(ctx);

    //Ҫ
    if(ctx->pri->needUnbind)
    {
        if(MT2CtxIsOnline(ctx))
        {
            if(MT2TimeHasPast(ctx->pri->lastUnbindTime, 5000))
            {
                ctx->pri->lastUnbindTime = MT2Time();
                ctx->pri->unbindCount++;
                mt2conn_unbind(&ctx->pri->serverConn);

                //3νΪɹ쳣޷
                if(ctx->pri->unbindCount > 3)
                {
                    MT2CtxUnbindSuccess(ctx);
                }
            }
        }
    }

    //post鶯
    if(ctx->pri->acts.needPost && MT2TimeHasPast(ctx->pri->acts.needPostTime, 100))
    {
        ctx->pri->acts.needPost = mfalse;
        sendActsPost(ctx);
    }

    //ʱ˳豸ID
    if(ctx->pri->applyidCtx && MT2TimeHasPast(ctx->pri->applyidCtx->startTime, 10000))
    {
        ctxStopApplyid(ctx);
    }

    //δ
    if(!ctx->pri->startConnect)
    {
        return;
    }

    MT2CtxConnectionManagerPoll(ctx);
    MT2CtxJsonHandlerPoll(ctx);
    MT2CtxBinaryHandlerPoll(ctx);

    //ʱ˳ӷ
    if(ctx->pri->startAddDiscover && MT2TimeHasPast(ctx->pri->startAddDiscoverTime, 60000))
    {
        MT2CtxStopAddDiscover(ctx);
    }

    MT2ConnHandle(&ctx->pri->serverConn);

    muint8_t i;
    for(i = 0; i < LAN_CONN_NUM; i++)
    {
        MT2ConnHandle(&ctx->pri->lanConns[i]);
    }
}

_mtag static char *parseHost(bool *useIP, const char *host)
{
    char *res = malloc(strlen(host) + 1);
    if(strstr(host, "IP:"))
    {
        *useIP = true;
        host += 3;
    }
    else
    {
        *useIP = false;
    }
    strcpy(res, host);
    return res;
}

_mtag void MT2CtxSetPlatformCfg(MT2Ctx_t *ctx, MT2CtxPlatformCfg_t *cfg)
{
    if(ctx->pri->loginServerHost)
    {
        free(ctx->pri->loginServerHost);
    }

    if(ctx->pri->applyidServerHost)
    {
        free(ctx->pri->applyidServerHost);
    }

    ctx->pri->loginServerHost = parseHost(&ctx->pri->loginServerUseIP, cfg->loginServerHost);
    ctx->pri->loginServerPort = cfg->loginServerPort;
    ctx->pri->applyidServerHost = parseHost(&ctx->pri->applyidServerUseIP, cfg->applyidServerHost);
    ctx->pri->applyidServerPort = cfg->applyidServerPort;
    ctx->pri->platformid = cfg->platformid;

    mlog("set platform cfg ls=%s:%d ds=%s:%d",
        ctx->pri->loginServerHost, ctx->pri->loginServerPort,
        ctx->pri->applyidServerHost, ctx->pri->applyidServerPort);
}

_mtag MT2Ctx_t *MT2CtxCreate(void)
{
    MT2Ctx_t *ctx = malloc(sizeof(MT2Ctx_t));
    ctx->pri = malloc(sizeof(MT2CtxPri_t));
    memset(ctx->pri, 0, sizeof(MT2CtxPri_t));

    MT2CtxPrivateInit(ctx);
    MT2CtxConnectionManagerInit(ctx);
    MT2CtxBinaryHandlerInit(ctx);
    MT2CtxJsonHandlerInit(ctx);

    strcpy(ctx->pri->moduleModel, "def");

    return ctx;
}

_mtag void MT2CtxDestroy(MT2Ctx_t *ctx)
{
    free(ctx->pri);
    free(ctx);
}

_mtag void MT2CtxSetEventHandler(MT2Ctx_t *ctx, MT2EventHandler_t eventHandler)
{
    ctx->pri->eventHandler = eventHandler;
}

_mtag void MT2CtxSetDeviceid(MT2Ctx_t *ctx, const char *deviceid, const char *pin)
{
    mlog("set deviceid=%s", deviceid);
    strncpy(ctx->pri->deviceid, deviceid, sizeof(ctx->pri->deviceid));
    strncpy(ctx->pri->devicepin, pin, sizeof(ctx->pri->devicepin));
}

_mtag void MT2CtxSetDeviceModel(MT2Ctx_t *ctx, const char *model)
{
    strncpy(ctx->pri->deviceModel, model, sizeof(ctx->pri->deviceModel));
}

_mtag const char *MT2CtxGetDeviceModel(MT2Ctx_t *ctx)
{
    return ctx->pri->deviceModel;
}

_mtag const char *MT2CtxGetModuleModel(MT2Ctx_t *ctx)
{
    return ctx->pri->moduleModel;
}

_mtag void MT2CtxSetDeviceVer(MT2Ctx_t *ctx, const muint8_t *ver)
{
    memcpy(ctx->pri->deviceVer, ver, MT2_VERSION_LEN);
}

_mtag const muint8_t *MT2CtxGetDeviceVer(MT2Ctx_t *ctx)
{
    return ctx->pri->deviceVer;
}

_mtag const muint8_t *MT2CtxGetModuleVer(MT2Ctx_t *ctx)
{
    return ctx->pri->moduleVer;
}

_mtag void MT2CtxSetModuleModel(MT2Ctx_t *ctx, const char *model)
{
    strncpy(ctx->pri->moduleModel, model, sizeof(ctx->pri->moduleModel));
    ctx->pri->isNormalModule = mtrue;
}

_mtag void MT2CtxSetModuleVer(MT2Ctx_t *ctx, const muint8_t *ver)
{
    memcpy(ctx->pri->moduleVer, ver, MT2_VERSION_LEN);
}

_mtag void MT2CtxStartConnect(MT2Ctx_t *ctx)
{
    if(!ctx->pri->startConnect)
    {
        ctx->pri->startConnect = mtrue;
        MT2CtxConnectionManagerStart(ctx);
    }
}

_mtag mbool_t MT2CtxHasStartConnect(MT2Ctx_t *ctx)
{
    return ctx->pri->startConnect;
}

_mtag void MT2CtxStopConnect(MT2Ctx_t *ctx)
{
    ctx->pri->startConnect = mfalse;
}

_mtag mbool_t MT2CtxIsOnlineOrHasLanConnection(MT2Ctx_t *ctx)
{
    if(MT2CtxIsOnline(ctx))
    {
        return mtrue;
    }

    muint8_t i;
    for(i = 0; i < LAN_CONN_NUM; i++)
    {
        if(ctx->pri->lanConns[i].alloc)
        {
            if(MT2LanConnectionIsValid(&ctx->pri->lanConns[i]))
            {
                return mtrue;
            }
        }
    }

    return mfalse;
}

_mtag void MT2CtxUnbindUsers(MT2Ctx_t *ctx)
{
    ctx->pri->needUnbind = mtrue;
    ctx->pri->lastUnbindTime = MT2Time() - 60000; //
}

_mtag mbool_t MT2CtxIsOnline(MT2Ctx_t *ctx)
{
    return ctx->pri->serverStatus == MT2_SERVER_STATUS_ONLINE;
}

_mtag Property_t *MT2CtxFindOrRegistProperty(MT2Ctx_t *ctx, muint32_t pid, MT2PropertyType_t type)
{
    Property_t *property = MT2CtxFindProperty(ctx, pid);
    if(property == MNULL)
    {
        property = MT2CtxRegistProperty(ctx, pid, type);
    }
    return property;
}

//ֵͬ
_mtag void MT2CtxSyncPropertyValue(MT2Ctx_t *ctx, muint32_t pid, MT2PropertyValue_t value)
{
    //δעĬעΪֵ
    Property_t *property = MT2CtxFindOrRegistProperty(ctx, pid, MT2_PROPERTY_TYPE_NUM);
    bool changed = false;

    if(property->type == MT2_PROPERTY_TYPE_NUM)
    {
        if(property->value.num != value.num)
        {
            changed = true;
            property->value.num = value.num;

            mlog("sync property, id=%d value=%d", pid, value.num);
        }
    }
    else
    {
        if(property->value.text == MNULL || strcmp(property->value.text, value.text) != 0)
        {
            changed = true;

            char *needFree = property->value.text;

            property->value.text = malloc(strlen(value.text) + 1);
            strcpy(property->value.text, value.text);
            property->postValue.text = MNULL;

            //Ӻfreemalloc䵽ͬڴΪж״̬仯ͨȽڴַжϵ
            if(needFree)
            {
                free(needFree);
            }

            mlog("sync property, id=%d value=", pid);
            muint16_t valuelen = (muint16_t)strlen(value.text);
            muint16_t i;
            for(i = 0; i < valuelen; i++)
            {
                mprintf("%c", value.text[i]);
            }
            mprintf("\n");
        }
    }

    if(changed)
    {
        property->setTime = MT2Time();
        ctx->pri->propertyLastSyncValueTime = MT2Time();
        if(!ctx->pri->propertyBlockForPost)
        {
            ctx->pri->propertyBlockForPost = mtrue;
            ctx->pri->propertyBlockForPostTime = MT2Time();
        }
    }
}

_mtag MT2PropertyValue_t MT2CtxGetPropertyValue(MT2Ctx_t *ctx, muint32_t pid)
{
    Property_t *property = MT2CtxFindProperty(ctx, pid);
    if(property)
    {
        return property->value;
    }
    MT2PropertyValue_t value;
    value.num = 0;
    return value;
}

_mtag mbool_t MT2CtxPropertyHasRegist(MT2Ctx_t *ctx, muint32_t pid)
{
    Property_t *property = MT2CtxFindProperty(ctx, pid);
    return property != MNULL;
}

_mtag MT2PropertyType_t MT2CtxGetPropertyType(MT2Ctx_t *ctx, muint32_t pid)
{
    Property_t *property = MT2CtxFindProperty(ctx, pid);
    if(property)
    {
        return property->type;
    }
    return MT2_PROPERTY_TYPE_NUM;
}

_mtag void MT2CtxReportFault(MT2Ctx_t *ctx, const muint8_t *fids, muint8_t count)
{
    mlog("report fault:");
    muint16_t i;
    for(i = 0; i < count; i++)
    {
        mprintf("%d ", fids[i]);
    }
    mprintf("\n");

    //¹״̬
    muint64_t tmpMap[4];
    memcpy(&tmpMap, ctx->pri->fid.map, sizeof(ctx->pri->fid.map));
    memset(ctx->pri->fid.map, 0, sizeof(ctx->pri->fid.map));
    for(i = 0; i < count; i++)
    {
        MT2CtxFidSetBit(ctx, fids[i], mtrue);
    }

    //״̬һ£ϱ
    if(memcmp(ctx->pri->fid.map, tmpMap, sizeof(ctx->pri->fid.map)) != 0)
    {
        if(MT2CtxIsOnlineOrHasLanConnection(ctx))
        {
            json_item_t *item = MT2CtxJHJsonBuild(ctx, T_FAULT, MNULL, MNULL);
            json_object_item_add_subitem(item, MT2CtxFidBuildJsonItem(ctx));
            MT2CtxJHSendJson(ctx, item, TO_ALL_CONN, mtrue);
        }
    }
}

_mtag void MT2CtxStartAddDiscover(MT2Ctx_t *ctx)
{
    mlog("start add discover");
    ctx->pri->startAddDiscover = mtrue;
    ctx->pri->startAddDiscoverTime = MT2Time();
}

_mtag void MT2CtxStopAddDiscover(MT2Ctx_t *ctx)
{
    mlog("stop add discover");
    ctx->pri->startAddDiscover = mfalse;
}

//ǷΪģ
_mtag mbool_t MT2CtxIsNormalModule(MT2Ctx_t *ctx)
{
    return ctx->pri->isNormalModule;
}
