#ifndef MT2CONN_H
#define MT2CONN_H
#include "MT2Def.h"
#include "Adapter/MT2Socket.h"

#define MT2_MD5_LEN 16
#define MT2_MODEL_LEN 12

#define MT2_VER_FMT "%d.%d.%d.%d"
#define MT2_VER(ver) ver[0],ver[1],ver[2],ver[3]



#ifdef __WIN__
#pragma pack(push, 1)
#endif

typedef enum
{
    MT2_PACKET_TYPE_HB = 1,                 //
    MT2_PACKET_TYPE_HB_RESP = 2,            //Ӧ
    MT2_PACKET_TYPE_KICKOFF = 3,            //޳½
    MT2_PACKET_TYPE_DEVICE_LICENSE = 7,     //豸Ȩ
    MT2_PACKET_TYPE_LAN_DISCOVER = 6,       //豸
    MT2_PACKET_TYPE_LAN_AUTH = 8,           //֤
    MT2_PACKET_TYPE_LOGIN = 9,              //½
    MT2_PACKET_TYPE_CONNECT = 10,           //
    MT2_PACKET_TYPE_LOGIN_RESP = 11,        //ֻظ
    MT2_PACKET_TYPE_UNBIND = 12,            //
    MT2_PACKET_TYPE_UPGRADE_NOTIFY = 13,    //֪ͨ
    MT2_PACKET_TYPE_UPGRADE_PROGRESS = 16,  //
    MT2_PACKET_TYPE_JSON_DATA = 17,         //ҵ
    MT2_PACKET_TYPE_QUIT_ADD = 20,          //˳
}mt2_packet_type_t;

typedef struct
{
    muint16_t magic;
    muint8_t type : 5;
    muint8_t ack : 1;
    muint8_t reserved : 2;
}__mpacked mt2_header_t;

typedef struct
{
    muint8_t optlen;
    muint8_t datacheck;
    muint16_t datalen;
}__mpacked mt2_data_header_t;

typedef struct
{
    muint16_t sn;
}__mpacked mt2_data_part_t;


typedef struct
{
    muint8_t rnd[2];
    muint8_t token[MT2_TOKEN_LEN];
    muint8_t ip[4];
    muint8_t port[2];
}__mpacked mt2_login_resp_data_t;



typedef struct
{
    muint8_t rnd[2];
    muint8_t hb[2];
    mint8_t timezone;
    muint8_t timestamp[4];
}__mpacked MT2CONNect_resp_data_t;

#ifdef __WIN__
#pragma pack(pop)
#endif


#define MAGIC0 0xaa
#define MAGIC1 0xbb
#define MAGIC ((((muint16_t)MAGIC0 << 8) | MAGIC1))

#define DHDR(hdr) ((mt2_data_header_t *)(((mt2_header_t *)(hdr)) + 1))
#define OPT(hdr) ((muint8_t *)(DHDR(hdr) + 1))
#define DATA(hdr) (OPT(hdr) + DHDR(hdr)->optlen) 
#define DATA_CONTENT(hdr) (OPT(hdr) + DHDR(hdr)->optlen + sizeof(mt2_data_part_t)) 


#define ALL_HEADER_LEN (sizeof(mt2_header_t) + sizeof(mt2_data_header_t))

typedef struct
{
    muint16_t *bufcnt;
    muint8_t *buf;
    muint16_t bufsize;
}MT2PacketBuf_t;

struct MT2Conn_st;
typedef struct MT2Conn_st MT2Conn_t;

//
void MT2ConnInit(MT2Conn_t *conn);

//ͷ
void MT2ConnClear(MT2Conn_t *conn);

void MT2ConnHandle(MT2Conn_t *conn);

typedef struct
{
    muint8_t modellen;
    char model[20];
    muint32_t timestamp;
}mt2conn_lan_discover_event_arg_t;

typedef struct
{
    mbool_t success;
    muint8_t ip[4];
    muint16_t port;
    char token[MT2_TOKEN_LEN];
}mt2conn_login_result_event_arg_t;

typedef struct
{
    mint8_t timezone;
    muint32_t server_time;
}mt2conn_update_server_time_event_arg_t;

//״̬
typedef enum
{
    MT2CONN_STATUS_IDLE,
    MT2CONN_STATUS_LOGINING,
    MT2CONN_STATUS_CONNECTING,
    MT2CONN_STATUS_ONLINE,
}mt2conn_status_t;

//Ӷ
struct MT2Conn_st
{
    mt2conn_status_t status;                        //״̬
    mtime_t last_hb_recv_time;                      //һʱ
    mtime_t last_hb_send_time;                      //һʱ
    mbool_t is_lan;                                 //ӱʶ
    muint32_t hb_span_ms;                           //ͼ

    //
    muint16_t recv_bufsize;
    muint16_t recv_count;
    muint8_t recv_headerbuf[7];
    muint8_t *recvbuf;

    muint16_t send_sn;                               //
    muint16_t recv_sn;                               //

    //
    mbool_t alloc : 1;
    muint8_t index : 3;
    MT2Socket_t *socket;

    MT2Ctx_t *ctx;
};

//TCP
void MT2ConnHandleTCP(MT2Conn_t *conn, const muint8_t *data, muint16_t len);

//UDP
void MT2ConnHandleUDP(MT2Conn_t *conn, const muint8_t *data, muint16_t len);

//ӽ
void MT2ConnLanConnected(MT2Conn_t *conn);

//ӶϿ
void MT2ConnDisconnect(MT2Conn_t *conn);

//ظ
void MT2ConnRespLanDiscover(MT2Conn_t *conn, const char *model, muint32_t timestamp, mbool_t incfg);

//ƶ˽
void mt2conn_unbind(MT2Conn_t *conn);

//½
void MT2ConnLogin(MT2Conn_t *conn);

//
void MT2ConnConnect(MT2Conn_t *conn, const char *token);

//json
void MT2ConnSendJsonData(MT2Conn_t *conn, const char *json_text);

mbool_t MT2PavketBufRecv(MT2PacketBuf_t *buf, muint8_t byte, MT2Conn_t *conn);

muint16_t MT2PackPacket(muint8_t *buf, MT2AesKeyType_t keytype, mt2_packet_type_t type, muint8_t optlen, const muint8_t *opt, muint16_t datalen, const muint8_t *data, muint16_t *sn, const char *key, const char *iv);

#endif // !MT2CONN_H
