#include "MT2Conn.h"
#include "MT2CtxPri.h"

static void connSendPacket(MT2Conn_t *conn, mbool_t istcp, mt2_packet_type_t type, muint8_t optlen, const muint8_t *opt, muint16_t datalen, const muint8_t *data);

_mtag static muint16_t getDatalen(mt2_data_header_t *dhdr)
{
    muint16_t len;
    memcpy(&len, (void *)&dhdr->datalen, 2);
    return len;
}

_mtag static MT2AesKeyType_t getConnKey(MT2Conn_t *conn, char **key, char **iv)
{
    MT2AesKeyType_t keytype;
    if(conn->is_lan)
    {
        keytype = MT2_AES_KEY_TYPE_LAN;
        *key = conn->ctx->pri->devicepin + 16;
        *iv = conn->ctx->pri->devicepin + 16;
    }
    else
    {
        keytype = MT2_AES_KEY_TYPE_WAN;
        *key = conn->ctx->pri->devicepin;
        *iv = conn->ctx->pri->devicepin + 16;
    }
    return keytype;
}

_mtag void MT2ConnInit(MT2Conn_t *conn)
{
    conn->recv_bufsize = 0;
    conn->recv_count = 0;
    conn->last_hb_send_time = 0;
}

_mtag void MT2ConnClear(MT2Conn_t *conn)
{
    if(conn->recvbuf)
    {
        free(conn->recvbuf);
    }
    conn->recvbuf = MNULL;
    conn->alloc = mfalse;

    if(conn->socket)
    {
        MT2SocketDestroy(conn->socket);
        conn->socket = MNULL;
    }
}

_mtag static void connNew(MT2Conn_t *conn)
{
    conn->recv_sn = 0;
    conn->send_sn = MT2Time() & 0xffff;        //ʼsn
    conn->recv_count = 0;
}

_mtag static void connHandleLoginResp(MT2Conn_t *conn, mt2_header_t *header)
{
    muint8_t *opt = OPT(header);
    mt2_data_header_t *dhdr = DHDR(header);
    mt2_data_part_t *datapart = (mt2_data_part_t *)DATA(header);

    muint16_t code;
    mbool_t error = mfalse;

    ////0ֻа ش
    if(getDatalen(dhdr) <= sizeof(mt2_data_part_t)) //0ֻа
    {
        error = mtrue;
        memcpy(&code, opt, sizeof(code));
        code = MT2NToHS(code);
        mlog("%s err, code=%d", conn->status == MT2CONN_STATUS_LOGINING ? "login" : "connect", code);

        //½ʧΪɹ
        if(conn->ctx->pri->needUnbind)
        {
            MT2CtxUnbindSuccess(conn->ctx);
        }
    }

    //½ظ
    if(conn->status == MT2CONN_STATUS_LOGINING)
    {
        if(error)
        {
            return;
        }

        mt2_login_resp_data_t *resp = (mt2_login_resp_data_t *)(datapart + 1);

        char ip[20];
        char token[MT2_TOKEN_LEN + 1] = {0};
        muint16_t port;
        muint16_t optrnd;
        memcpy(&optrnd, opt, sizeof(optrnd));

        muint16_t datarnd;
        memcpy(&datarnd, resp->rnd, 2);

        if(optrnd != datarnd)
        {
            mlog("rnd not equal %d != %d", optrnd, datarnd);
            return;
        }

        memcpy(token, resp->token, MT2_TOKEN_LEN);

        ip[0] = '\0';
        strcat(ip, MT2NumToString(resp->ip[0]));
        strcat(ip, ".");
        strcat(ip, MT2NumToString(resp->ip[1]));
        strcat(ip, ".");
        strcat(ip, MT2NumToString(resp->ip[2]));
        strcat(ip, ".");
        strcat(ip, MT2NumToString(resp->ip[3]));
        memcpy(&port, resp->port, 2);
        port = MT2NToHS(port);

        mlog("login success, ip:%s port:%d token:%s", ip, port, token);

        MT2CtxLoginSuccess(conn->ctx, ip, port, (muint8_t *)token);
    }
    //ӻظ
    else
    {
        //ش
        if(error)
        {
            return;
        }

        MT2CONNect_resp_data_t *resp = (MT2CONNect_resp_data_t *)DATA_CONTENT(header);

        muint16_t optrnd;
        memcpy(&optrnd, OPT(header), sizeof(optrnd));

        muint16_t datarnd;
        memcpy(&datarnd, resp->rnd, 2);

        if(optrnd != datarnd)
        {
            mlog("connect fail, optrnd(%d) != datarnd(%d)", optrnd, datarnd);
            return;
        }

        muint16_t hb;
        memcpy(&hb, resp->hb, 2);
        hb = MT2NToHS(hb);

        muint32_t timestamp;
        memcpy(&timestamp, resp->timestamp, 4);
        timestamp = MT2NToHL(timestamp);

        mlog("connect success, hb:%d timezone:%d timestamp:%d", hb, resp->timezone, timestamp);

        conn->hb_span_ms = hb * 1000;

        //min hb span
        if(conn->hb_span_ms < 5000)
        {
            conn->hb_span_ms = 5000;
        }

        //½ɹ
        
        conn->status = MT2CONN_STATUS_ONLINE;
        MT2CtxConnOnline(conn->ctx, conn);
        conn->ctx->pri->timezone = resp->timezone;
        MT2CtxUpdateServerTime(conn->ctx, timestamp);
    }
}

_mtag static void connHandleHeartbeatResp(MT2Conn_t *conn, mt2_header_t *header)
{
    muint32_t timestamp;
    memcpy(&timestamp, OPT(header), sizeof(timestamp));
    timestamp = MT2NToHL(timestamp);
    MT2CtxUpdateServerTime(conn->ctx, timestamp);
}

_mtag static void connHandleLanDiscover(MT2Conn_t *conn, mt2_header_t *hdr)
{
    //ʼӺӦ豸
    if(conn->ctx->pri->startConnect)
    {
        char model[20] = {0};
        muint8_t modellen;
        muint32_t timestamp;

        mt2_data_header_t *dhdr = DHDR(hdr);
        mint16_t optlen = dhdr->optlen;
        muint8_t *opt = OPT(hdr);

        modellen = opt[0];
        if(modellen >= sizeof(model))
        {
            modellen = 0;
        }
        optlen--;
        memcpy(model, opt + 1, modellen);
        optlen -= modellen;
        memcpy(&timestamp, opt + opt[0] + 1, 4);
        timestamp = MT2NToHL(timestamp);
        optlen -= 4;

        muint16_t platform = 0;
        if(optlen > 0)
        {
            memcpy(&platform, opt + opt[0] + 1 + 4, 2);
            platform = MT2NToHS(platform);

            //TODO compare platformid
        }

        
        if(conn->ctx->pri->startAddDiscover)
        {
            conn->ctx->pri->eventHandler(conn->ctx, MT2EVENT_RESP_ADD_DISCOVER, NULL);
        }

        mlog("lan discover, add:%d, timestamp:%d", conn->ctx->pri->startAddDiscover, timestamp);

        //APPпܽղظ10
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
        MT2ConnRespLanDiscover(conn, conn->ctx->pri->deviceModel, timestamp, conn->ctx->pri->startAddDiscover);
    }
}



_mtag static void connHandleLanAuth(MT2Conn_t *conn, mt2_header_t *header)
{
    muint8_t *opt = OPT(header);
    muint8_t *content = DATA_CONTENT(header);

    muint16_t optrnd;
    memcpy(&optrnd, opt, sizeof(optrnd));

    muint16_t datarnd;
    memcpy(&datarnd, content, sizeof(datarnd));

    muint16_t code = 0;

    if(optrnd != datarnd)
    {
        mlog("lan auth fail");
        code = 1;
    }
    else
    {
        code = 0;
        muint16_t hb;
        memcpy(&hb, content + 2, sizeof(hb));
        hb = MT2NToHS(hb);

        conn->hb_span_ms = hb * 1000; //10

        //1
        if(conn->hb_span_ms > 60000)
        {
            conn->hb_span_ms = 60000;
        }

        mlog("hb time:%d", conn->hb_span_ms);
        conn->status = MT2CONN_STATUS_ONLINE;

        MT2CtxConnOnline(conn->ctx, conn);
    }

    //ͻظ
    connSendPacket(conn, mtrue, MT2_PACKET_TYPE_LOGIN_RESP, 2, (muint8_t *)&code, 0, MNULL);
}

_mtag static void connHandleUpgradeNotify(MT2Conn_t *conn, mt2_header_t *header)
{
    muint8_t *content = DATA_CONTENT(header);
    MT2EventUpgradeArg_t arg;

    muint16_t len = 0;
    arg.type = content[len++];                                      //type
    arg.version = content + len;                                    //version
    len += 4;

    memcpy(&arg.firmware[0].urllen, content + len, 2);              //urllen
    arg.firmware[0].urllen = MT2NToHS(arg.firmware[0].urllen);
    len += 2;
    arg.firmware[0].url = content + len;                            //url
    len += arg.firmware[0].urllen;
    len += 32;                                                      //versionid
    arg.firmware[0].md5 = content + len;                            //md5
    len += 32;

    memcpy(&arg.firmware[1].urllen, content + len, 2);              //urllen
    arg.firmware[1].urllen = MT2NToHS(arg.firmware[1].urllen);
    len += 2;
    arg.firmware[1].url = content + len;                            //url
    len += arg.firmware[1].urllen;
    len += 32;                                                      //versionid
    arg.firmware[1].md5 = content + len;                            //md5
    len += 32;

    conn->ctx->pri->eventHandler(conn->ctx, MT2EVENT_UPGRADE, &arg);
}

_mtag static void connHandleUnbindResp(MT2Conn_t *conn, mt2_header_t *header)
{
    muint8_t *content = DATA_CONTENT(header);
    muint16_t code;
    memcpy(&code, content, sizeof(code));
    code = MT2NToHS(code);

    mlog("unbind resp, code=%d", code);
    MT2CtxUnbindSuccess(conn->ctx);
}

_mtag static void connHandlePacket(MT2Conn_t *conn, mt2_header_t *header)
{
    char buf[50];
    mt2_packet_type_t type = header->type;

    mt2_data_header_t *datahdr = DHDR(header);
    muint8_t *opt = OPT(header);
    muint8_t *data = DATA(header);
    mt2_data_part_t *datapart = (mt2_data_part_t *)data;

    //ڼȨ֮ǰϢ
    if(conn->is_lan && conn->status != MT2CONN_STATUS_ONLINE && header->type != MT2_PACKET_TYPE_LAN_AUTH)
    {
        return;
    }

    //У
    muint8_t check = 0;
    uint16_t dlen = getDatalen(datahdr);
    check += ((muint8_t *)((&dlen)))[0];
    check += ((muint8_t *)((&dlen)))[1];

    if(getDatalen(datahdr))
    {
        char *key = NULL;
        char *iv = NULL;
        MT2AesKeyType_t keytype = getConnKey(conn, &key, &iv);

        datahdr->datalen = MT2AdapterCrypto(mfalse, keytype, key, iv, (muint8_t *)datapart, (muint8_t *)datapart, getDatalen(datahdr));

        //Ƚ
        muint16_t dsn;
        memcpy(&dsn, (void *)&datapart->sn, 2);
        muint16_t sn = MT2HToNS(dsn);
        if(conn->recv_sn != 0 && sn - conn->recv_sn > 20)
        {
            mlog("handle packet, error recv_sn span(%d - %d) > 20", dsn, conn->recv_sn);
        }
        conn->recv_sn = sn;
    }


    muint16_t packlen = ALL_HEADER_LEN + datahdr->optlen + getDatalen(datahdr);

    //LOG
    char tmp[10];
    char *logData = malloc(packlen * 3 + 10);
    logData[0] = '\0';
    muint16_t i;
    for(i = 0; i < packlen; i++)
    {
        if(i == sizeof(mt2_header_t)
            || i == sizeof(mt2_header_t) + sizeof(mt2_data_header_t)
            || i == sizeof(mt2_header_t) + sizeof(mt2_data_header_t) + datahdr->optlen)
        {
            logData[strlen(logData) - 1] = '|';
        }
        sprintf(tmp, "%02x ", ((muint8_t *)header)[i]);
        strcat(logData, tmp);

        if(i > 20)
        {
            strcat(logData, "...");
            break;
        }
    }

    char fromText[10] = "server";
    if(conn != &conn->ctx->pri->serverConn)
    {
        sprintf(fromText, "lan%d", conn->index);
    }

    mlog("handle packet[%s], type=%d data=%s", fromText, header->type, logData);
    free(logData);

    //У
    for(i = 0; i < datahdr->optlen; i++)
    {
        check += opt[i];
    }

    for(i = 0; i < getDatalen(datahdr); i++)
    {
        check += ((muint8_t *)datapart)[i];
    }

    if(check != datahdr->datacheck)
    {
        mlog("handle packet, check fail");
        return;
    }

    switch(type)
    {
        //ظ
    case MT2_PACKET_TYPE_HB_RESP:
        conn->last_hb_recv_time = MT2Time();
        MT2CtxConnRecvHb(conn->ctx, conn);
        connHandleHeartbeatResp(conn, header);
        break;

        //½ظ
    case MT2_PACKET_TYPE_LOGIN_RESP:
        connHandleLoginResp(conn, header);
        break;

        //json
    case MT2_PACKET_TYPE_JSON_DATA:
        //ĩβ0ַ㴦
        DATA(header)[getDatalen(datahdr)] = '\0';
        MT2CtxJHHandleJsonText(conn->ctx, conn, (char *)DATA_CONTENT(header));
        break;

        //
    case MT2_PACKET_TYPE_LAN_DISCOVER:
        connHandleLanDiscover(conn, header);
        break;

        //֤
    case MT2_PACKET_TYPE_LAN_AUTH:
        connHandleLanAuth(conn, header);
        break;

        //̼֪ͨ
    case MT2_PACKET_TYPE_UPGRADE_NOTIFY:
        connHandleUpgradeNotify(conn, header);
        break;

        //ظ
    case MT2_PACKET_TYPE_UNBIND:
        connHandleUnbindResp(conn, header);
        break;

        //˳
    case MT2_PACKET_TYPE_QUIT_ADD:
        memcpy(buf, opt, datahdr->optlen);
        buf[datahdr->optlen] = '\0';
        if(strcmp(buf, conn->ctx->pri->deviceid) == 0)
        {
            mlog("quit add");
            MT2CtxStopAddDiscover((MT2Ctx_t *)conn->ctx);
        }
        break;

    default:
        break;
    }
}

_mtag mbool_t MT2PavketBufRecv(MT2PacketBuf_t *buf, muint8_t byte, MT2Conn_t *conn)
{
    mt2_header_t *header = (mt2_header_t *)buf->buf;
    mt2_data_header_t *dataheader = (mt2_data_header_t *)(header + 1);

    buf->buf[(*buf->bufcnt)++] = byte;

    //magic[0]
    if((*buf->bufcnt) == 1)
    {
        if(byte != MAGIC0)
        {
            mlog("magic0 err %02x", byte);
            (*buf->bufcnt) = 0;
        }
    }
    //magic[1]
    else if((*buf->bufcnt) == 2)
    {
        if(byte != MAGIC1)
        {
            mlog("magic1 err %02x", byte);
            (*buf->bufcnt) = 0;
        }
    }
    //ͷ
    else if((*buf->bufcnt) == sizeof(mt2_header_t))
    {
        //
        if(header->type == MT2_PACKET_TYPE_HB)
        {
            (*buf->bufcnt) = 0;
            if(conn && conn->status == MT2CONN_STATUS_ONLINE)
            {
                conn->last_hb_recv_time = MT2Time();
                MT2CtxConnRecvHb(conn->ctx, conn);
                connSendPacket(conn, mtrue, MT2_PACKET_TYPE_HB_RESP, 0, MNULL, 0, MNULL);
            }
        }
    }
    else if((*buf->bufcnt) >= ALL_HEADER_LEN)
    {
        //ͷ
        if((*buf->bufcnt) == ALL_HEADER_LEN)
        {
            dataheader->datalen = MT2NToHS(getDatalen(dataheader));
            if(conn)
            {
                muint16_t len = ALL_HEADER_LEN + dataheader->optlen + getDatalen(dataheader);
                muint8_t *newbuf = malloc(len);
                memcpy(newbuf, conn->recvbuf, ALL_HEADER_LEN);
                free(conn->recvbuf);
                conn->recvbuf = newbuf;
                conn->recv_bufsize = len;
                buf->buf = conn->recvbuf;
                buf->bufsize = conn->recv_bufsize;
                header = (mt2_header_t *)buf->buf;
                dataheader = (mt2_data_header_t *)(header + 1);
            }
        }

        //
        if((*buf->bufcnt) == ALL_HEADER_LEN + dataheader->optlen + getDatalen(dataheader))
        {
            if(conn)
            {
                connHandlePacket(conn, header);
                free(conn->recvbuf);
                conn->recvbuf = MNULL;
                conn->recv_bufsize = 0;
            }
            (*buf->bufcnt) = 0;

            return mtrue;
        }
    }

    return mfalse;
}

_mtag static void connTCPRecvByte(MT2Conn_t *conn, muint8_t byte)
{
    MT2PacketBuf_t packbuf;

    if(conn->recv_bufsize == 0)
    {
        conn->recvbuf = malloc(ALL_HEADER_LEN);
        conn->recv_bufsize = ALL_HEADER_LEN;
    }

    packbuf.buf = conn->recvbuf;
    packbuf.bufcnt = &conn->recv_count;
    packbuf.bufsize = conn->recv_bufsize;
    MT2PavketBufRecv(&packbuf, byte, conn);
}

_mtag void MT2ConnHandleTCP(MT2Conn_t *conn, const muint8_t *data, muint16_t len)
{
    muint16_t i;
    for(i = 0; i < len; i++)
    {
        connTCPRecvByte(conn, data[i]);
    }
}

_mtag void MT2ConnHandleUDP(MT2Conn_t *conn, const muint8_t *data, muint16_t len)
{
    mt2_header_t *hdr = (mt2_header_t *)data;
    mt2_data_header_t *dataheader = DHDR(hdr);

    hdr->magic = MT2NToHS(hdr->magic);

    if(hdr->magic != MAGIC)
    {
        mlog("lan magic err");
        return;
    }

    dataheader->datalen = MT2NToHS(getDatalen(dataheader));

    connHandlePacket(conn, hdr);
}

_mtag static mbool_t needACK(mt2_packet_type_t type)
{
    return mfalse;
}

_mtag muint16_t MT2PackPacket(muint8_t *buf, MT2AesKeyType_t keytype, mt2_packet_type_t type, muint8_t optlen, const muint8_t *opt, muint16_t datalen, const muint8_t *data, muint16_t *sn, const char *key, const char *iv)
{
    muint16_t i;
    mt2_header_t *header = (mt2_header_t *)buf;
    header->magic = MT2HToNS(MAGIC);

    header->type = type;
    header->ack = needACK(type);
    header->reserved = 0;

    mt2_data_header_t *data_header = (mt2_data_header_t *)(header + 1);
    data_header->optlen = optlen;
    data_header->datalen = 0;
    data_header->datacheck = 0;

    //ѡ
    muint8_t *optbuf = (muint8_t *)(data_header + 1);
    if(opt)
    {
        //У
        for(i = 0; i < optlen; i++)
        {
            data_header->datacheck += opt[i];
        }

        memcpy(optbuf, opt, optlen);
    }

    //
    muint8_t *databuf = (muint8_t *)optbuf + optlen;
    if(data)
    {
        data_header->datalen = datalen + sizeof(mt2_data_part_t);
        mt2_data_part_t *datapart = (mt2_data_part_t *)databuf;

        datapart->sn = MT2HToNS(*sn);
        *sn = *sn + 1;

        memcpy(datapart + 1, data, datalen);

        //У
        for(i = 0; i < getDatalen(data_header); i++)
        {
            data_header->datacheck += databuf[i];
        }

        data_header->datalen = MT2AdapterCrypto(mtrue, keytype, key, iv, databuf, databuf, getDatalen(data_header));

        //У
        muint16_t dlen = getDatalen(data_header);
        data_header->datacheck += ((muint8_t *)(&dlen))[0];
        data_header->datacheck += ((muint8_t *)(&dlen))[1];
    }

    muint16_t sendlen = sizeof(mt2_header_t);
    if(type != MT2_PACKET_TYPE_HB)
    {
        sendlen += (sizeof(mt2_data_header_t) + data_header->optlen + getDatalen(data_header));
    }

    data_header->datalen = MT2HToNS(getDatalen(data_header));

    return sendlen;
}

_mtag static void connSendPacket(MT2Conn_t *conn, mbool_t istcp, mt2_packet_type_t type, muint8_t optlen, const muint8_t *opt, muint16_t datalen, const muint8_t *data)
{
    muint8_t *sendbuf = malloc(ALL_HEADER_LEN + optlen + sizeof(mt2_data_part_t) + datalen + 16);

    char *key = NULL;
    char *iv = NULL;

    MT2AesKeyType_t keytype = getConnKey(conn, &key, &iv);

    muint16_t packlen = MT2PackPacket(sendbuf, keytype, type, optlen, opt, datalen, data, &conn->send_sn, key, iv);

#if 0
    mlog("%s", istcp ? "TCP" : "UDP");
    for(i = 0; i < packlen; i++)
    {
        if(i == sizeof(mt2_header_t)
            || i == sizeof(mt2_header_t) + sizeof(mt2_data_header_t)
            || i == sizeof(mt2_header_t) + sizeof(mt2_data_header_t) + DHDR(sendbuf)->optlen)
        {
            mprintf(" ");
        }
        mprintf("%02x ", sendbuf[i]);
    }
    mprintf("\n");
#endif

    if(MT2NetifIsOK())
    {
        MT2Socket_t *socket = istcp ? conn->socket : conn->ctx->pri->udpSocket;
        MT2SocketSend(socket, sendbuf, packlen);
    }

    free(sendbuf);
}

_mtag void mt2conn_unbind(MT2Conn_t *conn)
{
    /*
    󶨹ϵķΧĿǰַ֧Χ
    0û豸İ󶨹ϵ
    1зû豸İ󶨹ϵ
    */

    muint8_t scope = 0;
    connSendPacket(conn, mtrue, MT2_PACKET_TYPE_UNBIND, 0, MNULL, 1, &scope);
}

_mtag void MT2ConnLogin(MT2Conn_t *conn)
{
    muint8_t optlen;
    muint8_t datalen;
    muint8_t optbuf[256];
    muint8_t databuf[1024];

    connNew(conn);
    conn->status = MT2CONN_STATUS_LOGINING;

    muint8_t deviceid_len = (muint8_t)strlen(conn->ctx->pri->deviceid);

    optlen = 0;

#if MT2_OPTION_GATEWAY
    optbuf[optlen++] = 3; //½أ̶3
#else
    optbuf[optlen++] = 2; //½豸̶2
#endif
    optbuf[optlen++] = 0; //
    optbuf[optlen++] = 0; //
    memcpy(optbuf + optlen, conn->ctx->pri->deviceid, deviceid_len); //豸id
    optlen += deviceid_len;

    datalen = 0;
    databuf[datalen++] = deviceid_len;  //豸id
    memcpy(databuf + datalen, conn->ctx->pri->deviceid, deviceid_len);
    datalen += deviceid_len;
    databuf[datalen++] = 1; //Э汾
    databuf[datalen++] = 0;
    databuf[datalen++] = 0;
    databuf[datalen++] = 0;

    connSendPacket(conn, mtrue, MT2_PACKET_TYPE_LOGIN, optlen, optbuf, datalen, databuf);
}

_mtag void MT2ConnSendJsonData(MT2Conn_t *conn, const char *json_text)
{
    connSendPacket(conn, mtrue, MT2_PACKET_TYPE_JSON_DATA, 0, MNULL, (muint16_t)strlen(json_text), (muint8_t *)json_text);
}

_mtag void MT2ConnConnect(MT2Conn_t *conn, const char *token)
{
    muint8_t datalen = 0;
    muint8_t databuf[50];

    connNew(conn);
    conn->status = MT2CONN_STATUS_CONNECTING;

    muint8_t device_model_len = (muint8_t)strlen(conn->ctx->pri->deviceModel);
    muint8_t module_model_len = (muint8_t)strlen(conn->ctx->pri->moduleModel);

    databuf[datalen++] = 0; //0 JSONЭ飬1 binaryЭ
    databuf[datalen++] = conn->ctx->pri->deviceVer[0]; //豸汾
    databuf[datalen++] = conn->ctx->pri->deviceVer[1];
    databuf[datalen++] = conn->ctx->pri->deviceVer[2];
    databuf[datalen++] = conn->ctx->pri->deviceVer[3];
    databuf[datalen++] = conn->ctx->pri->moduleVer[0]; //ģ汾
    databuf[datalen++] = conn->ctx->pri->moduleVer[1];
    databuf[datalen++] = conn->ctx->pri->moduleVer[2];
    databuf[datalen++] = conn->ctx->pri->moduleVer[3];
    databuf[datalen++] = device_model_len; //Ʒͺų
    memcpy(databuf + datalen, conn->ctx->pri->deviceModel, device_model_len); //Ʒͺ
    datalen += device_model_len;
    databuf[datalen++] = module_model_len; //ģͺų
    memcpy(databuf + datalen, conn->ctx->pri->moduleModel, module_model_len); //ģͺ
    datalen += module_model_len;

    connSendPacket(conn, mtrue, MT2_PACKET_TYPE_CONNECT, MT2_TOKEN_LEN, (muint8_t *)token, datalen, databuf);
}

_mtag void MT2ConnDisconnect(MT2Conn_t *conn)
{
    conn->status = MT2CONN_STATUS_IDLE;
}

_mtag void MT2ConnLanConnected(MT2Conn_t *conn)
{
    connNew(conn);
    conn->is_lan = mtrue;
    conn->status = MT2CONN_STATUS_CONNECTING;
    conn->last_hb_recv_time = MT2Time();
}

_mtag void MT2ConnHandle(MT2Conn_t *conn)
{
    //״̬
    if(conn->status == MT2CONN_STATUS_ONLINE)
    {
        //
        if(!conn->is_lan && MT2Time() - conn->last_hb_send_time > conn->hb_span_ms)
        {
            conn->last_hb_send_time = MT2Time();
            connSendPacket(conn, mtrue, MT2_PACKET_TYPE_HB, 0, MNULL, 0, MNULL);
        }

        //ʱ
        mtime_t timeout = conn->hb_span_ms + (conn->is_lan ? 15000 : 20000);
        if(MT2Time() - conn->last_hb_recv_time > timeout)
        {
            MT2CtxConnHbTimeout(conn->ctx, conn);
        }
    }
    //
    else if(conn->status != MT2CONN_STATUS_IDLE)
    {
        //Ȩʱ
        mtime_t cur = MT2Time();

        if(conn->is_lan && cur - conn->last_hb_recv_time > 5000)
        {
            MT2CtxConnHbTimeout(conn->ctx, conn);
        }
    }
}

_mtag void MT2ConnRespLanDiscover(MT2Conn_t *conn, const char *model, muint32_t timestamp, mbool_t incfg)
{
    muint8_t optlen = 0;
    muint8_t opt[100];

    //豸ID
    muint8_t deviceidlen = (muint8_t)strlen(conn->ctx->pri->deviceid);
    opt[optlen++] = deviceidlen;
    memcpy(opt + optlen, conn->ctx->pri->deviceid, deviceidlen);
    optlen += deviceidlen;

    //ͺ
    muint8_t modellen = (muint8_t)strlen(model);
    opt[optlen++] = modellen;
    memcpy(opt + optlen, model, modellen);
    optlen += modellen;

    opt[optlen++] = 0;      //protocol
    opt[optlen++] = 1;      //lanControl
    opt[optlen++] = incfg;  //

    //key
    if(incfg)
    {
        char text_timestamp[16];
        strcpy(text_timestamp, MT2NumToString(timestamp));

        opt[optlen++] = 16;

        MT2AdapterCrypto(mtrue, MT2_AES_KEY_TYPE_LAN, conn->ctx->pri->devicepin + 16, conn->ctx->pri->devicepin + 16, (muint8_t *)text_timestamp, opt + optlen, (muint16_t)strlen(text_timestamp));

        optlen += 16;
    }
    else
    {
        opt[optlen++] = 0;
    }

    connSendPacket(conn, mfalse, MT2_PACKET_TYPE_LOGIN_RESP, optlen, opt, 0, MNULL);
}

