#ifndef MT2SOCKET_ADAPTER_H
#define MT2SOCKET_ADAPTER_H
#include "MT2Def.h"

//Socket
typedef enum
{
    MT2SOCKET_TYPE_UDP,
    MT2SOCKET_TYPE_TCP,
}MT2SocketType_t;

struct MT2Socket_st;
typedef struct MT2Socket_st MT2Socket_t;

typedef void (*MT2SocketRecvCallback_t)(MT2Socket_t *sock, const muint8_t *data, mint32_t len);
typedef void (*MT2SocketListenCallback_t)(MT2Socket_t *sock, MT2Socket_t *newSock);
typedef void (*MT2SocketConnectCallback_t)(MT2Socket_t *sock, mbool_t success);
typedef void (*MT2SocketDisconnectCallback_t)(MT2Socket_t *sock);

struct MT2Socket_st
{
    MT2SocketType_t type;
    muint8_t connected;
    MT2SocketRecvCallback_t recvCallback;
    MT2SocketConnectCallback_t connectCallback;
    MT2SocketDisconnectCallback_t disconnectCallback;
    MT2SocketListenCallback_t listenCallback;
    void *userdata;
    void *pri;
};

//socket
MT2Socket_t *MT2SocketCreate(MT2SocketType_t sockType);

//socket
void MT2SocketDestroy(MT2Socket_t *sock);

//
void MT2SocketConnect(MT2Socket_t *sock, const char *ip, muint16_t port);

//ʼ
void MT2SocketStartListen(MT2Socket_t *sock, muint16_t port);

//TCP
mint32_t MT2SocketSend(MT2Socket_t *sock, const muint8_t *data, mint32_t len);

//ȡUDPԶ˵ַ
void MT2SocketGetRemoteAddr(MT2Socket_t *sock, char *ip, muint16_t *port);

//UDP
mint32_t MT2SocketSendTo(MT2Socket_t *sock, const char *ip, muint16_t port, const muint8_t *data, mint32_t len);

//Ͽ
void MT2SocketDisconnect(MT2Socket_t *sock);

typedef void (*MT2SocketDnsResolveCallback_t)(const char *host, const char *ip, muint8_t success);

//DNS
void MT2SocketDnsResolve(const char *host, MT2SocketDnsResolveCallback_t callback);

#endif // MT2SOCKET_ADAPTER_H
