#include "SysTypes.h"
#include "../MachtalkUser.h"

#ifdef __WIN__
#include <Windows.h>
#define SLEEP_MS() Sleep(1)
#else
#include <unistd.h>
#define SLEEP_MS() usleep(1000)
#endif



void MT2SocketInitialize();
void MT2SocketPoll();
void MT2SocketBackPoll();

int main()
{
#ifdef __WIN__
    WORD wVersionRequested = MAKEWORD(1, 1);
    WSADATA wsaData;

    int err = WSAStartup(wVersionRequested, &wsaData);
    if(0 != err)
    {
    }
#endif

    //socketʼ
    MT2SocketInitialize();

    //MachtalkLibʼ
    MachtalkUserInit();

    while(1)
    {
        MT2SocketPoll();
        MT2SocketBackPoll();
        MachtalkUserHandle();
        MachtalkUserTimePass(1);
        SLEEP_MS();
    }

    return 0;
}
