#include "SysTypes.h"
#include "MT2.h"
#include "machtalk_link.h"

#ifdef WIFI
#include "Wifi.h"
#endif

#define MODEL_ID "cbcxuw" //ͺID
#define MODEL_PIN "6942be3f78be44fda4ea74a0552eab6a" //ͺPIN

static MT2Ctx_t *g_ctx;
static uint32_t g_running;
static char g_deviceid[20];
static char g_devicepin[33];

static char g_lockChn;
static char g_startNetCfg;
static uint32_t g_lastSwitchChnTime;

//ota
static MT2OTAType_t g_otaType;
static uint8_t g_version[4];

static void mt2EventHandler(MT2Ctx_t *ctx, muint8_t event, void *arg)
{
    //
    if(event == MT2EVENT_OPT)
    {
        MT2EventOptArg_t *opt = arg;
        uint8_t i;
        for(i = 0; i < opt->propertyNum; i++)
        {
            MT2Property_t *property = &opt->propertys[i];
            //յƺҪƺֵͬ
            MT2CtxSyncPropertyValue(g_ctx, property->pid, property->value);

            mlog("control propertyid:%d value:%d", property->pid, property->value.num);
        }
    }
    //豸ID
    else if(event == MT2EVENT_APPLYID)
    {
        //뵽豸IDPIN룬Ӧдflash
        MT2EventApplyidArg_t *applyidArg = arg;
        strcpy(g_deviceid, applyidArg->deviceid);
        strcpy(g_devicepin, applyidArg->devicepin);
        mlog("deviceid:%s pin:%s", applyidArg->deviceid, applyidArg->devicepin);
    }
    //ѯ
    else if(event == MT2EVENT_QUERY)
    {
        //豸״̬ѾʵʱͨMT2CtxSyncPropertyValueͬҪκδҪͬһ顣
        mlog("Query");
    }
    //·ʱ
    else if(event == MT2EVENT_UPDATE_SERVER_TIME)
    {
        MT2EventUpdaeServerTimeArg_t *timearg = arg;
        mlog("timezone:%d seconds:%d", timearg->timezone, timearg->seconds);
    }
    //ɹ
    else if(event == MT2EVENT_UNBIND_RESULT)
    {
        mlog("unbind success.");
    }
    //״̬仯
    else if(event == MT2EVENT_SERVER_STATUS_CHANGE)
    {
        MT2ServerStatus_t *serverStatus = arg;

        switch(*serverStatus)
        {
        case MT2_SERVER_STATUS_ONLINE:
            mlog("server online");
            break;

        case MT2_SERVER_STATUS_IDLE:
            mlog("server idle");
            break;

        case MT2_SERVER_STATUS_LS_CONNECTING:
            mlog("server ls connecting");
            break;

        case MT2_SERVER_STATUS_LS_CONNECTED:
            mlog("server ls connected");
            break;

        case MT2_SERVER_STATUS_CS_CONNECTING:
            mlog("server cs connecting");
            break;

        case MT2_SERVER_STATUS_CS_CONNECTED:
            mlog("server cs connected");
            break;
        }
    }
    //ظAPPӷ
    else if(event == MT2EVENT_RESP_ADD_DISCOVER)
    {
        mlog("resp add discover");
    }
    //̼֪ͨ
    else if(event == MT2EVENT_OTA_NOTIFY)
    {
        MT2EventUpgradeArg_t *upgradeArg = arg;

        mlog("ota notify type:%d version:%d.%d.%d.%d", 
            upgradeArg->type,
            upgradeArg->version[0],
            upgradeArg->version[1],
            upgradeArg->version[2],
            upgradeArg->version[3]);

        g_otaType = upgradeArg->type;
        memcpy(g_version, upgradeArg->version, 4);
        MT2CtxStartOTADownload(ctx, upgradeArg, 0);
    }
    //̼
    else if(event == MT2EVENT_OTA_DATA)
    {
        MT2EventOTADataArg_t *dataArg = arg;
        if(dataArg->status == MT2_OTA_DATA_STAUTS_SUCCESS)
        {
            mlog("ota success");
            MT2CtxStopOTADownlaod(ctx);
            MT2CtxUpdateOTAStatus(ctx, g_otaType, MT2_OTA_STATUS_UPGRAD_SUCCESS, 0, g_version);
        }
        else if(dataArg->status == MT2_OTA_DATA_STAUTS_FAIL)
        {
            mlog("ota download fail");
            MT2CtxStopOTADownlaod(ctx);
            MT2CtxUpdateOTAStatus(ctx, g_otaType, MT2_OTA_STATUS_UPGRAD_FAIL, 0, g_version);
        }
        else
        {
            //TODO յ̼ݱ浽Flash
        }
    }
}

void MachtalkUserInit()
{
    mlog("");

    //ʼ
    MT2Init();
    //ƽ̨
    g_ctx = MT2CtxCreate();
    //ƽ̨
    MT2CtxPlatformCfg_t platformCfg;
    //ServerHostΪֱдIPַҪ"IP:"ͷ"IP:192.168.0.1"
    platformCfg.loginServerHost = "nls.machtalk.net"; //½
    platformCfg.loginServerPort = 6779;
    platformCfg.applyidServerHost = "ds.machtalk.net"; //ID
    platformCfg.applyidServerPort = 10080;
    platformCfg.platformid = 0; //ƽ̨ID
    MT2CtxSetPlatformCfg(g_ctx, &platformCfg);
    //¼ص
    MT2CtxSetEventHandler(g_ctx, mt2EventHandler);
    //豸ͺIDͺIDƽ̨䣬ÿƷΨһ
    MT2CtxSetDeviceModel(g_ctx, MODEL_ID);

    //עֵ
    MT2CtxRegistProperty(g_ctx, 1, MT2_PROPERTY_TYPE_NUM);
    MT2CtxRegistProperty(g_ctx, 2, MT2_PROPERTY_TYPE_NUM);
    //ֵͬ
    MT2PropertyValue_t value;
    value.num = 0;
    MT2CtxSyncPropertyValue(g_ctx, 1, value);
    MT2CtxSyncPropertyValue(g_ctx, 2, value);

    //ʼ豸ӷ
    MT2CtxStartAddDiscover(g_ctx);
}

void MachtalkUserHandle()
{
    //ƽ̨߼
    MT2CtxHandle(g_ctx);

    //豸ID
    if(g_deviceid[0] != '\0')
    {
        //ʼ
        if(!MT2CtxHasStartConnect(g_ctx))
        {
            //豸IDPIN
            MT2CtxSetDeviceid(g_ctx, g_deviceid, g_devicepin);

            //ʼ
            MT2CtxStartConnect(g_ctx);
        }
    }
    //豸ID10豸ID
    else
    {
        if(MT2NetifIsOK())
        {
            static unsigned long lastApplyidTime;
            if(lastApplyidTime == 0 || g_running - lastApplyidTime > 10000)
            {
                lastApplyidTime = g_running;
                //ʹͺIDͺPIN豸ID룬ͺIDͺPINƽ̨
                MT2CtxApplyDeviceid(g_ctx, MODEL_ID, MODEL_PIN);
            }
        }
    }

#ifdef WIFI
    if(g_startNetCfg)
    {
        static uint8_t chn = 1;
        //δŵʱѭ100msлŵ
        if(!g_lockChn && g_running - g_lastSwitchChnTime > 100)
        {
            mlog("chn:%d", chn);
            g_lastSwitchChnTime = g_running;
            WifiSnifferSetChannel(chn);
            chn++;
            if(chn > 14)
            {
                chn = 1;
            }
        }
    }
#endif
}

void MachtalkUserTimePass(int pass)
{
    g_running += pass;
    //ʱpass
    MT2TimePass(pass);
        }

#ifdef WIFI
static WifiSnifferStatus_t wifiSnifferCallback(const uint8_t *data, uint16_t len)
{
    mtlink_status_t status = mtlink_recv(data, len);
    //ŵ
    if(status == MTLINK_STATUS_LOCK)
    {
        g_lockChn = 1;
    }
    //
    else if(status == MTLINK_STATUS_COMPLETE)
    {
        mtlink_res_t res;
        mtlink_get_res(&res);

        mlog("got ssid:%s pwd:%s", res.ssid, res.pwd);

        g_startNetCfg = 0;
        WifiSnifferStop();

        //·
        WifiJoinAp(res.ssid, res.pwd, WIFI_AUTH_WPA_WPA2_PSK);
        WifiReconnect();

        //ʼ豸ӷ֣ʼ豸ӷܱ֮APPֲ
        MT2CtxStartAddDiscover(g_ctx);
    }
}
#endif

void MachtalkUserStartNetCfg(void)
{
    mlog("");
#ifdef WIFI
    if(!g_startNetCfg)
    {
        g_startNetCfg = 1;
        //ʼ
        mtlink_init();
        //лģʽ802.11֡
        WifiSnifferStart(wifiSnifferCallback);
    }
#endif
}

void MachtalkUserStopNetCfg(void)
{
    mlog("");
#ifdef WIFI
    g_startNetCfg = 0;
    WifiSnifferStop();
    WifiReconnect();
#endif
    }