#include "ets_sys.h"
#include "driver/uart.h"
#include "osapi.h"
#include "user_interface.h"
#include "c_types.h"
#include "../MachtalkUser.h"
#include "Wifi.h"

static bool g_init;
static os_event_t g_events[1];

ICACHE_FLASH_ATTR static void task(os_event_t *event)
{
    if(!g_init)
    {
        g_init = true;
        WifiInitialize();
        WifiJoinAp("EMBEDED_02_D-LinkDIR616", "emb12345678", WIFI_AUTH_WPA_WPA2_PSK);
        MachtalkUserInit();
        MachtalkUserStartNetCfg();
    }
    else
    {
        MachtalkUserHandle();
        
        static uint32_t lasttime;
        uint32_t diff = system_get_time() - lasttime;
        diff /= 1000;
        if(diff)
        {
            lasttime = system_get_time();

            if(diff < 100)
            {
                MachtalkUserTimePass(diff);
            }
        }
    }

    system_os_post(0, 0, 0);
}

void user_rf_pre_init()
{


}

void user_init(void)
{
    uart_init(1, 0, 115200);
    uart_switch_debug(1);

    system_os_task(task, 0, g_events, 1);
    system_os_post(0, 0, 0);
}

