#include "Adapter/MT2Adapter.h"
#include "Aes.h"
#include "../Wifi.h"

_mtag muint16_t MT2AdapterCrypto(mbool_t isencrypt, MT2AesKeyType_t keytype, const char *key, const char *iv, const void *in, void *out, muint16_t len)
{
    if(isencrypt)
    {
        return AES128CBCEncrypt(in, out, len, key, iv);
    }
    else
    {
        return AES128CBCDecrypt(in, out, len, key, iv);
    }

    return 0;
}

_mtag mbool_t MT2NetifIsOK(void)
{
    return WifiConnected();
}

_mtag const char *MT2GetDeviceUUID(char *buf)
{
    sprintf(buf, "%02x%02x%02x%02x%02x%02x", 
        WifiGetMac()[0],
        WifiGetMac()[1],
        WifiGetMac()[2],
        WifiGetMac()[3],
        WifiGetMac()[4],
        WifiGetMac()[5]);

    mlog(buf);

    return buf;
}