var zIndex = 4;
var userListeners;
var userCallback;
var queryResult;

function MachtalkClient(params, init, listeners, wscallback) {
	userListeners = listeners || {};
	userCallback = wscallback || {};
	var client = new Object();

	client.query = function (to, callback) {
		queryResult = stringToJson(window.cloud.query());
		callback(queryResult);
	}

	client.httpReq = function (url, method, params, needLogin, callback) {
		var result = window.cloud.httpReq(url, method, params, needLogin);
		if (callback != null) {
			callback(result);
		}
	}

	client.showMsg = function() {
		window.cloud.showMsg();
	}
	
	client.getDeviceName = function() {
		return window.cloud.getDeviceName();
	}

	client.getDeviceId = function() {
		return window.cloud.getDeviceId();
	}
	
	client.close = function() {
		window.cloud.close();
	}
	
	client.opt = function (to, dvid, value, callback) {
		window.cloud.opt(dvid, value);
	}
	
	client.shareFriend = function () {
		window.cloud.shareFriend();
	}
	
	client.shareDevice = function () {
		window.cloud.shareDevice();
	}
	
	client.editName = function () {
		window.cloud.editName();
	}
	
	client.updateWifi = function () {
		window.cloud.updateWifi();
	}
	
	client.deviceUsers = function () {
		window.cloud.deviceUsers();
	}
	
	client.deleteDevice = function () {
		window.cloud.deleteDevice();
	}
	
	client.upgrade = function () {
		window.cloud.upgrade();
	}
	/**
	 * 启动关于页面
	 * @param help 设备帮助页面url
	 * @param question 设备常见页面url
	 * @param showReset 是否显示固件升级
	 * @param showUpgrade 是否显示固件升级
     */
	client.about = function (help, question, showReset, showUpgrade) {
		window.cloud.about(help, question, showReset, showUpgrade);
	}

	client.showWindow = function (id, callback) {
		document.getElementById(id).style.display = "";
		document.getElementById(id).style.zIndex = ++zIndex;
		document.getElementById(id).style.left = 0;
		document.getElementById(id).style.top = 0;
		document.getElementById(id).style.position = "absolute";
		//        left:50%; top:50%;
		if (!document.getElementById("background").style.display == "") {
			document.getElementById("background").style.display = "";
		}
		callback;
	}
	client.closeWindow = function (id, callback) {
		--zIndex;
		document.getElementById(id).style.display = "none";
		document.getElementById(id).style.zIndex = "";
		if (divMap.isEmpty() || null == divMap || divMap.size() == 0) {
			document.getElementById("background").style.display = "none";
		}
		callback;
	}
	
	if (init != "undefined") {
		var wtimer = setInterval(function () {
			clearInterval(wtimer);
			init(stringToJson("{\"code\":0}"));
		}, 10);
	}
	return client;
}

function show(x) {
	alert(x);
}

function stringToJson(str) {
	try {
		str = str.replace(/\'/g, "\"");
		return JSON.parse(str);
	} catch (error) {
		console.log(error);
	}
}

function queryString(name) {
	return name;
}

function getCookieValue(name) {
	return name;
}

function query(to, callback) {
	window.test.query(to);
}

function updateDeviceName(name) {
	userListeners.updateDeviceName(name);
}

function getValue(dvid) {
	var saveAs = queryResult["as"];
	return saveAs[dvid];
}

function post(data) {
	if (userListeners) {
		var jsonData = stringToJson(data);
		var as = jsonData["as"];
		var saveAs = queryResult["as"];
		for (var key in as) {
			saveAs[key] = as[key];
		}
		userListeners.post(jsonData);
	}
}

function online() {
	if (userListeners) {
		userListeners.online();
	}
}

function lanOnline(result) {
	if (userListeners.hasOwnProperty("lanOnline")) {
		userListeners.lanOnline(result);
	}
}

function onlyLanOnline(result) {
	if (userListeners.hasOwnProperty("onlyLanOnline")) {
		userListeners.onlyLanOnline(result);
	}
}

function offline() {
	if (userListeners) {
		userListeners.offline();
	}
}

function otaPost() {
	if (userListeners) {
		userListeners.otaPost();
	}
}

function alarm() {
	if (userListeners) {
		userListeners.alarm();
	}
}

