//
//  UserManager.h
//  CloudLib
//
//  Created by iMac on 16/1/13.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

@class User;

@interface UserManager : NSObject

-(instancetype)init;
+(void)setUser:(User*)user;
+(User*)getUser;

/**
 * 登陆成功后，把用户添加或更新到数据库中，并保存到缓冲中
 */
+(void)addOrUpdateUser:(NSString *)loginName pwd:(NSString *)password uid:(NSString *)uid apikey:(NSString *)apikey;

/**
 * 当查询用户信息成功后，把最新的用户信息更新到数据库中
 */
+(void)updateUserInfo:(User*)newUser;

/**
 * 当用户保存了登录信息，一旦用户登录成功，或者之前登录过，则会保存用户密码
 */
+(BOOL)isSaveLogin;

+(void)clearUser;

/**
 *  更新密码，写入数据库
 *
 *  @param password 新的密码
 */
+(void)updatePassword:(NSString *)password;

@end
