//
//  User.h
//  CloudLib
//
//  Created by iMac on 16/1/11.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

@class UIImage;

@interface User : NSObject

@property (nonatomic, strong) NSString *loginName;  //登陆名称，有可能是手机号、邮箱、用户名
@property (nonatomic, strong) NSString *uid;        //用户唯一标识
@property (nonatomic, strong) NSString *username;   //用户名
@property (nonatomic, strong) NSString *nickname;   //昵称
@property (nonatomic, strong) NSString *password;   //登陆密码
@property (nonatomic, strong) NSString *telephone;  //手机号码
@property (nonatomic, strong) NSString *email;      //邮箱
@property (nonatomic, strong) NSString *sex;        //性别
@property (nonatomic, strong) NSString *birthday;   //生日
@property (nonatomic, strong) NSString *avatar;     //头像位置信息
@property (nonatomic, strong) NSString *APIKey;     //登录后返回的标识用户的标记
@property (nonatomic, strong) NSString *extend;     //扩展属性
@property (nonatomic, strong) NSString *headPhoto;  //Base-64编码后的图片字符串
@property (nonatomic, strong) NSString *photoName;  //头像名称
@property (nonatomic, strong) NSString *subscribe;  //是否订阅APP消息

@property (nonatomic, strong) UIImage  *headImage;  //头像图片
//@property (nonatomic, strong) NSString *UUID;       //32位UUID，数据提交时使用

@property (nonatomic, strong) NSMutableDictionary *extPropDic;

-(instancetype)init;

/**
 * 初始化User
 *
 * @param 登录名
 * @param 登录密码
 */
-(instancetype)initWithNameAndPwd:(NSString*)loginName password:(NSString*)password;

/**
 *  判断当前是否可登陆
 */
-(BOOL)canLogin;

/**
 *  将扩展属性中的sex值取出，放入到sex中
 */
-(void)setExtProp:(NSString *)extProp;

/**
 *  将sex属性，放入到扩张属性中
 */
-(void)setSexExtProp:(NSString *)sex;

@end
