//
//  UpdateProgressMessage.h
//  CloudLib
//
//  Created by iMac on 16/1/12.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import "BusinessMessage.h"

/**
 * 升级进度上报
 */

@interface UpdateProgressMessage : BusinessMessage

@property (nonatomic, assign) int type;          //升级类型，升级的是模块还是设备 0 ：模块 1：设备
/**
     表示升级状态，规定如下：
     1：开始下载		2：下载中		3：下载成功		4：下载失败
     5：开始升级		6：升级中		7：升级成功		8：升级失败
 */
@property (nonatomic, assign) int status;
@property (nonatomic, assign) int percent;         //当前状态的百分比
@property (nonatomic, strong) NSString *version;   //当升级状态为7时，携带version，表示升级到的最新版本号


@end
