//
//  UpdateMessage.h
//  CloudLib
//
//  Created by iMac on 16/1/12.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import "BusinessMessage.h"

/**
 * 设备升级通知
 */

@interface UpdateMessage : BusinessMessage

@property (nonatomic, assign) int style;                //具体是何种方式导致收到该消息，推送方式，查询返回方式
@property (nonatomic, strong) NSString * name;          //升级的设备名称
@property (nonatomic, assign) int  otaType;             //升级类型0：模块  1：设备
@property (nonatomic, strong) NSString * version;       //当前版本
@property (nonatomic, strong) NSString * lastVersion;   //最新版本
@property (nonatomic, assign) BOOL cancle;              //是否可以取消 即是否强制升级
@property (nonatomic, strong) NSString * info;          //升级信息
@property (nonatomic, strong) NSString * ts;            //新固件的发布时间

//module 版本信息
@property (nonatomic, strong) NSString *moduleVer;      //模块当前版本
@property (nonatomic, strong) NSString *moduleNewver;   //模块最新版本
@property (nonatomic, assign) BOOL moduleCancel;       //模块当前版本
@property (nonatomic, strong) NSString *moduleInfo;     //模块当前版本
@property (nonatomic, strong) NSString *moduleTs;       //新模块的发布时间

-(instancetype)initWithQuery:(BOOL)isQueryReturn;
-(NSString *)getTimeStr;

-(void)parseJson:(NSDictionary*)json;


@end
