//
//  TimerTask.h
//  MachtalkSDK
//
//  Created by zhaishengfei on 16/9/2.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

//定时任务结构

@interface TimerTask : NSObject

@property (nonatomic, strong) NSString *action;  //定时任务的执行命令

@property (nonatomic, strong) NSString *did;
@property (nonatomic, strong) NSString *dvid;    // 属性ID
@property (nonatomic, strong) NSString *value;   // 属性值

/*
 *   周期
 *   type为1时必须传入，表示周几执行，十进制整数，七位二进制转换而成，如 1010101 第一位表示星期天，以此类推
 */
@property (nonatomic, assign) int       period;
@property (nonatomic, assign) BOOL      enable;  // 是否有效
@property (nonatomic, assign) BOOL      expired; // 是否过期
@property (nonatomic, strong) NSString *taskId;  // 任务ID
@property (nonatomic, assign) int       time;    // 执行时间点，距离0点0分0秒的秒数
@property (nonatomic, assign) int       type;    // 定时任务类型 1、周期性   2、一次性

@property (nonatomic, strong) NSString *note;    // 任务说明

@end
