//
//  Msg.h
//  CloudLib
//
//  Created by iMac on 16/1/16.
//  Copyright © 2016年 Aibo. All rights reserved.
//


#import <Foundation/Foundation.h>
/**
 * 通知告警消息类
 *
 */
@interface Msg : NSObject

@property(strong,nonatomic) NSString * messageID;
@property(strong,nonatomic) NSString * title;
@property(strong,nonatomic) NSString * desc;         //消息描述
@property(strong,nonatomic) NSString * content;
@property(strong,nonatomic) NSString * recieveTime;  //接收时间
@property(strong,nonatomic) NSString * device;       //设备id
@property(strong,nonatomic) NSString * type;         //消息类型
@property(strong,nonatomic) NSString * isRead;       //是否已读0-未读，1-已读
@property(strong,nonatomic) NSString * user;         //用户uid
@property(strong,nonatomic) NSString * level;
@property(strong,nonatomic) NSString * officialId;   //官方消息id
@property(nonatomic, assign) BOOL isOffline;         //是否是离线消息

/**
 * 消息种类目前主要分为<<官方消息>>和<<设备消息>>两大类型
 * 官方消息目前预留1-20 设备消息从21 - 40 以后有别的消息可以递增
 * 官方消息包括:OfficialMessage 1; 恢复出厂设置消息 2; unbind主人删除客人给客人的通知消息 3;
 * 设备消息:bind(客人添加设备给主人的通知消息)  21; transfer(主人转让权限给新主人的通知消息) 22; post(设备告警消息) 23; fault(设备故障消息)24;
 */

@property(strong,nonatomic) NSString * kind;         //消息种类

@end
