//
//  Message.h
//  CloudLib
//
//  Created by iMac on 16/1/11.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

@class Connection;

@interface Message : NSObject

@property (nonatomic, strong) NSString *to;             //消息的目的对象
@property (nonatomic, assign) double time;              //消息的发送时间，用于计算超时
@property (nonatomic, strong) NSString *error;          //消息的响应错误信息，对应对应错误码，需要自行解析填充
@property (nonatomic, assign) NSString *code;                 //消息的响应错误码
@property (nonatomic, assign) BOOL isSend;              //消息是否已经被发送
@property (nonatomic, assign) BOOL isWan;               //是否是广域网消息
@property (nonatomic, assign) BOOL needResend;          //发送失败时，是否需要重发该消息
@property (nonatomic, assign) int sendCount;            //消息重发次数

-(instancetype)init;

/**
 * 获取消息的字节数组，直接用于发送消息
 * 子类继承，根据Message的不同，进行装包操作。
 *
 * @param 包序号
 */
-(NSData *)getData:(Connection *)connection;

/**
 * 用来处理接收到得json数据
 *
 * @param 可选部 包数据
 */
-(BOOL)handle:(NSData *)optData data:(NSData *)packageData;

/**
 * 消息超时的处理
 */
-(void)timeout;

-(void)reset;
-(BOOL)isNeedResend;


@end
