//
//  MachtalkSDKDelegate.h
//  MachtalkSDK
//
//  Created by iiot on 15/11/3.
//  Copyright © 2015年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "MachtalkSDKConstant.h"


@class Result;
@class User;
@class DevicePermissionChangedNotification;
@class Msg;
@class OfficialDetail;
@class SmartResult;
@class SearchedLanDevice;
@class QueryDeviceInfo;
@class DeviceStatus;
@class DeviceAttributeInfo;
@class ReceivedDeviceMessage;
@class OfficialInfo;
@class DeviceGroupOperateInfo;
@class UpdateMessage;
@class UpdateProgressMessage;
@class DeviceAidStatisticData;
@class TimerTaskList;
@class TimerTask;
@class ACLCompleteCode;



@protocol MachtalkSDKDelegate <NSObject>

@optional
#pragma mark - 用户系统相关接口

/**
 * 用户注册
 */
-(void)onRegisterUser:(Result*)result uid:(NSString*)uid;

/**
 * 用户登录
 */
-(void)onUserLogin:(Result*)result;

/**
 * 退出登录
 */
-(void)onUserLoginOut;

/**
 * 检测用户名是否被注册
 */
-(void)onCheckUserIsRegistered:(Result*)result;

/**
 * 发送校验码
 */
-(void)onCheckValCode:(Result*)result token:(NSString*)token;

/**
 * 发送验证码
 */
-(void)onSendValcode:(Result*)result;

/**
 * 获取用户信息
 */
-(void)onGetUserInfo:(Result*)result UserInfo:(User*)user;

/**
 * 修改用户信息
 */
-(void)onEditUserInfo:(Result*)result;

/**
 * 修改用户密码
 */
-(void)onModifyUserPassword:(Result*)result;

/**
 * 修改用户手机号
 */
-(void)onModPhone:(Result*)result;

/**
 * 修改用户邮箱
 */
-(void)onModEmail:(Result*)result;

/**
 * 找回密码
 */
-(void)onFindUserPassword:(Result*)result;

/**
 * 修改用户信息头像
 */
-(void)onEditUserImage:(Result*)result imagePath:(NSString*)imagePath;


/**
 * 将网络url地址的头像下载到本地
 */
-(void)onGetUserImage:(Result*)result fileName:(NSString*)fileName;

#pragma mark - App相关接口

/**
 * 提交反馈意见
 */
-(void)onCommitFeedback:(Result*)result  feedbackType:(FeedbackType)feedbackType;

/**
 * 获取错误码消息
 */
-(void)onGetErrorInfo:(Result*)result errorInfo:(NSString*)errorInfo;

/**
 * 订阅或者取消订阅官方消息
 */
-(void)onOfficialMessageSubscribe:(Result*)result;

/**
 * 获取官方消息详情
 */
-(void)onGetOfficialMessageDetail:(Result*)result msgDetail:(OfficialDetail*)msgDic;

/**
 * 获取应用启动页
 */
-(void)onGetAppStartPage:(Result*)result startPageImage:(UIImage*)startPageImage;

#pragma mark - 设备相关接口

/**
 * 下载产品列表
 */
-(void)onDownloadProductCatalogInfo:(Result*)result catalogInfo:(NSDictionary*)catalogDic;

/**
 * 获取设备引导页信息
 */
-(void)onGetDeviceGuideInfo:(Result*)result guideInfo:(NSDictionary*)guideInfo;

/**
 * 获取设备引导页图片
 */
-(void)onGetDeviceGuidePicture:(Result*)result pictureInfo:(UIImage*)picture;

/**
 * 获取设备分享码
 */
-(void)onGetDeviceShareCode:(Result*)result shareCodeInfo:(NSString*)shareCodeInfo;

/**
 * 配置设备连接wifi
 */
-(void)onSetDeviceWiFi:(Result*)result addMsg:(SmartResult*)addMsg;

/**
 * 绑定设备
 */
-(void)onBindDevice:(Result*)result deviceId:(NSString*)deviceId;


/**
 * 分享二维码绑定设备
 */
-(void)onbindDeviceByShareCode:(Result*)result deviceId:(NSString*)deviceId;

/**
 * 解绑设备
 */
-(void)onUnbindDevice:(Result*)result;

/**
 * 修改设备名称
 */
-(void)onModifyDeviceName:(Result*)result deviceId:(NSString*)deviceId;

/**
 * 搜索局域网设备
 */
-(void)onStartSearchLanDevice:(Result*)result lanDevice:(SearchedLanDevice*)lanDevice;

/**
 * 停止搜索局域网设备
 */
-(void)onStopSearchLanDevices;

/**
 * 连接局域网设备
 */
-(void)onConnectLanDevice:(Result*)result deviceId:(NSString*)deviceId;

/**
 * 设备上下线通知
 */
-(void)onDeviceOnOffline:(NSString*)deviceId onlineOffline:(DeviceOnOffline)onlineOffline;

/**
 * 与服务器连接状态改变通知
 */
-(void)onServerConnectStatusChanged:(ServerConnStatus)serverConnStatus;

/**
 * 获取设备和分组列表
 */
-(void)onQueryDeviceList:(Result*)result deviceListInfo:(QueryDeviceInfo*)deviceListInfo;


/**
 * 获取各项属性
 */
-(void)onQueryDeviceStatus:(Result*)result deviceStatus:(DeviceStatus*)deviceStatus;

/**
 * 获取属性状态
 */
-(void)onQueryDeviceAttribute:(Result*)result deviceAttribute:(DeviceAttributeInfo*)deviceAttribute;

/**
 * 接收数据命令
 */
-(void)onReceiveDeviceMessage:(Result*)result receivedResult:(ReceivedDeviceMessage*)receivedResult;

/**
 * 查询离线消息
 */
-(void)onQueryOfflineMessages:(Result*)result officialInfo:(OfficialInfo*)officialInfo;
//
/**
 * 查询设备用户信息 DeviceUser list
 */
-(void)onQueryDeviceUsersInfo:(Result*)result usersInfo:(NSArray*)deviceUserList;

/**
 * 设备权限变更通知
 */
-(void)onDevicePermissionChangedNotify:(Result*)result notification:(DevicePermissionChangedNotification*)notification;

/**
 * 转让设备主控权
 */
-(void)onTransferDeviceHost:(Result*)result;

/**
 * 接收服务器发出的消息，包括在线消息和离线消息
 */
-(void)onReceiveMessage:(Result*)result msg:(Msg*)msg;

/**
 * 设备分组操作
 */
-(void)onDeviceGroupOperate:(Result*)result optInfo:(DeviceGroupOperateInfo*)optInfo;

/**
 * 查询设备固件版本信息
 */
-(void)onQueryAllDevicesModuleVersionInfo:(Result*)result versionInfo:(NSMutableArray*)versionInfo;

/**
 * 接收设备固件升级消息
 */
-(void)onReceiveModuleUpdateMessage:(UpdateMessage*)versionInfo;

/**
 * 接收设备固件升级进度。请求设备升级成功，此接口获取升级信息
 */
-(void)onReceiveModuleUpdateProgress:(UpdateProgressMessage*)updateProgress;

/**
 * 获取app最新版本信息
 */
-(void)onGetAppLatestVersion:(Result*)result versionInfo:(NSDictionary*) versionInfo;

/**
 * 查询某个设备的固件版本信息
 */
-(void)onQueryDeviceModuleVersion:(Result*)result versionInfo:(UpdateMessage*)versionInfo;

/**
 * 对设备进行重新排序
 */
-(void)onReorderDevice:(Result*)result;

/**
 * 对某个属性的统计数据
 */
-(void)onGetDeviceAidStatisticData:(Result*)result statisticData:(DeviceAidStatisticData*)statisticData;

/**
 * 查询定时任务列表
 */
-(void)onQueryTimerTaskList:(Result*)result list:(TimerTaskList *)taskList;

/**
 * 查询定时任务详情
 */
-(void)onQueryTimerTaskInfo:(Result*)result info:(TimerTask *)task;

/**
 * 创建定时任务
 */
-(void)onCreateTimerTask:(Result*)result taskId:(NSString *)taskId;

/**
 * 修改定时任务
 */
-(void)onModifyTimerTask:(Result*)result;

/**
 * 删除定时任务
 */
-(void)onRemoveTimerTask:(Result*)result;

/**
 * 删除所有定时任务
 * delCount: 删除的任务数量
 */
-(void)onDeleteAllTimerTask:(Result*)result total:(NSNumber *)delCount;

/**
 * 删除所有定时任务
 * count: 存在的任务数量
 */
-(void)onGetTimerTaskCount:(Result*)result total:(NSNumber *)count;

/**
 * 设备通用数据存储
 */
-(void)onSaveDeviceDatas:(Result*)result;

/**
 * 设备通用数据统计
 * @param datas 返回的设备属性Dictionary列表
 */
-(void)onGetDeviceDatas:(Result*)result data:(NSDictionary *)data;

/**
 * 注册全码库
 * @param id 返回的全码库ID
 */
-(void)onACLRequest:(Result*)result ID:(NSNumber *)ACL_Id;

/**
 * 获取全码库设备类型列表
 * @param list 返回的 ACLDeviceType 列表
 */
-(void)onACLGetDevTypeList:(Result*)result list:(NSArray *)list;

/**
 * 获取全码库设备品牌列表
 * @param list 返回的 ACLDeviceBrand 列表
 */
-(void)onACLGetDevBrandList:(Result*)result list:(NSArray *)list;

/**
 * 获取某品牌全码库设备的遥控器列表
 * @param list 返回的 ACLControllerInfo 列表
 */
-(void)onACLGetControllerList:(Result*)result list:(NSArray *)list;

/**
 * 获取某个遥控器的完整码
 * @param cc 返回的 ACLCompleteCode
 */
-(void)onACLGetCompleteCode:(Result*)result cc:(ACLCompleteCode *)cc;

/**
 * 测试开机码
 * 只代表设备是否收到开机码，不代表开机码能否开机
 */
-(void)onACLOpenCodeTest:(Result*)result;

/**
 * 设置完整码
 * @param rid 设备接收rid成功后，推送rid到所有客户端
 */
-(void)onACLSetCompleteCode:(Result*)result rid:(NSString *)rid;

/**
 * 自动获取红外码库列表
 * @param codes 获取的所有可能的红外码列表
 */
-(void)onACLIRCodeList:(Result *)result codes:(NSArray *)codes;


#pragma mark - 协议功能

@end
