//
//  MachtalkSDKConstant.h
//  MachtalkSDK
//
//  Created by iiot on 15/10/23.
//  Copyright © 2015年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// ------------------检测用户是否注册类型-------------------------------
typedef NS_ENUM(NSInteger, UserType)
{
    EMAIL, //检测邮箱是否被注册
    TELEPHONE, //检测手机号码是否被注册
    USERNAME, //检测用户名是否被注册
};

// ------------------发送验证码类型-------------------------------
typedef NS_ENUM(NSInteger, ValCodeType)
{
    VALCODE_UNDEFINED,
    VALCODE_REGIST,				// 注册验证码
    VALCODE_RESET_PASSWORD,		// 重置密码验证码
    VALCODE_CHANGE_EMAIL,		// 修改邮箱验证码
    VALCODE_CHANGE_PHONE,		// 修改手机号验证码
};

// ------------------设备上线下线-------------------------------
typedef NS_ENUM(NSInteger, DeviceOnOffline)
{
    DEVICE_WAN_ONLINE,  //广域网上线
    DEVICE_WAN_OFFLINE, //广域网下线
    DEVICE_LAN_ONLINE,  //局域网上线
    DEVICE_LAN_OFFLINE, //局域网下线
};

// ------------------与服务器连接状态-------------------------------
typedef NS_ENUM(NSInteger, ServerConnStatus)
{
    CONNECTTIMEOUT,  //连接超时
    CONNECTBREAK,   //连接断开
    LOGOUTKICKOFF,  //重复登录，被服务器踢掉
};

// ------------------数据来源-------------------------------
typedef NS_ENUM(NSInteger, DataSender)
{
    SERVER,  //数据由服务器转发
    DEVICE, //数据由设备直接发送
};

// ------------------设备升级消息类型-------------------------------
typedef NS_ENUM(NSInteger, ModeuleUpgradeStyle)
{
    MODEULEUPDATE_CHECK,  //用户主动查询形式的固件更新
    MODEULEUPDATE_POST,   //服务器推送形式的固件更新
};

// ------------------设备升级消息类型-------------------------------
typedef NS_ENUM(NSInteger, FileDownloadType)
{
    REQ_MD5_CODE,  //请求下载文件时，请求内容为MD5
    REQ_MD5S_CODE, //请求下载文件时，请求内容为一组Md5
    REQ_FILE_CODE, //请求下载文件时，请求内容为文件内容
    ON_PROGRESS   //下载文件进行中
};

// ------------------配置设备WiFi的方式-------------------------------
typedef NS_ENUM(NSInteger, SetDeviceWiFiType)
{
    SET_WIFI_SMART,
    SET_WIFI_AP
    
};
// ------------------配置添加WiFi的方式-------------------------------
typedef NS_ENUM(NSInteger, SetAddWiFiType)
{
    SET_WIFI_UPDATE,
    SET_WIFI_ADD
    
};
// ------------------通知消息类型-------------------------------
typedef NS_ENUM(NSInteger, NotifyMessageType)
{
    BIND,
    UNBIND,
    TRANSFER
};

// ------------------设备分组相关操作-------------------------------
typedef NS_ENUM(NSInteger, DeviceGroupOptType)
{
    ADD,
    MODIFY,
    SAVE,
    DELETE
};

// ------------------设备升级类型-------------------------------
typedef NS_ENUM(NSInteger, ModuleUpdateType)
{
    OPTIONAL,
    MANDATORY
};

// ------------------设备升级过程中的状态-------------------------------
typedef NS_ENUM(NSInteger, ModuleUpdateStatus)
{
    START_DOWNLOAD,
    DOWNLOADING,
    DOWNLOAD_SUCCESS,
    DOWNLOAD_FAIL,
    START_UPGRADE,
    UPGRADING,
    UPGRADE_SUCCESS,
    UPGRADE_FAIL
};

// ------------------设备升级类型-------------------------------
typedef NS_ENUM(NSInteger, FeedbackType)
{
    Feed_APP,
    Feed_DEVICE,
};

// ------------------解绑类型-------------------------------
typedef NS_ENUM(NSInteger, UnbindType)
{
    HOST_UNBIND,  //主人解绑
    HOST_UNBIND_CLIENT,  //主人解绑客人
    COMMON_UNBIND,                          // 普通解绑：客人自己解绑、仅有主人时的解绑
    GATE_WAY_UNBIND                 //删除网关下子设备
};

// -----------设备aid周期性统计数据算法类型----------------
typedef NS_ENUM(NSInteger, DeviceAidStatisticAlgType)
{
    SUM,    //加法运算
    MUL     //乘法运算

};

// ------------------设备aid周期性统计数据周期类型-------------------------------
typedef NS_ENUM(NSInteger, DeviceAidStatisticPeriodType)
{
    YEAR,   //统计某年的
    MONTH,  //统计某月的
    WEEK,   //统计某周的
    DAY     //统计某日的
};

// ------------------设备类型-------------------------------
#define  DEVICE_NORMAL  @"0"
#define  DEVICE_GATEWAY  @"1"

// ------------------验证码类型-------------------------------
#define TYPE_SMS_REGISTER  @"1"  //注册
#define TYPE_SMS_MODIFY_PW @"7"  //修改密码
#define TYPE_SMS_CHANGE_PHONENO  @"6"  //修改手机号码

// ------------------设备扫码-------------------------------
#define NO_SCAN_CODE  @"noScan"




NS_ASSUME_NONNULL_END




