//
//  DeviceDvid.h
//  MachtalkSDK
//
//  Created by iMac on 16/3/10.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface DeviceDvid : NSObject

typedef NS_ENUM(NSInteger, DeviceDvidType)
{
    TYPE_INT = 1,
    TYPE_BOOLEAN,
    TYPE_GPS,
    TYPE_TEXT,
    TYPE_ENUM,
};


/**
 * dvid
 */
@property (nonatomic, assign) int dvid;
/**
 * dvid名称
 */
@property (nonatomic, strong) NSString *dvidName;

/**
 * dvid类型 1数值型 2布尔型 4泛型 5枚举型
 */
@property (nonatomic, assign) int dvidType;

/**
 * 枚举类型dvid的键值，键用于发送给设备，值用于向用户显示
 */
@property (nonatomic, strong) NSMutableDictionary *dvidValueDic;
/**
 * 数值类型的dvid的值取值的最大值
 */
@property (nonatomic, assign) int valueMax;

/**
 * 数值类型的dvid的值取值的最小值
 */
@property (nonatomic, assign) int valueMin;

/**
 * 数值类型的属性符号
 */
@property (nonatomic, strong) NSString *symbol;

/**
 * 数值类型的单位
 */
@property (nonatomic, strong) NSString *unit;

/**
 * dvid值是否是只读
 */
@property (nonatomic, assign) BOOL readOnly;
/**
 * 属性值列表
 */
@property (nonatomic, strong) NSMutableDictionary * valuelist;

@end
