//
//  Device.h
//  CloudLib
//
//  Created by iMac on 16/1/12.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <Foundation/Foundation.h>

@class XmlContainer;
@class DDXMLNode;
@class UpdateMessage;
@class DeviceInfoReportMessage;

@interface Device : NSObject

@property (nonatomic, strong) NSString* devId;                  // 设备id
@property (nonatomic, strong) NSString* name;                   // 设备名称
@property (nonatomic, strong) NSString* type;                   // 设备码，用于唯一标识一个型号的设备
@property (nonatomic, strong) NSString* modelId;                // 型号代码，用于唯一标识一个型号的设备
@property (nonatomic, strong) NSString* symbol;                 // 标识一个合作商

@property (nonatomic, strong) NSString* firm;                   // 厂商
@property (nonatomic, strong) NSString* product;                // 产品
@property (nonatomic, strong) NSString* model;                  // 型号
@property (nonatomic, strong) NSString* version;                // 版本号
@property (nonatomic, assign) BOOL online;                      // 是否在线
@property (nonatomic, strong) NSString* pin;                    // 设备pin码
@property (nonatomic, strong) NSString *lanPin;                 // 设备32位pin码的后16位

@property (nonatomic, assign) BOOL lanOnline;                   // 局域网内是否在线
@property (nonatomic, assign) BOOL isFirstShow;                 // 是否是第一次显示
@property (nonatomic, strong) NSString *msgId;                  // 标识一个设备发出的消息
@property (nonatomic, strong) NSMutableDictionary *status;      // 设备状态保存
@property (nonatomic, strong) NSString* order;                  // 在设备列表中的顺序
@property (nonatomic, strong) NSString* bindTime;                // 在设备列表中的顺序
@property (nonatomic, strong) XmlContainer *mainContainer;      // 设备详情页面保存
@property (nonatomic, strong) XmlContainer *previewContainer;   // 设备预览视图保存
@property (nonatomic, assign) BOOL isDefault;                   // 是否是默认设备
@property (nonatomic, strong) NSString *pid;                    // 父节点，针对网关设备, 0: 普通WIFI设备 1: 网关 其它: 网关下的子设备
@property (nonatomic, assign) BOOL noPreview;                   // 用户标识Config中预览视图配置是否为空
@property (nonatomic, strong) UpdateMessage * updateMessage;    //如果需要升级则保存升级信息
@property (nonatomic, assign) int otaStatus;                    // 更新版本状态
@property (nonatomic, assign) BOOL queryFailed;                 // 是否查询失败
@property (nonatomic, strong) DDXMLNode *mainRoot;              // 保存设备的根节点
@property (nonatomic, strong) DDXMLNode *previewRoot;           // 保存设备的根节点
@property (nonatomic, assign) BOOL needReQuery;                 // 是否需要重新查询
@property (nonatomic, assign) BOOL host;                        //当前用户是否为该设备的主人
@property (nonatomic, strong) DeviceInfoReportMessage *guessMsg;

@property (nonatomic, assign) BOOL isOld;            //是否是1.0设备，在局域网上线时，可以知道
@property (nonatomic, assign) BOOL isHTML5;          //页面显示方式，可能是HTML5或者XML

-(void)setType:(NSString*)type;
// 判断是否网关下的设备
-(BOOL)isSubDevice;

/**
 * 更新设备状态
 *
 * @param 状态 字典
 */
-(void)updateStatus:(NSDictionary*)partStatus;

/**
 *  更新缓存中某个dvid的值
 *
 *  @param value
 */
-(void)updateStatus:(NSString *)dvid value:(NSString *)value;

-(NSString*)getZipFileName;
-(NSString*)getFolderName;
-(NSString*)toString;
// 判断是否网关下的设备
-(UIImage*)getConfigIcon;
-(UIImage*)getModelIcon;

/**
 * 设置设备状态详细信息，一般用在查询设备信息成功后调用
 *
 * @param 状态 字典
 */
-(void)setStatus:(NSMutableDictionary *)status;

-(NSString *)getFullLanPin;

@end
