//
//  BusinessMessage.h
//  CloudLib
//
//  Created by iMac on 16/1/11.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import "Message.h"

@interface BusinessMessage : Message

@property (nonatomic, strong) NSString *cmd;        //消息的命令码，用于区分每个不同类型的消息
@property (nonatomic, strong) NSString *mid;        //消息的编号，保证每个消息的编号不同
@property (nonatomic, strong) NSString *from;       //消息的发送者
@property (nonatomic, strong) NSString *sid;        //针对网关下的设备
@property (nonatomic, assign) int success;          //消息执行是否成功，在response中用到

/**
 * 传入消息命令码，初始化消息
 */
-(instancetype)initWithCmd:(NSString*)cmd;

/**
 * 获取消息的字节数组，直接用于发送消息
 *
 * @param 包序号
 */
-(NSData *)getData:(Connection *)connection;

/**
 * 用来处理接收到得json数据
 *
 * @param json的map
 */
-(BOOL)handle:(NSMutableDictionary *)json;

/**
 * 返回成功的处理逻辑
 */
-(void)onSuccess:(NSMutableDictionary *)json;

/**
 * 返回失败的处理逻辑
 */
-(void)onFail;

/**
 * 设置了标记位，同时设备在线
 */
-(BOOL)isNeedResend;

/**
 * 获取消息所要发送的json消息
 */
-(NSString*)getJson;

@end
