//
//  AddDeviceUtil.h
//  CloudLib
//
//  Created by iMac on 16/1/18.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface AddDeviceUtil : NSObject

@property (nonatomic, assign) BOOL addOver;
//TODO server
@property (nonatomic, assign) int port;
//TODO server
@property (nonatomic, strong) NSString *ssid;
@property (nonatomic, strong) NSString *password;
@property (nonatomic, strong) NSString *bindType;
@property (nonatomic, strong) NSString *ip;
@property (nonatomic, assign) int socket;
@property (nonatomic, assign) NSString * deviceSSID;
@property (nonatomic, assign) int configType;
@property (nonatomic, assign) BOOL addDeviceWIFI;

-(id)initWithSSID:(NSString*)ssid pwd:(NSString*)pwd;


/**
 * 添加设备时，扫描是否可以直接添加成功
 * 1、原则上以2开头的二维码表示可以直接添加，添加格式最好按照如下方式
 * 		平板电脑直接扫描时的二维码格式是 12位型号 + '-' + 18位设备ID + '-' + 32位PIN码
 * 2、原则上以1开头的二维码表示需要走WIFI的添加流程
 * @param code
 * @return
 */
+(BOOL)canAddDirect:(NSString*)code;

/**
 * 判断是否未扫描码
 *
 * @param code字符串
 *
 * @result
 */

+(BOOL)isShareCode:(NSString*)code;

/**
 * 检测是否为设备码
 * 有些码包含了app下载地址，以‘？’分隔下载地址与设备型号
 * 如：http://api.machtalk.net/v1.1/app/8/download?300WJL008D01
 * @param code
 * @return
 */
+(BOOL)checkScanCode:(NSString*)code;

/**
 * 解析url格式字符串，获取其中的设备类型code
 * @param url
 * @return
 */
+(NSString*)parseCode:(NSString*)url;

/**
 * 目前二维码设置了四种类型分别如下：
 * 100开头：普通WIFI设备，需要扫码，需要配置WIFI
 * 200开头：针对设备本身可以显示二维的设备，需要扫描，不需要配置WIFI，即扫描即可添加完成
 * 300开头：普通WIFI设备，但是不需要扫码，但需要配置WIFI，这类设备的内部扫写的型号是完全正确的，因此无需扫描
 * 400开头：针对网关插件设备，不需要扫描，同时也不需要配置WIFI，通过搜索直接添加完成
 * 500开头：针对网关下的433设备，无需主动添加，也不能配置WIFI
 *
 * 这里获取真实的设备类型码，主要是进行一定的校验，校验失败则直接返回空，校验成功返回正确的二维码，原则如下
 * 如果产品本身无需扫描，则产品的类型码应该以300或者400开头，并且长度大于等于12位才合法
 * 如果产品需要扫描，则检查产品本身的类型码和扫描的二维码，在产品类型字段是否保持一致，如果不一致，表示扫描错误
 *
 * @param scanCode
 * @param proCode
 * @return
 * 		如果校验OK，返回真正的产品类型码，否则返回null
 */
+(NSString*)getRealCode:(NSString*)scanCode productCode:(NSString*)proCode;

/**
 * 检查设备是否支持更新WIFI
 * @param type
 * @return
 */
+(int)isSupportUpdate:(NSString*)type;

/**
 * 启动快连方式
 */
-(void)smartStart;
-(void)smartStop;

-(void)start;
-(void)stop;

@end
