//
//  ACLManager.h
//  MachtalkSDK
//
//  Created by zhaishengfei on 16/9/30.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 * 全码库管理器，负责注册，使用，保存等所有接口
 */



@class Result;
@class ACLCompleteCode;
@class TimerTask;

@interface ACLManager : NSObject


+(instancetype)Instance;

/**
 *  自动获取红外码库列表
 *  @param
 *      data: 匹配参数
 *      language: "cn"中文 "en"英文
 */
-(void)ACL_IR_code_list:(NSString *)data lan:(NSString *)language;

/**
 *  开始全码库匹配，每次匹配必须调用
 */
-(void)ACL_begin;

/**
 *  结束全码库匹配，匹配结束，无论成功失败，必须调用
 */
-(void)ACL_end;

/**
 *  获取可以匹配的所有设备类型列表，为以后设备类型预留，现只支持空调类型，可以跳过
 */
-(void)ACL_get_deviceTypes:(NSNumber *)Id;

/**
 *  获取可以匹配的所有设备品牌列表
 */
-(void)ACL_get_brands:(NSNumber *)Id;

/**
 *  获取某品牌设备的遥控器列表
 *  @param
 *      brandID: 品牌ID
 */
-(void)ACL_get_controllers:(NSNumber *)Id andBrand:(int)brandID;

/**
 *  获取某个遥控器的完整码
 *  @param
 *      rid: 遥控器ID
 */
-(void)ACL_get_complete_code:(NSNumber *)Id rid:(NSString *)rid;

/**
 *  操作全码库设备, 一次只能操作一个属性
 *  @param
 *      did: 设备id
 *      cc: 完整码
 *      as: {
 *              "1":"0",    // 关机
 *              "1":"1",    // 开机
 *              "2":"0",    // 自动模式
 *              "2":"1",    // 制冷模式
 *              "2":"2",    // 送风模式
 *              "2":"3",    // 制热模式
 *              "2":"4",    // 抽湿模式
 *              "3":"26",   // 温度
 *          }
 */
-(void)ACL_opt_device:(NSString *)did cc:(ACLCompleteCode *)cc as:(NSMutableDictionary *)as;

/**
 *  转换普通定时任务命令为全码库命令
 *  @param
 *      did: 设备id
 *      cc: 完整码
 *      tt: 赋完初值的定时任务
 */
-(void)ACL_transfer_C2A_tt:(ACLCompleteCode *)cc tt:(TimerTask *)tt;

/**
 *  转换全码库命令为普通定时任务命令
 *  @param
 *      tt: 赋完初值的定时任务
 */
-(void)ACL_transfer_A2C_tt:(TimerTask *)tt;




// ---------------------private--------------------
-(void)onHandleSuccess:(NSDictionary *)as;
-(void)onHandleFail:(Result*)result;


@end
