//
//  ACLControllerInfo.h
//  MachtalkSDK
//
//  Created by zhaishengfei on 16/9/14.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 * 全码库设备遥控器信息
 */

@interface ACLControllerInfo : NSObject

//@property (nonatomic, strong) NSString *m_ctrlID;        // 遥控器ID
//@property (nonatomic, strong) NSString *m_brandName;     // 品牌名称
//@property (nonatomic, assign) int       m_typeID;        // 设备类型
//@property (nonatomic, strong) NSString *m_be_rmodel;     // 被遥控型号
//@property (nonatomic, strong) NSString *m_rmodel;        // 遥控型号
//@property (nonatomic, strong) NSString *m_rdesc;         // 自定义设备描述
//@property (nonatomic, assign) int       m_order_no;      // 排序号

@property (nonatomic, copy)    NSString *mRid;            // 遥控器ID
@property (nonatomic, strong)  NSNumber *mZip;            // 遥控码压缩类型 :0、不压缩  1、压缩1算法  2、压缩2算法
@property (nonatomic, strong)  NSNumber *mVersion;        // 版本
@property (nonatomic, copy)    NSDictionary *mRc_command; // 遥控器命令


/**
 * 发送测试开机命令给设备
 * devId: 设备Id
 */
-(BOOL)OnTestOnCommand:(NSString *)devId;


@end
