//
//  ACLCompleteCode.h
//  MachtalkSDK
//
//  Created by zhaishengfei on 16/9/29.
//  Copyright © 2016年 Aibo. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 * 全码库设备完整码
 */

@interface ACLCompleteCode : NSObject

@property (nonatomic, copy)    NSString *mRid;            // 遥控器ID
@property (nonatomic, strong)  NSArray *mCompleteCode;    // 完整码

-(instancetype)initWithCC:(NSString *)rid cc:(NSArray *)completeCode;

/**
 * 将可行的开机码对应的遥控器ID发送给设备
 * devId: 设备Id
 */
-(BOOL)OnSendRidToDevice:(NSString *)devId;





@end
