/*
 * Decompiled with CFR 0.152.
 */
package com.mico.wifi;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;

public class EasyLinkWifiManager {
    private WifiManager mWifiManager = null;
    private WifiInfo mWifiInfo = null;
    private Context mContext = null;
    private static final int BUILD_VERSION_JELLYBEAN = 17;

    public EasyLinkWifiManager(Context mContext) {
        this.mContext = mContext;
        this.mWifiManager = (WifiManager)mContext.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
    }

    public String getBaseSSID() {
        return this.mWifiInfo.getBSSID();
    }

    public String getCurrentSSID() {
        return EasyLinkWifiManager.removeSSIDQuotes(this.mWifiInfo.getSSID());
    }

    public boolean isWifiConnected() {
        ConnectivityManager connManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        NetworkInfo mWifi = connManager.getNetworkInfo(1);
        return mWifi.isConnected();
    }

    public String getCurrentIpAddressConnected() {
        int ipval = this.mWifiInfo.getIpAddress();
        String ipString = String.format("%d.%d.%d.%d", ipval & 0xFF, ipval >> 8 & 0xFF, ipval >> 16 & 0xFF, ipval >> 24 & 0xFF);
        return ipString.toString();
    }

    public int getCurrentIpAddressConnectedInt() {
        int ipval = this.mWifiInfo.getIpAddress();
        return ipval;
    }

    public String getGatewayIpAddress() {
        int gatwayVal = this.mWifiManager.getDhcpInfo().gateway;
        return String.format("%d.%d.%d.%d", gatwayVal & 0xFF, gatwayVal >> 8 & 0xFF, gatwayVal >> 16 & 0xFF, gatwayVal >> 24 & 0xFF).toString();
    }

    public static String removeSSIDQuotes(String connectedSSID) {
        int currentVersion = Build.VERSION.SDK_INT;
        if (currentVersion >= 17 && connectedSSID.startsWith("\"") && connectedSSID.endsWith("\"")) {
            connectedSSID = connectedSSID.substring(1, connectedSSID.length() - 1);
        }
        return connectedSSID;
    }
}

