/*
 * Decompiled with CFR 0.152.
 */
package com.machtalk.sdk.domain;

import com.machtalk.sdk.connect.MachtalkSDKConstant;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class ModuleVersionInfo {
    private String mDeviceId;
    private int mOtaType = -1;
    private String mVersion = null;
    private String mNewVersion = null;
    private boolean mCancel;
    private String mInfo = null;
    private long mTime;

    public ModuleVersionInfo() {
    }

    public ModuleVersionInfo(String string) {
        this.mDeviceId = string;
    }

    public void initFromJson(JSONObject jSONObject) throws JSONException {
        if (jSONObject == null) {
            return;
        }
        if (jSONObject.has("from")) {
            this.mDeviceId = jSONObject.optString("from");
        } else if (jSONObject.has("did")) {
            this.mDeviceId = jSONObject.optString("did");
        } else if (jSONObject.has("sid")) {
            this.mDeviceId = jSONObject.optString("sid");
        }
        if (jSONObject.has("otaType")) {
            this.mOtaType = jSONObject.optInt("otaType");
        }
        if (jSONObject.has("ver")) {
            this.mVersion = jSONObject.optString("ver");
        }
        if (jSONObject.has("newVer")) {
            this.mNewVersion = jSONObject.optString("newVer");
        }
        if (jSONObject.has("info")) {
            this.mInfo = jSONObject.optString("info");
        }
        if (jSONObject.has("ts")) {
            this.mTime = Long.parseLong(jSONObject.getString("ts"));
        }
        if (jSONObject.has("cancel")) {
            int n2 = jSONObject.optInt("cancel", 1);
            this.mCancel = n2 == 1;
        }
    }

    public MachtalkSDKConstant.MODULE_UPGRADE_TYPE getType() {
        switch (this.mOtaType) {
            case 0: {
                return MachtalkSDKConstant.MODULE_UPGRADE_TYPE.MODULE;
            }
            case 1: {
                return MachtalkSDKConstant.MODULE_UPGRADE_TYPE.DEVICE;
            }
        }
        return MachtalkSDKConstant.MODULE_UPGRADE_TYPE.ERROR;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getNewVersion() {
        return this.mNewVersion;
    }

    public String getVersionInfo() {
        return this.mInfo;
    }

    public Long getVersionTime() {
        return this.mTime;
    }

    public String getDeviceId() {
        return this.mDeviceId;
    }

    public boolean isUpgradeCanCancel() {
        return this.mCancel;
    }

    public String getTimeStr() {
        Date date = new Date(this.mTime);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        return simpleDateFormat.format(date);
    }
}

